using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using System.Xml.Serialization;
using WeifenLuo.WinFormsUI;
using WeifenLuo.WinFormsUI.Docking;

namespace PeerCastMultiPlayer2
{
    [Serializable()]
    public class NetworkSetting
    {
        private string hostAddr = "localhost:7144";
        private int timeOut = 30000;
        private int httpProtocol = 0;
        private bool useProxy = false;
        private bool useIEProxy = false;
        private string proxyAddr = "localhost:8080";

        public string ProxyAddr
        {
            get { return proxyAddr; }
            set { proxyAddr = value; }
        }
        public bool UseProxy
        {
            get { return useProxy; }
            set { useProxy = value; }
        }

        public bool UseIEProxy
        {
            get { return useIEProxy; }
            set { useIEProxy = value; }
        }
        public int HttpProtocol
        {
            get { return httpProtocol; }
            set { httpProtocol = value; }
        }

        public int TimeOut
        {
            get { return timeOut; }
            set { timeOut = value; }
        }

        public string HostAddr
        {
            get { return hostAddr; }
            set { hostAddr = value; }
        }
    }

    [Serializable()]
    public class GeneralSetting : ICloneable
    {
        // ---------------------------------------------------------- //
        // tB[h
        // ---------------------------------------------------------- //
        private string peerCastPath = @"C:\Program Files\PeerCast\PeerCast.exe";
        private bool useOtherBrowser = false;
        private string otherBrowserPath = string.Empty;
        //private bool useOtherPlayer = false;
        //private string otherPlayerPath = string.Empty;
        private bool runAsMinimize = false;
        private bool runAtPeerCast = false;
        private bool showGridLine = false;
        private bool notifyComplete = true;
        private bool multiOption = false;
        private string templatePath = string.Empty;
        //private DockState dockState = DockState.DockBottomAutoHide;
        private bool notifyNew = true;
        private bool notifyFavorite = true;
        private bool showTooltip = true;
        private bool showExitDialog = true;
        private Color listViewBack = Color.FromKnownColor(KnownColor.Window);
        private Color listViewGrid = Color.FromKnownColor(KnownColor.ControlDark);
        private bool closePCastOnExit = false;
        private bool useBrowserOnYPViewer = false;
        private bool use2chBrowser = false;
        private string browser2chPath = string.Empty;
        private bool trayOnMinimize = true;
        private bool returnOnSingleClick = false;
        private string regex2chUrl = "2ch\\.net";
        private bool getAtRun = false;
        private bool frozenAtChannelName = true;
        private int priority = 2; // Normal
        private NetworkSetting networkSetting = new NetworkSetting();
        private bool changePriority;
        private bool doNotShowErrorChannel;
        private bool showTabAll = true;
        private bool showTabFavorite = true;
        private bool showTabEnded = true;
        private bool showTabHistory = true;

        public bool DoNotShowErrorChannel
        {
            get { return doNotShowErrorChannel; }
            set { doNotShowErrorChannel = value; }
        }

        public bool ShowTabAll
        {
            get { return showTabAll; }
            set { showTabAll = value; }
        }

        public bool ShowTabFavorite
        {
            get { return showTabFavorite; }
            set { showTabFavorite = value; }
        }

        public bool ShowTabEnded
        {
            get { return showTabEnded; }
            set { showTabEnded = value; }
        }

        public bool ShowTabHistory
        {
            get { return showTabHistory; }
            set { showTabHistory = value; }
        }

        public bool ChangePriority
        {
            get { return changePriority; }
            set { changePriority = value; }
        }

        public NetworkSetting NetworkSetting
        {
            get { return networkSetting; }
            set { networkSetting = value; }
        }

        public int Priority
        {
            get { return priority; }
            set { priority = value; }
        }

        public string Regex2chUrl
        {
            get { return regex2chUrl; }
            set { regex2chUrl = value; }
        }

        public bool ReturnOnSingleClick
        {
            get { return returnOnSingleClick; }
            set { returnOnSingleClick = value; }
        }

        public bool TrayOnMinimize
        {
            get { return trayOnMinimize; }
            set { trayOnMinimize = value; }
        }

        public string Browser2chPath
        {
            get { return browser2chPath; }
            set { browser2chPath = value; }
        }

        public bool Use2chBrowser
        {
            get { return use2chBrowser; }
            set { use2chBrowser = value; }
        }

        public bool UseBrowserOnYPViewer
        {
            get { return useBrowserOnYPViewer; }
            set { useBrowserOnYPViewer = value; }
        }

        [XmlIgnore()]
        public Color ListViewBack
        {
            get { return listViewBack; }
            set { listViewBack = value; }
        }

        [XmlElement("ListViewBack")]
        public String XmlListViewBack
        {
            get { return Serializer.SerializeColor(listViewBack); }
            set { listViewBack = Serializer.DeserializeColor(value); }
        }

        [XmlIgnore()]
        public Color ListViewGrid
        {
            get { return listViewGrid; }
            set { listViewGrid = value; }
        }

        [XmlElement("ListViewGrid")]
        public string XmlListViewGrid
        {
            get { return Serializer.SerializeColor(listViewGrid); }
            set { listViewGrid = Serializer.DeserializeColor(value); }
        }

        public bool ShowExitDialog
        {
            get { return showExitDialog; }
            set { showExitDialog = value; }
        }

        public string TemplatePath
        {
            get { return templatePath; }
            set { templatePath = value; }
        }

        public bool MultiOption
        {
            get { return multiOption; }
            set { multiOption = value; }
        }

        public bool NotifyComplete
        {
            get { return notifyComplete; }
            set { notifyComplete = value; }
        }

        public bool NotifyNew
        {
            get { return notifyNew; }
            set { notifyNew = value; }
        }

        public bool NotifyFavorite
        {
            get { return notifyFavorite; }
            set { notifyFavorite = value; }
        }

        public bool ShowGridLine
        {
            get { return showGridLine; }
            set { showGridLine = value; }
        }

        public string OtherBrowserPath
        {
            get { return otherBrowserPath; }
            set { otherBrowserPath = value; }
        }

        public string PeerCastPath
        {
            get { return peerCastPath; }
            set { peerCastPath = value; }
        }

        public bool RunAsMinimize
        {
            get { return runAsMinimize; }
            set { runAsMinimize = value; }
        }

        public bool RunAtPeerCast
        {
            get { return runAtPeerCast; }
            set { runAtPeerCast = value; }
        }

        public bool UseOtherBrowser
        {
            get { return useOtherBrowser; }
            set { useOtherBrowser = value; }
        }

        public bool ShowTooltip
        {
            get { return showTooltip; }
            set { showTooltip = value; }
        }

        public bool ClosePCastOnExit
        {
            get { return closePCastOnExit; }
            set { closePCastOnExit = value; }
        }

        public bool GetAtRun
        {
            get { return getAtRun; }
            set { getAtRun = value; }
        }

        public bool FrozenAtChannelName
        {
            get { return frozenAtChannelName; }
            set { frozenAtChannelName = value; }
        }

        // ---------------------------------------------------------- //
        // \bh                                                   //
        // ---------------------------------------------------------- //
        public void Save()
        {
            Serializer.Save("Config.xml", this);
        }

        public static GeneralSetting Load()
        {
            return Serializer.Load("Config.xml", typeof(GeneralSetting)) as GeneralSetting;
        }

        #region ICloneable o

        public object Clone()
        {
            return MemberwiseClone();
        }

        #endregion
    }

    [Serializable()]
    public class ApplicationSetting
    {
        // ---------------------------------------------------------- //
        // tB[h                                                 //
        // ---------------------------------------------------------- //
        private int windowPosX;
        private int windowPosY;
        private int windowHeight;
        private int windowWidth;
        private FormWindowState windowState;
        private double dockTopPortion = 0.25;
        private double dockBottomPortion = 0.25;
        private double dockRightPortion = 0.25;
        private double dockLeftPortion = 0.25;
        private DockState dockState = DockState.DockBottom;
        private List<ColumnSetting> columns;
        public ViewerSetting viewer;

        public int WindowPosX
        {
            get { return windowPosX; }
            set { windowPosX = value; }
        }

        public int WindowPosY
        {
            get { return windowPosY; }
            set { windowPosY = value; }
        }

        public int WindowHeight
        {
            get { return windowHeight; }
            set { windowHeight = value; }
        }

        public int WindowWidth
        {
            get { return windowWidth; }
            set { windowWidth = value; }
        }

        public FormWindowState WindowState
        {
            get { return windowState; }
            set { windowState = value; }
        }

        public double DockTopPortion
        {
            get { return dockTopPortion; }
            set { dockTopPortion = value; }
        }

        public double DockBottomPortion
        {
            get { return dockBottomPortion; }
            set { dockBottomPortion = value; }
        }

        public double DockRightPortion
        {
            get { return dockRightPortion; }
            set { dockRightPortion = value; }
        }

        public double DockLeftPortion
        {
            get { return dockLeftPortion; }
            set { dockLeftPortion = value; }
        }

        public DockState DockState
        {
            get { return dockState; }
            set { dockState = value; }
        }

        public List<ColumnSetting> Columns
        {
            get { return columns; }
            set { columns = value; }
        }

        // ---------------------------------------------------------- //
        // \bh                                                   //
        // ---------------------------------------------------------- //
        public void Save()
        {
            Serializer.Save("Application.xml", this);
        }

        public static ApplicationSetting Load()
        {
            return (ApplicationSetting)Serializer.Load("Application.xml", typeof(ApplicationSetting));
        }
    }

    [Serializable]
    public class ViewerSetting
    {
        // YP-Viewer
        public Point ViewerPos;
        public Size ViewerSize;
        public string ViewerTempDir;
    }

    [Serializable]
    public class ColumnSetting
    {
        public int width;
        public bool visible;
        public string text;
        public int displayIndex;
    }
}