using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace PeerCastMultiPlayer2
{
    [Serializable()]
    public class FavSetting
    {
        public static void Save(FavSetting[] target)
        {
            Serializer.Save("Favorites.xml", target);
        }

        public static FavSetting[] Load()
        {
            FavSetting[] obj =
                Serializer.Load("Favorites.xml", typeof(FavSetting[])) as FavSetting[];
            if (obj == null) return null;
            return obj;
        }

        private bool showballoon = true;

        public bool ShowBalloon
        {
            get { return showballoon; }
            set { showballoon = value; }
        }


        private string favoriteName = string.Empty;

        public string FavoriteName
        {
            get { return favoriteName; }
            set { favoriteName = value; }
        }

        private string searchString = string.Empty;

        public string SearchString
        {
            get { return searchString; }
            set { searchString = value; }
        }

        private bool ng /* = false*/;

        public bool NG
        {
            get { return ng; }
            set { ng = value; }
        }

        private bool findChannelName = true;

        public bool FindChannelName
        {
            get { return findChannelName; }
            set { findChannelName = value; }
        }

        private bool findDetail /* = false*/;

        public bool FindDetail
        {
            get { return findDetail; }
            set { findDetail = value; }
        }

        private bool findContactUrl /* = false*/;

        public bool FindContactUrl
        {
            get { return findContactUrl; }
            set { findContactUrl = value; }
        }

        private bool findYelloPageUrl /* = false*/;

        public bool FindYelloPageUrl
        {
            get { return findYelloPageUrl; }
            set { findYelloPageUrl = value; }
        }

        private bool findComment /* = false*/;

        public bool FindComment
        {
            get { return findComment; }
            set { findComment = value; }
        }

        private bool allFind /* = false*/;

        public bool AllFind
        {
            get { return allFind; }
            set { allFind = value; }
        }

        private bool useRegEx /* = false*/;

        public bool UseRegEx
        {
            get { return useRegEx; }
            set { useRegEx = value; }
        }

        private Color textColor;

        [XmlIgnore()]
        public Color TextColor
        {
            get { return textColor; }
            set { textColor = value; }
        }

        [XmlElement("TextColor")]
        public string XmlTextColor
        {
            get { return Serializer.SerializeColor(TextColor); }
            set { TextColor = Serializer.DeserializeColor(value); }
        }

        private Color backColor;

        [XmlIgnore()]
        public Color BackColor
        {
            get { return backColor; }
            set { backColor = value; }
        }

        [XmlElement("BackColor")]
        public string XmlBackColor
        {
            get { return Serializer.SerializeColor(BackColor); }
            set { BackColor = Serializer.DeserializeColor(value); }
        }

        private Font favFont;

        [XmlIgnore()]
        public Font FavFont
        {
            get { return favFont; }
            set { favFont = value; }
        }

        [XmlElement("FavFont")]
        public XmlFont XmlFavFont
        {
            get { return Serializer.SerializeFont(FavFont); }
            set { FavFont = Serializer.DeserializeFont(value); }
        }

        private string soundPath = string.Empty;

        public string SoundPath
        {
            get { return soundPath; }
            set { soundPath = value; }
        }

        private bool enable = true;

        public bool Enable
        {
            get { return enable; }
            set { enable = value; }
        }
    }
}