using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Xml.Serialization;
using System.IO;
using System.Windows.Forms;
using System.Runtime.Serialization.Formatters.Soap;

namespace ConfigConverter
{
    public static class Serializer
    {
        public static void Save(string file, object saveObj)
        {
            if (saveObj == null) throw new ArgumentNullException();
            FileStream fs = null;
            try
            {
                SoapFormatter soapFormatter = new SoapFormatter();
                fs = new FileStream(file, FileMode.Create);
                soapFormatter.Serialize(fs, saveObj);
            }
            catch { }
            finally
            {
                if(fs != null)fs.Close();
            }
        }

        public static object Load(string file, Type objType)
        {
            string fileName = Path.Combine(Application.StartupPath, "Config\\" + file);
            FileStream fs = null;
            Object obj = null;
            try
            {
                SoapFormatter sf = new SoapFormatter();
                fs = new FileStream(fileName, FileMode.Open);
                obj = sf.Deserialize(fs);
            }
            catch
            {
                return null;
            }
            finally
            {
                if (fs != null) fs.Close();
            }
            return obj;
        }
    }
}
