﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;

namespace ConfigConverter
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = Application.StartupPath;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox2.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (textBox1.Text.Length == 0) return;
            if (textBox2.Text.Length == 0) return;
            if (!Directory.Exists(textBox1.Text)) return;
            if (!Directory.Exists(textBox2.Text))
                Directory.CreateDirectory(textBox2.Text);
            button3.Enabled = false;
            label3.Text =  "Application.xml";
            Application.DoEvents();
            ConvAppSetting();
            label3.Text = "Favorites.xml";
            Application.DoEvents();
            ConvFavSetting();
            label3.Text = "PlayTypes.xml";
            Application.DoEvents();
            ConvPlayerSetting();
            label3.Text = "Tools.xml";
            Application.DoEvents();
            ConvToolSetting();
            label3.Text = "YelloPages.xml";
            Application.DoEvents();
            ConvYpSetting();
            label3.Text = "Config.xml";
            Application.DoEvents();
            ConvGeneralSetting();
            label3.Text = "FilterSetting.xml";
            Application.DoEvents();
            ConvFilterSetting();
            label3.Text = "完了";
            button3.Enabled = false;
        }

        private void ConvAppSetting()
        {
            Object obj = LoadSetting(Path.Combine(textBox1.Text, "Application.xml"), typeof(PeerCastMultiPlayer2.ApplicationSetting));
            if (obj == null) return;
            PeerCastMultiPlayer2.ApplicationSetting a = obj as PeerCastMultiPlayer2.ApplicationSetting;
            if (a == null) return;
            pcmp.Setting.ApplicationSetting app = new pcmp.Setting.ApplicationSetting();
            app.DockBottomPortion = a.DockBottomPortion;
            app.DockLeftPortion = a.DockLeftPortion;
            app.DockRightPortion = a.DockRightPortion;
            app.DockState = a.DockState;
            app.DockTopPortion = a.DockTopPortion;
            app.WindowHeight = a.WindowHeight;
            app.WindowPosX = a.WindowPosX;
            app.WindowPosY = a.WindowPosY;
            app.WindowState = a.WindowState;
            app.WindowWidth = a.WindowWidth;
            Save(app, textBox2.Text);
        }

        private void ConvFavSetting()
        {
            Object obj = LoadSetting(Path.Combine(textBox1.Text, "Favorites.xml"), typeof(PeerCastMultiPlayer2.FavSetting[]));
            if (obj == null) return;
            PeerCastMultiPlayer2.FavSetting[] f = (PeerCastMultiPlayer2.FavSetting[])obj;
            if (f == null) return;
            List<pcmp.Setting.FavSetting> favList = new List<pcmp.Setting.FavSetting>();
            List<pcmp.Setting.NGSetting> ngList = new List<pcmp.Setting.NGSetting>();

            foreach (PeerCastMultiPlayer2.FavSetting i in f)
            {
                if (i.NG)
                {
                    pcmp.Setting.NGSetting ng = new pcmp.Setting.NGSetting();
                    ng.SerachAfterConcat = i.AllFind;
                    ng.Enable = i.Enable;
                    ng.Name = i.FavoriteName;
                    ng.SearchChannelName = i.FindChannelName;
                    ng.SearchComment = i.FindComment;
                    ng.SearchDetail = i.FindDetail;
                    ng.SearchContactUrl = i.FindContactUrl;
                    ng.SearchYelloPageUrl = i.FindYelloPageUrl;
                    ng.SearchString = i.SearchString;
                    ng.UseRegex = i.UseRegEx;
                    ngList.Add(ng);
                    continue;
                }

                pcmp.Setting.FavSetting fav = new pcmp.Setting.FavSetting();
                fav.SerachAfterConcat = i.AllFind;
                fav.BackColor = i.BackColor;
                fav.Enable = i.Enable;
                fav.Font = i.FavFont;
                fav.Name = i.FavoriteName;
                fav.SearchChannelName = i.FindChannelName;
                fav.SearchComment = i.FindComment;
                fav.SearchDetail = i.FindDetail;
                fav.SearchContactUrl = i.FindContactUrl;
                fav.SearchYelloPageUrl = i.FindYelloPageUrl;
                fav.SearchString = i.SearchString;
                fav.SoundPath = i.SoundPath;
                fav.TextColor = i.TextColor;
                fav.UseRegex = i.UseRegEx;
                favList.Add(fav);
            }

            Save(favList.ToArray(), textBox2.Text);
            Save(ngList.ToArray(), textBox2.Text);
        }

        private void ConvPlayerSetting()
        {
            Object obj = LoadSetting(Path.Combine(textBox1.Text, "PlayTypes.xml"), typeof(PeerCastMultiPlayer2.PlayerSetting[]));
            if (obj == null) return;
            PeerCastMultiPlayer2.PlayerSetting[] p = (PeerCastMultiPlayer2.PlayerSetting[])obj;
            List<pcmp.Setting.PlayerSetting> pList = new List<pcmp.Setting.PlayerSetting>();

            foreach (PeerCastMultiPlayer2.PlayerSetting i in p)
            {
                pcmp.Setting.PlayerSetting ps = new pcmp.Setting.PlayerSetting();
                ps.Path = i.Player;
                ps.Type = i.Type;
                ps.Argument = i.Argument;
                pList.Add(ps);
            }

            Save(pList.ToArray(), textBox2.Text);
        }

        private void ConvToolSetting()
        {
            Object obj = LoadSetting(Path.Combine(textBox1.Text, "Tools.xml"), typeof(PeerCastMultiPlayer2.ToolSetting[]));
            if (obj == null) return;
            PeerCastMultiPlayer2.ToolSetting[] t = (PeerCastMultiPlayer2.ToolSetting[])obj;
            List<pcmp.Setting.ToolSetting> tsList = new List<pcmp.Setting.ToolSetting>();

            foreach (PeerCastMultiPlayer2.ToolSetting i in t)
            {
                pcmp.Setting.ToolSetting ts = new pcmp.Setting.ToolSetting();
                ts.Argument = i.Arg;
                ts.Name = i.Name;
                ts.Path = i.Path;
                tsList.Add(ts);
            }

            Save(tsList.ToArray(), textBox2.Text);
        }

        private void ConvYpSetting()
        {
            Object obj = LoadSetting(Path.Combine(textBox1.Text, "YelloPages.xml"), typeof(PeerCastMultiPlayer2.YpSetting[]));
            if (obj == null) return;
            PeerCastMultiPlayer2.YpSetting[] y = (PeerCastMultiPlayer2.YpSetting[])obj;
            List<pcmp.Setting.YpSetting> ypList = new List<pcmp.Setting.YpSetting>();

            foreach (PeerCastMultiPlayer2.YpSetting i in y)
            {
                pcmp.Setting.YpSetting yp = new pcmp.Setting.YpSetting();
                yp.BackColor = i.BackColor;
                yp.ContactFontStyle = FontStyle.Regular;
                if (i.ContactBold) yp.ContactFontStyle |= FontStyle.Bold;
                if (i.ContactItalic) yp.ContactFontStyle |= FontStyle.Italic;
                if (i.ContactStrike) yp.ContactFontStyle |= FontStyle.Strikeout;
                if (i.ContactULine) yp.ContactFontStyle |= FontStyle.Underline;
                yp.ContactColor = i.ContactColor;
                yp.DirectFontStyle = FontStyle.Regular;
                if (i.DirectBold) yp.DirectFontStyle |= FontStyle.Bold;
                if (i.DirectItalic) yp.DirectFontStyle |= FontStyle.Italic;
                if (i.DirectStrike) yp.DirectFontStyle |= FontStyle.Strikeout;
                if (i.DirectULine) yp.DirectFontStyle |= FontStyle.Underline;
                yp.DirectColor = i.DirectColor;
                yp.EnableYP = i.EnableYP;
                yp.TextColor = i.TextColor;
                yp.YpAddr = i.YPAddr;
                yp.YpName = i.YPName;
                yp.Font = i.ListFont;
                ypList.Add(yp);
            }

            Save(ypList.ToArray(), textBox2.Text);
        }

        private void ConvGeneralSetting()
        {
            Object obj = LoadSetting(Path.Combine(textBox1.Text, "Config.xml"), typeof(PeerCastMultiPlayer2.GeneralSetting));
            if (obj == null) return;
            PeerCastMultiPlayer2.GeneralSetting s = obj as PeerCastMultiPlayer2.GeneralSetting;
            pcmp.Setting.GeneralSetting g = new pcmp.Setting.GeneralSetting();
            g.Browser2chPath = s.Browser2chPath;
            g.ClosePeerCastOnExit = s.ClosePCastOnExit;
            g.FrozenAtChannelName = s.FrozenAtChannelName;
            g.GetYpOnStartup = s.GetAtRun;
            g.ListViewBack = s.ListViewBack;
            g.UseMultiOption = s.MultiOption;
            g.ShowYpBalloon = s.NotifyComplete;
            g.ShowFavoriteBalloon = s.NotifyFavorite;
            g.ShowNewBalloon = s.NotifyNew;
            g.BrowserPath = s.OtherBrowserPath;
            g.PeerCastPath = s.PeerCastPath;
            g.Regex2chUrl = s.Regex2chUrl;
            g.SingleClickToReturn = s.ReturnOnSingleClick;
            g.RunAsMinimize = s.RunAsMinimize;
            g.RunPeerCastOnStartup = s.RunAtPeerCast;
            g.ShowExitDialog = s.ShowExitDialog;
            g.ShowGridLine = s.ShowGridLine;
            g.TemplatePath = s.TemplatePath;
            g.HideOnMinimize = s.TrayOnMinimize;
            g.UseBrowser2ch = s.Use2chBrowser;
            g.UseOtherBrowser = s.UseOtherBrowser;
            Save(g, textBox2.Text);
        }

        private void ConvFilterSetting()
        {
            Object obj = LoadSetting(Path.Combine(textBox1.Text, "FilterSetting.xml"), typeof(PeerCastMultiPlayer2.FilterSetting[]));
            if (obj == null) return;
            PeerCastMultiPlayer2.FilterSetting[] fl = (PeerCastMultiPlayer2.FilterSetting[])obj;
            List<pcmp.Setting.TabSetting> tl = new List<pcmp.Setting.TabSetting>();

            foreach (PeerCastMultiPlayer2.FilterSetting s in fl)
            {
                pcmp.Setting.TabSetting t = new pcmp.Setting.TabSetting();
                t.ChannelType = s.ChannelType;
                t.CheckChannel = s.CheckChannel;
                t.CheckComment = s.CheckComment;
                t.CheckContact = s.CheckContact;
                t.CheckGenre = s.CheckGenre;
                t.CheckPlaying = s.CheckPlaying;
                t.CheckType = s.CheckType;
                t.CheckYpName = s.CheckYpName;
                t.CheckYpUrl = s.CheckYpUrl;
                t.ConcatAllStrings = s.ConcatAllStrings;
                t.Condition = s.Condition;
                t.Enable = s.Enable;
                t.IgnoreCase = s.IgnoreCase;
                t.Name = s.Name;
                List<pcmp.Setting.TargetYPSetting> typList = new List<pcmp.Setting.TargetYPSetting>();
                foreach (PeerCastMultiPlayer2.TargetYPSetting typ in s.TargetYPList)
                {
                    pcmp.Setting.TargetYPSetting ty = new pcmp.Setting.TargetYPSetting();
                    ty.IsTargetYP = typ.IsTargetYP;
                    ty.YPName = typ.YPName;
                    typList.Add(ty);
                }
                t.TargetYpList = typList.ToArray();
                t.UseRegex = s.UseRegEx;
                tl.Add(t);
            }
            Save(tl.ToArray(),textBox2.Text);
        }

        private object LoadSetting(string file, Type t)
        {
            XmlSerializer xs = null;
            StreamReader sr = null;
            Object obj = null;
            try
            {
                xs = new XmlSerializer(t);
                sr = new StreamReader(file);
                obj = xs.Deserialize(sr);
            }
            catch
            {
                return null;
            }
            finally
            {
                if (sr != null)
                    sr.Close();
            }
            return obj;

        }

        public void Save(pcmp.Setting.FavSetting[] target, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "Favorites.xml"), target, false);
        }

        public void Save(pcmp.Setting.NGSetting[] target, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "NG.xml"), target, false);
        }

        public void Save(pcmp.Setting.GeneralSetting target, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "GeneralSetting.xml"), target, false);
        }

        public void Save(pcmp.Setting.ApplicationSetting target, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "Application.xml"), target, false);
        }

        public void Save(pcmp.Setting.PlayerSetting[] favSettingList, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "PlayerSetting.xml"), favSettingList, false);
        }

        public void Save(pcmp.Setting.TabSetting[] target, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "TabSetting.xml"), target, false);
        }

        public void Save(pcmp.Setting.ToolSetting[] target, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "Tools.xml"), target, false);
        }

        public static void Save(pcmp.Setting.YpSetting[] yps, string dir)
        {
            pcmp.Setting.Serializer.Serialize(Path.Combine(dir, "YelloPages.xml"), yps, false);
        }
    }
}