#ifndef _COMMON_H_
#define _COMMON_H_

typedef UCHAR               BYTE,  *PBYTE,  **PPBYTE;
typedef USHORT              WORD,  *PWORD,  **PPWORD;
typedef ULONG               DWORD, *PDWORD, **PPDWORD;
typedef unsigned __int64    QWORD, *PQWORD, **PPQWORD;
typedef int                 BOOL,  *PBOOL,  **PPBOOL;
typedef void                                **PPVOID;
typedef unsigned int		UINT;

typedef PVOID           POBJECT;
typedef char            CHAR;
typedef char *          PCHAR;

typedef ULONG 		WLEN;

typedef NTSTATUS (NTAPI *NTPROC) ();
typedef NTPROC *PNTPROC;

typedef ULONG POINTER;

typedef struct _SYSTEM_SERVICE_TABLE
{
	PNTPROC ServiceTable;           // array of entry points
	PDWORD  CounterTable;           // array of usage counters
	DWORD   ServiceLimit;           // number of table entries
	PBYTE   ArgumentTable;          // array of byte counts
	
} SYSTEM_SERVICE_TABLE,   *PSYSTEM_SERVICE_TABLE,
	**PPSYSTEM_SERVICE_TABLE;

typedef struct _SERVICE_DESCRIPTOR_TABLE
{
	SYSTEM_SERVICE_TABLE ntoskrnl;  // ntoskrnl.exe (native api)
	SYSTEM_SERVICE_TABLE win32k;    // win32k.sys   (gdi/user)
	SYSTEM_SERVICE_TABLE Table3;    // not used
	SYSTEM_SERVICE_TABLE Table4;    // not used

} SERVICE_DESCRIPTOR_TABLE, *PSERVICE_DESCRIPTOR_TABLE,
	**PPSERVICE_DESCRIPTOR_TABLE;

#define INVALID_HANDLE_VALUE  ((HANDLE) -1)

#ifndef IRP_MJ_QUERY_POWER
#define IRP_MJ_QUERY_POWER      0x16
#endif

#ifndef IRP_MJ_SET_POWER
#define IRP_MJ_SET_POWER        0x17
#endif

#ifndef IRP_MJ_PNP_POWER
#define IRP_MJ_PNP_POWER        0x1B
#endif

#define MUTEX_INIT(v)      KeInitializeMutex( &v, 0 )
#define MUTEX_ACQUIRE(v)   KeWaitForMutexObject( &v, Executive, KernelMode, FALSE, NULL )
#define MUTEX_RELEASE(v)   KeReleaseMutex( &v, FALSE )



#endif 
