
#include "stdafx.h"
#include <stdio.h>
#include "resource.h"
#include <winsvc.h>
#include <WinIoCtl.h>

#define MY_DEVICE_TYPE 0x0000AA71
#define DRIVER_IO(_code)		CTL_CODE(MY_DEVICE_TYPE, _code, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define APP_MSG_LIVECHECK DRIVER_IO(0x1)	//Show hided enemy process message
#define WS_EX_LAYERED           0x00080000
#define LWA_COLORKEY            0x00000001
#define LWA_ALPHA               0x00000002
#define ULW_COLORKEY            0x00000001
#define ULW_ALPHA               0x00000002
#define ULW_OPAQUE              0x00000004

char DriveName[10] = "GR";	//Driver/Device name
char DeviceName[20];
char Directory[501];

typedef BOOL (_stdcall *API_TYPE)(HWND,COLORREF,BYTE,DWORD); 
API_TYPE mySetLayeredWindowAttributes; 

BOOL CALLBACK MainDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);


int APIENTRY WinMain(HINSTANCE hInstance,
					 HINSTANCE hPrevInstance,
					 LPSTR     lpCmdLine,
					 int       nCmdShow)
{
	__asm nop
		DialogBox(hInstance, MAKEINTRESOURCE(IDD_DLG1), HWND_DESKTOP, MainDlgProc);
	__asm nop
		ExitProcess(0);

	return 0;

}

BOOL MakeDrvIoControl (HANDLE hDevice, DWORD dCode, PVOID  pInput, DWORD  dInput, PVOID  pOutput, DWORD  dOutput)
{
	DWORD dData = 0;
	BOOL bReturn;

	if(hDevice == NULL) return FALSE;
	__asm nop
		if(pInput == NULL || dInput == 0)
		{
			pInput = (PVOID)&dData;
			__asm nop
				bReturn = DeviceIoControl (hDevice, dCode, pInput,  sizeof(DWORD), pOutput, dOutput, &dData,  NULL) 
				&& (dData == dOutput);
		}
		else
		{
			bReturn = DeviceIoControl (hDevice, dCode, pInput,  dInput, pOutput, dOutput, &dData,  NULL) 
				&& (dData == dOutput);
			__asm nop
		}
		return bReturn;
}

DWORD MakeDrvStop(LPSTR lpDriver, HANDLE hHandle)
{
	DWORD dwError = ERROR_SUCCESS;
	SC_HANDLE hSCMan = NULL;
	SC_HANDLE hService = NULL;
	SERVICE_STATUS serviceStatus;
	__asm nop
		if(hHandle)
			CloseHandle(hHandle);
	__asm nop

		// connect to local service control manager
		if ((hSCMan = OpenSCManager(NULL, NULL, SC_MANAGER_CONNECT)) == NULL) 
		{
			__asm nop
				dwError = GetLastError();
			return dwError;
		}

		// get a handle to the service
		if ((hService = OpenService(hSCMan, lpDriver, SERVICE_STOP)) != NULL) 
		{
			// stop the driver
			if (!ControlService(hService, SERVICE_CONTROL_STOP, &serviceStatus))
			{
				__asm nop
					dwError = GetLastError();
			}
			__asm nop
				CloseServiceHandle(hService);
			__asm nop
		} 
		else 
		{
			__asm nop
				dwError = GetLastError();
		}
		__asm nop

			CloseServiceHandle(hSCMan);
		__asm nop
			return dwError;
}

BOOL CALLBACK MainDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam)
{
	SC_HANDLE hSCManger = NULL;
	SC_HANDLE hService = NULL;
	static HANDLE hDevice;
	SERVICE_STATUS servicestatus;
	static BOOL EnableStatus = FALSE;
	static char LiveTest[30];
	static char EnemyName[30];
	static char ProcessName[30];
	HANDLE hLog,hLog2;
	DWORD dt;
	HMODULE hUser32;

	switch(iMessage)
	{

	case WM_INITDIALOG:
		SetWindowLong(hDlg, 
			GWL_EXSTYLE, 
			GetWindowLong(hDlg, GWL_EXSTYLE) | WS_EX_LAYERED);
		hUser32 = GetModuleHandle("user32.dll");
		mySetLayeredWindowAttributes = (API_TYPE)GetProcAddress( hUser32, "SetLayeredWindowAttributes"); 
		mySetLayeredWindowAttributes(hDlg, 0, (255 * 70) / 93, LWA_ALPHA);
		return TRUE;
		__asm nop
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			if(EnableStatus == FALSE)
			{
				__asm nop
					memset(ProcessName,0,30);
				__asm nop
					GetDlgItemText(hDlg,IDC_PROCNAME,ProcessName,30);
				__asm nop
					if(ProcessName[0] == 0)
					{
						__asm nop
							MessageBox(NULL,"Input Process Name !!","ERROR",64);
						__asm nop
							return FALSE;
					}
					hLog2 = CreateFile ("c:\\GR2.ini", 
						GENERIC_READ | GENERIC_WRITE,
						0 , 
						NULL ,
						CREATE_ALWAYS,
						FILE_ATTRIBUTE_NORMAL ,
						NULL );
					__asm nop
						if(hLog2 == INVALID_HANDLE_VALUE)
						{
							//MessageBox(NULL,"ERROR","ERROR",64);
							__asm nop
								return FALSE;
						}
						__asm nop
							WriteFile(hLog2,ProcessName,30,&dt,NULL);
						__asm nop
							CloseHandle(hLog2);
						__asm nop

							__asm nop
							memset(EnemyName,0,30);
						__asm nop
							GetDlgItemText(hDlg,IDC_ENEMY,EnemyName,30);
						__asm nop
							if(EnemyName[0] == 0)
							{
								__asm nop
									MessageBox(NULL,"Input Enemy Name !!","ERROR",64);
								__asm nop
									return FALSE;
								__asm nop
							}
							hLog = CreateFile ("c:\\GR.ini", 
								GENERIC_READ | GENERIC_WRITE,
								0 , 
								NULL ,
								CREATE_ALWAYS,
								FILE_ATTRIBUTE_NORMAL ,
								NULL );
							__asm nop
								if(hLog == INVALID_HANDLE_VALUE)
								{
									//MessageBox(NULL,"ERROR","ERROR",64);
									__asm nop
										return FALSE;
								}
								WriteFile(hLog,EnemyName,30,&dt,NULL);
								__asm nop
									CloseHandle(hLog);
								__asm nop



									GetCurrentDirectory(500,Directory);
								__asm nop
									lstrcat(Directory,"\\");
								__asm nop
									lstrcat(Directory,DriveName);
								__asm nop
									lstrcat(Directory,".sys");
								__asm nop

									hSCManger = OpenSCManager(NULL,
									NULL,
									SC_MANAGER_CREATE_SERVICE);
								__asm nop
									if(!hSCManger)
									{
										//MessageBox(hDlg,"Driver Load Faild[SCMANGER]","Msg",64);
										CloseHandle(hLog);
										__asm nop
											return FALSE;
									}
									hService = CreateService(
										hSCManger,
										DriveName,
										DriveName,
										GENERIC_READ,
										SERVICE_KERNEL_DRIVER,
										SERVICE_DEMAND_START,
										SERVICE_ERROR_NORMAL,
										Directory,
										NULL,
										NULL,
										NULL,
										NULL,
										NULL
										);
									__asm nop
										if(!hService)
										{
											if(GetLastError() == ERROR_SERVICE_EXISTS)
											{
												__asm nop
													hService = OpenService(hSCManger,DriveName,DELETE);
												if(hService)
												{
													__asm nop
														if(!DeleteService(hService))
														{
															__asm nop
																//MessageBox(NULL,"Service Delete Error","Msg",64);
																__asm nop
																CloseHandle(hLog);
														}
														__asm nop
															CloseServiceHandle(hService);
												}
											}
										}
										CloseServiceHandle(hService);
										__asm nop

											CloseServiceHandle(hSCManger);

										hSCManger = OpenSCManager(NULL,
											NULL,
											SC_MANAGER_CONNECT);
										__asm nop
											if(!hSCManger)
											{
												//MessageBox(NULL,"MangerError","Error",64);
												__asm nop
													CloseHandle(hLog);
												return FALSE;
											}

											hService = OpenService(hSCManger,DriveName,SERVICE_START);
											__asm nop
												if(hService)
												{
													if (!StartService(hService, 0, NULL))
													{
														//MessageBox(NULL,"Service Error","Msg",64);
														__asm nop
															CloseHandle(hLog);
														__asm nop
															return FALSE;
													}
													__asm nop
														CloseServiceHandle(hService);
													__asm nop
												}
												else
												{
													__asm nop
														//MessageBox(NULL,"Service Open Faild","Msg",64);
														__asm nop
														CloseHandle(hLog);
												}
												CloseServiceHandle(hSCManger);
												__asm nop
													sprintf(DeviceName,"\\\\.\\%s",DriveName);
												__asm nop
													hDevice = CreateFile (DeviceName, 
													GENERIC_READ | GENERIC_WRITE,
													0 , 
													NULL ,
													OPEN_EXISTING,
													FILE_ATTRIBUTE_NORMAL ,
													NULL );
												__asm nop

													if(hDevice == INVALID_HANDLE_VALUE)
													{
														__asm nop
															//MessageBox(hDlg,"Driver Load Faild[hDevice]","Msg",64);
															__asm nop
															CloseHandle(hLog);
														__asm nop
															return FALSE;
													}

													//	EnableWindow(GetDlgItem(hDlg,IDSHOW),TRUE);
													__asm nop
														EnableWindow(GetDlgItem(hDlg,IDSTOP),TRUE);
													__asm nop
														EnableWindow(GetDlgItem(hDlg,IDOK),FALSE);
													__asm nop
														EnableWindow(GetDlgItem(hDlg,IDC_PROCNAME),FALSE);
													__asm nop
														EnableWindow(GetDlgItem(hDlg,IDC_ENEMY),FALSE);
													__asm nop
														EnableStatus = TRUE;
			}
			return TRUE;
		case IDSTOP:
			if(EnableStatus == TRUE)
			{
				CloseHandle(hDevice);
				__asm nop
					hSCManger = OpenSCManager(NULL,NULL,SC_MANAGER_CONNECT);
				__asm nop
					if(!hSCManger)
					{
						__asm nop
							//MessageBox(hDlg,"Driver Unload Faild[SCMANGER]","Msg",64);
							__asm nop
							return FALSE;
						__asm nop
					}
					__asm nop
						hService = OpenService(hSCManger,DriveName,SERVICE_STOP);
					if(hService)
					{
						__asm nop
							if(!ControlService(hService,SERVICE_CONTROL_STOP,&servicestatus))
							{
								__asm nop

							}
							__asm nop
								CloseServiceHandle(hService);
							__asm nop
								hService = OpenService(hSCManger,DriveName,DELETE);
							__asm nop
								DeleteService(hService);
							__asm nop
								CloseServiceHandle(hService);
					}
					else
					{
						__asm nop

							__asm nop
					}
					__asm nop
						CloseServiceHandle(hSCManger);
					__asm nop
						//MessageBox(hDlg,"Protect Stop","Alert",64);
						__asm nop
						DeleteFile("c:\\GR.ini");
					__asm nop
						EnableWindow(GetDlgItem(hDlg,IDSTOP),FALSE);
					__asm nop
						EnableWindow(GetDlgItem(hDlg,IDC_PROCNAME),TRUE);
					__asm nop
						EnableWindow(GetDlgItem(hDlg,IDC_ENEMY),TRUE);
					__asm nop
						EnableWindow(GetDlgItem(hDlg,IDSHOW),FALSE);
					__asm nop
						EnableWindow(GetDlgItem(hDlg,IDOK),TRUE);
					__asm nop

						EnableStatus = FALSE;	
					__asm nop
			}
			return TRUE;

		case IDSHOW:
			//MessageBoxA(NULL,"C ً^bO؏_͉?","O",64);
			MakeDrvIoControl (hDevice, 
				APP_MSG_LIVECHECK,
				LiveTest, 
				strlen(LiveTest),
				LiveTest, 
				10);
			return TRUE;

		case IDABB:
			__asm nop
				MessageBox(NULL,"Coded by Dual~","About GR...",64);
			__asm nop
				return TRUE;
		case IDEXI:
			PostQuitMessage(0);
			break;

		default:
			return FALSE;
		}
	case WM_CLOSE:
		if(EnableStatus == TRUE)
		{
			__asm nop
				CloseHandle(hDevice);
			__asm nop
				hSCManger = OpenSCManager(NULL,NULL,SC_MANAGER_CONNECT);
			__asm nop
				if(!hSCManger)
				{
					__asm nop
						//MessageBox(hDlg,"Driver Unload Faild[SCMANGER]","Msg",64);
						__asm nop
						return FALSE;
				}
				__asm nop
					hService = OpenService(hSCManger,DriveName,SERVICE_STOP);
				__asm nop
					if(hService)
					{
						if(!ControlService(hService,SERVICE_CONTROL_STOP,&servicestatus))
						{
							__asm nop
						}
						__asm nop
							CloseServiceHandle(hService);
						__asm nop
							hService = OpenService(hSCManger,DriveName,DELETE);
						__asm nop
							DeleteService(hService);
						__asm nop
							CloseServiceHandle(hService);
					}
					else
					{
						__asm nop
					}
					CloseServiceHandle(hSCManger);
					__asm nop
						//MessageBox(hDlg,"Protect Stop","Alert",64);
						__asm nop
						DeleteFile("c:\\antiprevet.ini");
					DeleteFile("c:\\antiprevent2.ini");
					__asm nop

						EnableWindow(GetDlgItem(hDlg,IDSTOP),FALSE);
					__asm nop
						EnableWindow(GetDlgItem(hDlg,IDC_PROCNAME),TRUE);
					__asm nop
						EnableWindow(GetDlgItem(hDlg,IDOK),TRUE);
					__asm nop
						EnableStatus = FALSE;
		}
		__asm nop
			EndDialog(hDlg,0);
		__asm nop
			return TRUE;

	default:
		return FALSE;
	}

	return FALSE;
}
