/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package peercast4j.core;

import java.util.HashMap;
import java.util.Iterator;

/**
 * index.txt struct
 * @author nori090
 */
public class ChannelData {

    public static final String[] COLUMN_NAMES = {
        "channelName",
        "id",
        "tip",
        "contactUrl",
        "description1",
        "description2",
        "listenerCount",
        "relayCount",
        "bitrate",
        "type",
        "playing1",
        "playing2",
        "playing3",
        "playing4",
        "ypId",
        "time",
        "alt",
        "comment"
    };
    // raw data
    private String raw;
    private HashMap<String, String> m = new HashMap<String, String>();

    public ChannelData(String raw) {
        this.raw = raw;
        parse(raw);
    }

    private void parse(String raw) {
        String[] s = raw.split("<>");
        for (int i = 0; i < COLUMN_NAMES.length; i++) {
            m.put(COLUMN_NAMES[i], s[i]);
        }
    }

    public String get(int i) {
        return m.get(COLUMN_NAMES[i]);
    }

    public String get(String s) {
        return m.get(s);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Iterator ite = m.keySet().iterator(); ite.hasNext();) {
            String k = (String) ite.next();
            sb.append("[").append(k).append("=").append(m.get(k)).append("] ");
        }
        return sb.toString();
    }
}
