/*************************************************************************
 * PCRaw
 * Author: nori090
 * Original author: ◆e5bW6vDOJ.
 * Copyright: Copyright (C) 2008 nori090
 * Copyright: Copyright (C) 2007 ◆e5bW6vDOJ.
 * Date: February 11, 2007
 * License: 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * http://mosax.sakura.ne.jp/fswiki.cgi?page=PCRaw
 */
package org.coderepos.nori090.pcraw;

import java.util.Date;

/**
 * @author nori090
 * @version $Rev$ $Date$
 */
public final class PCRawTools {

    private PCRawTools() {
        super();
    }

    static long time() {
        return System.currentTimeMillis() / 1000;
    }

    private static final char[] DIGITS =
        { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

    static String encodeHex( byte[] data ) {

        int l = data.length;

        char[] out = new char[l << 1];

        // two characters form the hex value.
        for ( int i = 0, j = 0; i < l; i++ ) {
            out[j++] = DIGITS[( 0xF0 & data[i] ) >>> 4];
            out[j++] = DIGITS[0x0F & data[i]];
        }

        return format( out );
    }

    static String format( char[] cs ) {
        StringBuilder sb = new StringBuilder();
        for ( int i = 0; i < cs.length; i++ ) {
            sb.append( cs[i] );
            sb.append( cs[++i] );
            sb.append( " " );
        }
        sb.deleteCharAt( sb.length() - 1 );
        return sb.toString().trim();
    }

    public static void main( String[] args ) {
        byte[] b = new byte[] { 0x01, (byte) 0xff, (byte) 0xfe };
        System.out.println( encodeHex( b ) );
        System.out.println( time() );
        System.out.println( new Date( ( time() * 1000L ) ) );
        System.out.println( new Date( 1215375344000L ) );
    }
}
