/*
 * Main.fx
 *
 * Created on 2009/05/19, 0:49:16
 */

package myclock;

import java.util.Calendar;
import java.util.TimeZone;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.scene.CustomNode;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.Scene;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import myclock.Main.ClockWork;

/**
 * @author nori090
 */

var stagePosX : Number = 0;
var stagePosY : Number = 0;
var deltaX : Number;
var deltaY: Number;
var clock_base_image:Image = Image {
    url: "{__DIR__}domo_base.png"
    width: 136
    height: 136
}
var clock_long_image: Image = Image {
    url: "{__DIR__}domo_long.png"
    width: 8
    height: 43
}
var clock_short_image: Image = Image {
    url: "{__DIR__}domo_short.png"
    width: 6
    height: 28
}
var clock_center_image: Image = Image {
    url: "{__DIR__}domo_center.png"
    width: 2
    height: 2
}

function mousePressed(e:MouseEvent):Void {
    deltaX = stagePosX - e.screenX;
    deltaY= stagePosY - e.screenY;
}
function mouseDragged(e:MouseEvent):Void {
    if (e.primaryButtonDown) {
        stagePosX = e.screenX + deltaX;
        stagePosY = e.screenY + deltaY;
    }
}

var clockWork : ClockWork = ClockWork {
    onMousePressed: mousePressed
    onMouseDragged: mouseDragged
    timezone: TimeZone.getTimeZone("GMT+9:00")
    };

Stage {
    scene : Scene {
        fill: null
        content : clockWork
        }
    width : 200
    height : 232
    x: bind stagePosX with inverse;
    y: bind stagePosY with inverse;
    title: "Clock"
    style: StageStyle.TRANSPARENT
}

clockWork.timer.play();

// Clas representing clock work
class ClockWork extends CustomNode {

    var seconds : Number;
    var minutes : Number;
    var hours : Number;
    var hours2 : Number;
    var y : Number;
    var m : Number;
    var d : Number;
    public var timezone : TimeZone;

    init {
        var calendar : Calendar = Calendar.getInstance(timezone);
        seconds = calendar.get( Calendar.SECOND );
        minutes = calendar.get( Calendar.MINUTE );
        hours = calendar.get( Calendar.HOUR_OF_DAY );
        hours2 = calendar.get( Calendar.HOUR );
        y = calendar.get(Calendar.YEAR);
        m = calendar.get(Calendar.MONTH)+1;
        d = calendar.get(Calendar.DATE);
    }

    // Timeline responsible for automatic one second updates of clock hands
    public var timer : Timeline = Timeline {
        repeatCount : Timeline.INDEFINITE
        keyFrames :[
            KeyFrame {
                time : 60s
                action : function() {
                    var calendar : Calendar = Calendar.getInstance(timezone);
                    seconds = calendar.get( Calendar.SECOND );
                    minutes = calendar.get( Calendar.MINUTE );
                    hours = calendar.get( Calendar.HOUR_OF_DAY );
                    hours2 = calendar.get( Calendar.HOUR );
                    y = calendar.get(Calendar.YEAR);
                    m = calendar.get(Calendar.MONTH)+1;
                    d = calendar.get(Calendar.DATE);
                }
            },]
    };

    // Visual representation of clocks
    public override function create(): Node {
        return Group {
            content : [
                ImageView {
                    image: clock_base_image
                    x: 0
                    y: 0
                    },
                ImageView {
                    transforms: [ Rotate { angle : bind (minutes-30) * 6, pivotX : 68, pivotY : 68 }]
                    image: clock_long_image
                    x:67
                    y:64
                },
                ImageView {
                    transforms: [ Rotate { angle : bind (hours2-6) * 30, pivotX : 68, pivotY : 68 }]
                    image: clock_short_image
                    x:67
                    y:64
                },
                ImageView {
                    image: clock_center_image
                    x:67
                    y:64
                },
                Text {
                    font : Font {
                        size : 20
                    }
                    stroke: Color.GREENYELLOW
                    fill: Color.GREENYELLOW
                    x: 5, y: 16*10
                    content: "japan"
                },
                Text {
                    font : Font {
                        size : 20
                    }
                    stroke: Color.GREENYELLOW
                    fill: Color.GREENYELLOW

                    x: 5, y: 16*11
                    content: bind hours.intValue().toString().concat(":".concat(minutes.intValue().toString()))
                },
                Text {
                    font : Font {
                        size : 20
                    }
                    stroke: Color.GREENYELLOW
                    fill: Color.GREENYELLOW
                    x: 5, y: 16*12
                    content: bind y.intValue().toString().concat(
                    "/".concat(
                        m.intValue().toString().concat(
                        "/".concat(
                            d.intValue().toString()
                        ))
                    ))
                },
                ]
        };
    }
}
