const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;
const Ce = Components.Exception;
const CLASS_ID = Components.ID("{435ee6c3-809c-11de-8a39-0800200c9a66}");
const CLASS_NAME = "modic English DB";
const CONTRACT_ID = "@nori090.org/english/sqlite-service;1";

const SQLITE_FILENAME = "modicEnglish.sqlite";

var modicEnglishDB = {

  _dbService : null,

  _directoryService : null,

  _databaseFilePath : null,

  get databaseFilePath() {
    return this._databaseFilePath;
  },

  init : function() {
    this._dbService =
      Cc["@nori090.org/sqlite-service;2"].
        createInstance(Ci.modicISQLiteService);

    this._directoryService =
      Cc["@mozilla.org/file/directory_service;1"].
        getService(Ci.nsIProperties);

    this._initializeDatabase();
  },

  uninit : function() {
  },

  _initializeDatabase : function() {
    var dbFile =
      this._directoryService.get("ProfD", Ci.nsIFile);

    dbFile.append(SQLITE_FILENAME);

    this._databaseFilePath = dbFile.target;

    this._dbService.initialize(SQLITE_FILENAME);

    if (!dbFile.exists()) {
      this._dbService.executeSimpleSQL("CREATE TABLE IF NOT EXISTS dict (key TEXT PRIMARY KEY,desc TEXT)");
    }
  },

  closeConnection : function() {
    this._dbService.closeConnection();
  },

  truncateTable : function() {
    this._dbService.executeSimpleSQL("DELETE FROM dict");
  },

  createStatement : function(aQueryString) {
    return this._dbService.createStatement(aQueryString);
  },

  executeSimpleSQL : function(aQueryString) {
    this._dbService.executeSimpleSQL(aQueryString);
  },

  executeNonQuery : function(aQueryStatement) {
    return this._dbService.executeNonQuery(aQueryStatement);
  },

  executeQuery : function(aQueryStatement) {
    return this._dbService.executeQuery(aQueryStatement);
  },

  existsColumnInTable : function(aTable, aColumn) {
    return this._dbService.existsColumnInTable(aTable, aColumn);
  },

  QueryInterface : function(aIID) {
    if (!aIID.equals(Ci.modicIEnglishDB) && !aIID.equals(Ci.nsISupports)) {
      throw Cr.NS_ERROR_NO_INTERFACE;
    }
    return this;
  }
};

var modicEnglishDBFactory = {
  _singletonObj: null,

  createInstance: function(aOuter, aIID) {
    if (aOuter != null) {
      throw Cr.NS_ERROR_NO_AGGREGATION;
    }
    if (!this._singletonObj) {
      this._singletonObj = modicEnglishDB;
      modicEnglishDB.init();
    }

    return this._singletonObj.QueryInterface(aIID);
  }
};

var modicEnglishDBModule = {
  registerSelf : function(aCompMgr, aLocation, aLoaderStr, aType) {
    aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
    aCompMgr.registerFactoryLocation(
      CLASS_ID, CLASS_NAME, CONTRACT_ID, aLocation, aLoaderStr, aType);
  },

  unregisterSelf : function (aCompMgr, aLocation, aLoaderStr) {
    modicEnglishDB.uninit();

    aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
    aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);
  },

  getClassObject : function(aCompMgr, aClass, aIID) {
    if (!aIID.equals(Ci.nsIFactory)) {
      throw Cr.NS_ERROR_NOT_IMPLEMENTED;
    }

    if (aClass.equals(CLASS_ID)) {
      return modicEnglishDBFactory;
    }

    throw Cr.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function(aCompMgr) {
    return true;
  }
};

function NSGetModule(aCompMgr, aFileSpec) {
  return modicEnglishDBModule;
}
