/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.io.IOUtils;

/**
 * @author nori090
 * @version $Rev: 86 $ $Date: 2008-06-03 21:53:24 +0900 (Tue, 03 Jun 2008) $
 */
public class ThreadImpl
    implements Thread {

    private HashMap<String, Object> self = new HashMap<String, Object>();

    private HashMap<String, Comment> v1 = new HashMap<String, Comment>();

    @Override
    public Thread addComment( Comment comment ) {
        Comment old = v1.get( String.valueOf( comment.getNumberOfCount() ) );
        if ( old == null ) {
            v1.put( String.valueOf( comment.getNumberOfCount() ), comment );
        }
        else {
            old.setBody( comment.getBody() );
            old.setDate( comment.getDate() );
            old.setId( comment.getId() );
            old.setMailto( comment.getMailto() );
            old.setName( comment.getName() );
            old.setNumberOfCount( comment.getNumberOfCount() );
            old.setThread( this );
        }
        return this;
    }

    @Override
    public List<Comment> getComments() {
        ArrayList<Comment> list = new ArrayList<Comment>();
        for ( int i = 1; i <= 1000; i++ ) {
            Comment c = v1.get( String.valueOf( i ) );
            if ( c != null ) {
                list.add( c );
            }
        }
        return list;
    }

    @Override
    public Thread getThreadFromWeb() {
        String url = getUrl();
        if ( url == null ) {
            throw new NullPointerException( "url not found" );
        }
        HTTP_DATA data = getHttpData();
        if ( data == null ) {
            data = new HTTP_DATA().setUrl( url );
            setHttpData( data );
        }
        BufferedReader br = null;
        try {
            br = HttpHelper.http_get( data );
            if ( br != null ) {
                String line = null;
                int count = 0;
                while ( ( line = br.readLine() ) != null ) {
                    count++;
                    String[] comment = ParseUtil.split_comment( line );
                    Comment c = new CommentImpl();
                    c.setName( comment[0] );
                    c.setMailto( comment[1] );
                    String[] date_id = ParseUtil.split_date_id( comment[2] );
                    if ( date_id.length == 2 ) {
                        c.setId( date_id[1] );
                    }
                    c.setDate( date_id[0] );
                    c.setBody( comment[3] );
                    c.setNumberOfCount( count );
                    c.setThread( this );
                    addComment( c );
                }
            }
        }
        catch ( IOException e ) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly( br );
        }
        return this;
    }

    @Override
    public Thread update() {
        return getThreadFromWeb();
    }

    @Override
    public HTTP_DATA getHttpData() {
        return (HTTP_DATA) self.get( "http" );
    }

    @Override
    public String getId() {
        return (String) self.get( "id" );
    }

    @Override
    public Ita getIta() {
        return (Ita) self.get( "ita" );
    }

    @Override
    public Subject getSubject() {
        return (Subject) self.get( "subject" );
    }

    @Override
    public String getTitle() {
        return (String) self.get( "title" );
    }

    @Override
    public String getUrl() {
        return (String) self.get( "url" );
    }

    @Override
    public Thread setComments( List<Comment> list ) {
        for ( Comment c : list ) {
            addComment( c );
        }
        return this;
    }

    @Override
    public Thread setHttpData( HTTP_DATA data ) {
        self.put( "http", data );
        return this;
    }

    @Override
    public Thread setId( String id ) {
        self.put( "id", id );
        return this;
    }

    @Override
    public Thread setSubject( Subject subject ) {
        self.put( "subject", subject );
        return this;
    }

    @Override
    public Thread setTitle( String title ) {
        self.put( "title", title );
        return this;
    }

    @Override
    public Thread setUrl( String url ) {
        self.put( "url", url );
        return this;
    }

    @Override
    public Thread setIta( Ita ita ) {
        self.put( "ita", ita );
        return this;
    }

}
