/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

import java.util.Date;
import java.util.HashMap;

/**
 * @author nori090
 * @version $Rev: 85 $ $Date: 2008-06-02 22:18:54 +0900 (Mon, 02 Jun 2008) $
 */
public class SubjectImpl
    implements Subject {

    private HashMap<String, Object> self = new HashMap<String, Object>();

    @Override
    public int getCommentCount() {
        String s = (String) self.get( "count" );
        if ( s == null ) {
            setCommentCount( -1 );
            return -1;
        }
        return Integer.parseInt( s );
    }

    @Override
    public String getId() {
        return (String) self.get( "id" );
    }

    @Override
    public Ita getIta() {
        return (Ita) self.get( "ita" );
    }

    @Override
    public Thread getThread() {
        return (Thread) self.get( "thread" );
    }

    @Override
    public String getTitle() {
        return (String) self.get( "title" );
    }

    @Override
    public String getUrl() {
        return (String) self.get( "url" );
    }

    @Override
    public Subject setCommentCount( int count ) {
        self.put( "count", String.valueOf( count ) );
        return this;
    }

    @Override
    public Subject setId( String id ) {
        self.put( "id", id );
        return this;
    }

    @Override
    public Subject setThread( Thread thread ) {
        self.put( "thread", thread );
        return this;
    }

    @Override
    public Subject setTitle( String title ) {
        self.put( "title", title );
        return this;
    }

    @Override
    public Subject setUrl( String url ) {
        self.put( "url", url );
        return this;
    }

    @Override
    public Subject setIta( Ita ita ) {
        self.put( "ita", ita );
        return this;
    }

    @Override
    public Date getLastUpdate() {
        return (Date) self.get( "last_update" );
    }

    @Override
    public Subject setLastUpdate( Date date ) {
        self.put( "last_update", date );
        return this;
    }

    @Override
    public Date getThreadBuildDate() {
        if ( getId() != null ) {
            return new Date( Long.parseLong( getId() ) * 1000 );
        }
        return new Date(0L);
    }
}
