/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

import java.util.List;

/**
 * @author nori090
 * @version $Rev: 85 $ $Date: 2008-06-02 22:18:54 +0900 (Mon, 02 Jun 2008) $
 */
public interface Ita {

    Server getServer();

    List<Thread> getThreads();

    /** thread の key は thread id もしくはタイトルです。 */
    Thread getThread( String thread_key );

    Ita setThreads( List<Thread> threads );

    Ita addThread( Thread thread );

    List<Subject> getSubjects();

    List<Subject> getSubjectsFromWeb();

    /** subject の key は thread id もしくはタイトルです。 */
    Subject getSubject( String thread_key );

    Ita setSubjects( List<Subject> subjects );

    Ita addSubject( Subject subject );

    String getUrl();

    Ita setUrl( String url );

    String getItaName();

    Ita setItaName( String itaName );

    String getItaName_ja();

    Ita setItaName_ja( String itaName_ja );
}
