/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

import java.util.HashMap;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author nori090
 * @version $Rev: 85 $ $Date: 2008-06-02 22:18:54 +0900 (Mon, 02 Jun 2008) $
 */
public class HTTP_DATA {
    // cookie
    HashMap<String, String> cookie = new HashMap<String, String>();

    // url
    String url;

    // ETag
    String etag;

    // 受信数
    long content_length = 0;

    // user agent
    String user_Agent;

    // connect timeout
    int connectTimeout = -1;

    // read timeout
    int readTimeout = -1;

    public HashMap<String, String> getCookie() {
        return cookie;
    }

    public HTTP_DATA setCookie( HashMap<String, String> cookie ) {
        this.cookie = cookie;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public HTTP_DATA setUrl( String url ) {
        this.url = url;
        return this;
    }

    public String getEtag() {
        return etag;
    }

    public HTTP_DATA setEtag( String etag ) {
        this.etag = etag;
        return this;
    }

    public long getContent_length() {
        return content_length;
    }

    public HTTP_DATA setContent_length( long content_length ) {
        this.content_length = content_length;
        return this;
    }

    public String getUser_Agent() {
        return user_Agent;
    }

    public HTTP_DATA setUser_Agent( String user_Agent ) {
        this.user_Agent = user_Agent;
        return this;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public HTTP_DATA setConnectTimeout( int connectTimeout ) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public HTTP_DATA setReadTimeout( int readTimeout ) {
        this.readTimeout = readTimeout;
        return this;
    }

    public String toString_d() {
        return new ToStringBuilder( this ).append( "cookie", cookie ).append( "url", url ).append( "etag", etag ).append(
                                                                                                                          "content_length",
                                                                                                                          content_length ).append(
                                                                                                                                                   "user_Agent",
                                                                                                                                                   user_Agent ).append(
                                                                                                                                                                        "connectTimeout",
                                                                                                                                                                        connectTimeout ).append(
                                                                                                                                                                                                 "readTimeout",
                                                                                                                                                                                                 readTimeout ).toString();
    }
}
