/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj.util;

import junit.framework.TestCase;

/**
 * @author nori090
 * @version $Rev: 19 $ $Date: 2008-03-25 22:46:11 +0900 (Tue, 25 Mar 2008) $
 */
public class ParseUtilTest
    extends TestCase {

    public void test_reverseBoldTag1() {
        String ret = ParseUtil.reverseBoldTag( "ウンコ </b>◆PNECKYQmKE<b>" );
        assertEquals( "ウンコ <b>◆PNECKYQmKE</b>", ret );
    }

    public void test_reverseBoldTag2() {
        String ret = ParseUtil.reverseBoldTag( "ウンコ ◆PNECKYQmKE" );
        assertEquals( "ウンコ ◆PNECKYQmKE", ret );
    }
    
}
