/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj.struct;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author nori090
 * @version $Rev: 19 $ $Date: 2008-03-25 22:46:11 +0900 (Tue, 25 Mar 2008) $
 */
public class Thread {
    // 所属板
    Ita ita;

    // スレッド概略
    Subject subject;

    // http data
    HTTP_DATA data;

    // レスリスト
    List<Comment> list;

    // スレッドタイトル
    String title;

    // スレッドurl
    String url;

    // １スレッドID
    String id;

    // constructor
    public Thread( Ita ita ) {
        super();
        this.ita = ita;
    }

    // getter and setter
    public Subject getSubject() {
        return subject;
    }

    public Ita getIta() {
        return ita;
    }

    public Thread setSubject( Subject subject ) {
        this.subject = subject;
        return this;
    }

    public HTTP_DATA getHttpData() {
        return data;
    }

    public Thread setHttpData( HTTP_DATA data ) {
        this.data = data;
        return this;
    }

    public List<Comment> getComments() {
        return list;
    }

    public Thread setComments( List<Comment> list ) {
        this.list = list;
        return this;
    }

    public Thread addComment( Comment comment ) {
        this.list.add( comment );
        return this;
    }

    public String getTitle() {
        return title;
    }

    public Thread setTitle( String title ) {
        this.title = title;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public Thread setUrl( String url ) {
        this.url = url;
        return this;
    }

    public String getId() {
        return id;
    }

    public Thread setId( String id ) {
        this.id = id;
        return this;
    }

    public String toString_d() {
        return new ToStringBuilder( this ).append( "ita", ita ).append( "id", id ).append( "subject", subject ).append(
                                                                                                                        "httpdata",
                                                                                                                        data ).append(
                                                                                                                                       "comments",
                                                                                                                                       list ).append(
                                                                                                                                                      "title",
                                                                                                                                                      title ).append(
                                                                                                                                                                      "url",
                                                                                                                                                                      url ).toString();
    }
}
