/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import java.net.InetAddress;

import jimmy.ConvertUtil;
import junit.framework.TestCase;

import org.apache.commons.codec.binary.Hex;

/**
 * command03 test
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command03Test
    extends TestCase {
    public void test_unpack() {
        try {
            Command c =
                Command.getCommandInstance( Hex.decodeHex( "1d00000003c0a87402162100000006060444564449534f8389835783492e617669".toCharArray() ) );
            if ( c instanceof Command03 ) {
                Command03 c03 = (Command03) c;
                assertEquals( InetAddress.getByAddress( Hex.decodeHex( "c0a87402".toCharArray() ) ), c03.address );
                assertEquals( ConvertUtil.littleEndianBytes2int( Hex.decodeHex( "16210000".toCharArray() ) ),
                              c03.listen_port );
                assertEquals( "", c03.ddns_name );
                String[] keys = c03.clustering_key;
                assertEquals( "DVDISO", keys[0] );
                assertEquals( "ラジオ", keys[1] );
                assertEquals( ".avi", keys[2] );
            }
            else {
                fail();
            }
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }

    public void test_pack() {
        try {
            Command03 cmd = new Command03();
            cmd.address = InetAddress.getByName( "192.168.116.2" );
            cmd.listen_port = 8470;
            String[] keys = new String[] { "DVDISO", "ラジオ", ".avi" };
            cmd.clustering_key = keys;
            String packed = String.valueOf( Hex.encodeHex( cmd.pack() ) );
            assertEquals( "1d00000003c0a87402162100000006060444564449534f8389835783492e617669", packed );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }
}
