/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import jimmy.command.Command02.LinkType;

import org.apache.commons.codec.binary.Hex;

import junit.framework.TestCase;

/**
 * command02 test
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command02Test
    extends TestCase {

    public void test_unpack() {
        try {
            Command c = Command.getCommandInstance( Hex.decodeHex( "050000000200000000".toCharArray() ) );
            if ( c instanceof Command02 ) {
                Command02 c02 = (Command02) c;
                assertEquals( LinkType.SEARCH, c02.type );
                assertEquals( false, c02.isPort0 );
                assertEquals( false, c02.isBadPort0 );
                assertEquals( false, c02.isBbsLink );
            }
            else {
                fail();
            }
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }

    public void test_pack() {
        try {
            Command02 c02 = new Command02();
            c02.setType( LinkType.SEARCH );
            c02.setPort0( false );
            c02.setBadPort0( false );
            c02.setBbsLink( false );
            byte[] packed = c02.pack();
            String packstring = String.valueOf( Hex.encodeHex( packed ) );
            assertEquals( "050000000200000000", packstring );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }
}
