/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import org.apache.commons.codec.binary.Hex;

import jimmy.command.Command;
import jimmy.command.Command00;
import junit.framework.TestCase;

/**
 * command00 test
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command00Test
    extends TestCase {

    public void test_unpack() {
        try {
            Command c =
                Command.getCommandInstance( Hex.decodeHex( "15000000005f9c51446217f43658711c5eb7332084e7bb9b5d".toCharArray() ) );
            if ( c instanceof Command00 ) {
                Command00 new_name = (Command00) c;
                assertEquals( Command00.MINOR, new_name.minor );
                assertEquals( Command00.MAJOR, new_name.major );
                assertEquals( 21, new_name.block_length );
            }
            else {
                fail();
            }
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail( e.getMessage() );
        }
    }

    public void test_pack() {
        try {
            Command00 cmd = new Command00();
            byte[] packed = cmd.pack();
            String packstring = String.valueOf( Hex.encodeHex( packed ) );
            assertEquals( "15000000005f9c51446217f43658711c5eb7332084e7bb9b5d", packstring );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail( e.getMessage() );
        }

    }
}
