/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import jimmy.ConvertUtil;
import jimmy.WinnyProtocolException;
import jimmy.util._ByteArrayInputStream;

/**
 * winny FILE RESPONSE command
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command21
    extends Command {
    public static final byte[] HEADER_KEY = new byte[] { 0x68, 0x65, 0x61, 0x64, 0x65, 0x72 };

    int task_id;

    int response_block;

    byte[] hash;

    byte[] cache_data;

    @Override
    void rawDataPack()
        throws WinnyProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write( ConvertUtil.toLittleEndianBytes( task_id ) );
            out.write( ConvertUtil.toLittleEndianBytes( response_block ) );
            out.write( hash );
            out.write( cache_data );
            data = out.toByteArray();
        }
        catch ( Exception e ) {
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                out.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void rawDataUnpack()
        throws WinnyProtocolException {
        _ByteArrayInputStream in = new _ByteArrayInputStream( data );
        try {
            task_id = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
            response_block = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
            hash = in.read( 16 );
            cache_data = in.read( in.available() );
        }
        catch ( IOException e ) {
            e.printStackTrace();
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                in.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    public int getTask_id() {
        return task_id;
    }

    public void setTask_id( int task_id ) {
        this.task_id = task_id;
    }

    public int getResponse_block() {
        return response_block;
    }

    public void setResponse_block( int response_block ) {
        this.response_block = response_block;
    }

    public byte[] getHash() {
        return hash;
    }

    public void setHash( byte[] hash ) {
        this.hash = hash;
    }

    public byte[] getCache_data() {
        return cache_data;
    }

    public void setCache_data( byte[] cache_data ) {
        this.cache_data = cache_data;
    }
}
