/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import jimmy.WinnyProtocolException;


/**
 * winny connection type command
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command02
    extends Command {

    public static enum LinkType {
        SEARCH, TRANSFER, BBS_SEARCH;
        static LinkType valueOf( int c ) {
            for ( LinkType t : LinkType.values() ) {
                if ( c == t.ordinal() ) {
                    return t;
                }
            }
            return null;
        }
    }

    LinkType type;

    boolean isPort0;

    boolean isBadPort0;

    boolean isBbsLink;

    @Override
    void rawDataPack()
        throws WinnyProtocolException {
        byte[] bs = new byte[4];
        bs[0] = (byte) type.ordinal();
        bs[1] = (byte) ( isPort0 ? 1 : 0 );
        bs[2] = (byte) ( isBadPort0 ? 1 : 0 );
        bs[3] = (byte) ( isBbsLink ? 1 : 0 );
        data = bs;
    }

    @Override
    void rawDataUnpack()
        throws WinnyProtocolException {
        type = LinkType.valueOf( data[0] );
        if ( type == null ) {
            throw new WinnyProtocolException( "unkown link type" );
        }
        isPort0 = data[1] == 1 ? true : false;
        isBadPort0 = data[2] == 1 ? true : false;
        isBbsLink = data[3] == 1 ? true : false;
    }

    public LinkType getType() {
        return type;
    }

    public void setType( LinkType type ) {
        this.type = type;
    }

    public boolean isPort0() {
        return isPort0;
    }

    public void setPort0( boolean isPort0 ) {
        this.isPort0 = isPort0;
    }

    public boolean isBadPort0() {
        return isBadPort0;
    }

    public void setBadPort0( boolean isBadPort0 ) {
        this.isBadPort0 = isBadPort0;
    }

    public boolean isBbsLink() {
        return isBbsLink;
    }

    public void setBbsLink( boolean isBbsLink ) {
        this.isBbsLink = isBbsLink;
    }

}
