/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy;

/**
 * checksum util
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Checksum {

    private Checksum() {
        super();
    }

    public static byte sum8(byte[] bs) {
        return (byte)(sum16(bs) & 0xFF);
    }
    
    public static short sum16(byte[] bs) {
        return (short)(sum32(bs) & 0xFFFF);
    }
    
    public static int sum32(byte[] bs) {
        int sum = 0;
        for (byte b : bs) {
            sum+=b;
        }
        return sum & 0xFFFFFFFF;
    }
    
    public static void main( String[] args ) {
        System.out.println(sum32("abc".getBytes()));
        System.out.println(sum16("abc".getBytes()));
    }
}
