/*
 * PingPong.java
 * IRCCoreTest
 *
 * Created by tarchan on 2007/02/17.
 * Copyright (c) 2007 tarchan. All rights reserved.
 */
package com.mac.tarchan.irc.sample;

import com.mac.tarchan.irc.IRCMessage;
import com.mac.tarchan.irc.IRCNetwork;

/**
 * PingPong
 * 
 * @author tarchan
 */
public class PingPong {
	/**
	 * IRCサーバからのPINGメッセージを表示します。
	 * 
	 * @param args
	 *            なし
	 */
	public static void main(String[] args) {
		IRCNetwork net = IRCNetwork.getNetwork("default");
		net.addClient(new PingPong());
		String addr = "irc://irc.tokyo.wide.ad.jp";
		String nick = "testbot121";
		String pass = "";
		print("login: %s %s %s", addr, nick, pass);
		net.login(addr, nick, pass);
	}

	public void replyPing(IRCMessage msg) {
		print("ping pong: %s", msg);
	}

	static void print(String s, Object... args) {
		System.out.printf(s + "\n", args);
	}
}
