/*
 * HelloAgain.java
 * IRCCoreTest
 *
 * Created by tarchan on 2007/02/17.
 * Copyright (c) 2007 tarchan. All rights reserved.
 */
package com.mac.tarchan.irc.sample;

import org.apache.log4j.Logger;

import com.mac.tarchan.irc.IRCMessage;
import com.mac.tarchan.irc.IRCNetwork;
import com.mac.tarchan.irc.IRCWriter;

/**
 * HelloAgain
 * 
 * @author tarchan
 * @author nori090
 */
public class HelloAgain {
	/** debug logger */
	private static Logger log = Logger.getLogger(HelloAgain.class);

	/**
	 * 他のユーザのメッセージに返事をします。
	 * 
	 * @param args
	 *            なし
	 */
	public static void main(String[] args) {
		IRCNetwork net = IRCNetwork.getNetwork("default");
		net.addClient(new HelloAgain());
		String addr = "irc://irc.media.kyoto-u.ac.jp/#nnntest";
		String nick = "nori090_b";
		String pass = "";
		System.out.println("login: " + addr + " " + nick + " " + pass);
		net.login(addr, nick, pass);
	}

	public void replyPrivmsg(IRCMessage msg) {
		final String encode ="ISO-2022-JP";
		System.out.println("privmsg: " + msg);
		System.out.println("trailing: " + msg.getTrailing(encode));
		IRCNetwork net = msg.getNetwork();
		IRCWriter out = net.writer(encode);
		String ch = msg.getTarget();
		String nick = msg.getNick();
		log.debug(msg.getTrailing(encode));
		log.debug(String.format("PRIVMSG %s :hello %s\n", ch, nick));
		out.format("PRIVMSG %s :hello %s", ch, nick);
		if ("exit".equals(msg.getTrailing(encode))) {
			out.format("QUIT","");
			msg.getNetwork().disconnect();
			return;
		}
	}
}
