/*
 * IRCNetworkTest.java
 * IRCCoreTest
 *
 * Created by tarchan on 2007/01/12.
 * Copyright (c) 2007 tarchan. All rights reserved.
 */
package com.mac.tarchan.irc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.mac.tarchan.irc.IRCChannel;
import com.mac.tarchan.irc.IRCNetwork;
import com.mac.tarchan.irc.IRCUser;

import junit.framework.TestCase;

/**
 * IRCNetworkTest
 *
 * @author tarchan
 */
public class IRCNetworkTest extends TestCase
{
	@Override
	protected void setUp() throws Exception
	{
		net = IRCNetwork.getNetwork("test");
		// clear
	}

	private IRCNetwork net;

	public void testChannel001()
	{
		IRCChannel ch1 = net.getChannel("#dameTunes");
		IRCChannel ch2 = net.getChannel("#dametunes");
		assertEquals("#dameTunes", ch1.getName());
		assertEquals("#dameTunes", ch2.getName());
	}

	public void testChannel002()
	{
		IRCChannel ch1 = net.getChannel("#dameTunes");
		IRCUser user1 = net.getUser("Kaho");
		ch1.addUser(user1);
		assertEquals(true, ch1.containsUser("Kaho"));
	}

	public void testChannel003()
	{
		IRCChannel ch1 = net.getChannel("#dameTunes");
		IRCUser user1 = net.getUser("Kaho");
		ch1.addUser(user1);
		assertEquals(true, ch1.containsUser("kaho"));
	}

	public void testChannel004()
	{
//		System.out.println("net=" + net);
		IRCChannel ch1 = net.getChannel("#dameTunes");
		IRCUser user1 = net.getUser("Kaho");
		ch1.addUser(user1);
//		System.out.println("net=" + net);
//		System.out.println("ch1=" + ch1);
		user1.nick("newNick");
//		System.out.println("net=" + net);
//		System.out.println("ch1=" + ch1);
		assertEquals(false, ch1.containsUser("Kaho"));
	}

	public void testChannel005()
	{
		try
		{
			IRCChannel ch1 = net.getChannel("#dameTunes");
			IRCUser user1 = net.getUser("Kaho");
//			System.out.println("ch1=" + ch1);
			ch1.addUser(user1);
//			System.out.println("ch1=" + ch1);
			user1.nick("testChannel005");
//			assertEquals(true, user1.containsChannel("#dameTunes"));
//			System.out.println("ch1=" + ch1);
			assertEquals(true, ch1.containsUser("testChannel005"));
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
			fail();
		}
	}

	public void testUser001()
	{
		IRCUser user1 = net.getUser("Kaho");
		IRCUser user2 = net.getUser("kaho");
		assertEquals("Kaho", user1.getNick());
		assertEquals("Kaho", user2.getNick());
	}

	public void testUser002()
	{
		IRCUser user1 = net.getUser("Kaho");
		user1.nick("testUser002");
		assertEquals("testUser002", user1.getNick());
	}

	public void testByte001()
	{
//		ByteBuffer ack = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
		ByteBuffer ack = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
//		ByteBuffer ack = ByteBuffer.allocate(4);
		ack.putInt((int)0x12345678);
		byte[] buf = ack.array();
		for (byte a : buf)
		{
			System.out.format("0x%x ", a);
		}
	}

	/** madokaのtailにマッチするパターン */
	private static final Pattern MADOKA_TAIL_PATTERN = Pattern.compile("^(Tail:.+|\\Q[!] end of taillog\\E)");

	public void testMadokaTail001()
	{
		String input = "Tail: 19:23:56 <%irodorie:Shiba> これでひとつ";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		m.find();
		assertEquals("Tail: 19:23:56 <%irodorie:Shiba> これでひとつ", m.group());
	}

	public void testMadokaTail002()
	{
		String input = "Tail: 19:25:52 [!] password/25";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		m.find();
		assertEquals("Tail: 19:25:52 [!] password/25", m.group());
	}

	public void testMadokaTail003()
	{
		String input = "[!] end of taillog";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		m.find();
		assertEquals("[!] end of taillog", m.group());
	}

	public void testMadokaTail004()
	{
		String input = "Tail: 19:23:56 <%irodorie:Shiba> これでひとつ";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		assertTrue(m.matches());
	}

	public void testMadokaTail005()
	{
		String input = "[!] end of taillog";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		assertTrue(m.matches());
	}

	public void testMadokaTail101()
	{
		String input = " Tail: 19:23:56 <%irodorie:Shiba> これでひとつ";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		assertFalse(m.find());
	}

	public void testMadokaTail102()
	{
		String input = " Tail: 19:25:52 [!] password/25";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		assertFalse(m.find());
	}

	public void testMadokaTail103()
	{
		String input = " [!] end of taillog";
		Matcher m = MADOKA_TAIL_PATTERN.matcher(input);
		assertFalse(m.find());
	}
}
