/*
 * IRCUser.java
 * IRCCore
 *
 * Created by tarchan on Aug 21, 2006.
 * Copyright (c) 2006 tarchan. All rights reserved.
 */
package com.mac.tarchan.irc;

import java.util.HashSet;

/**
 * IRCUser
 * 
 * @author tarchan
 * @author nori090
 */
public class IRCUser {
    private IRCNetwork net;

    private HashSet<IRCChannel> channels = new HashSet<IRCChannel>();

    private Object channel_lock = new Object();

    private String nick;

    private String user;

    private String real;

    private String oper;

    private String mode;

    private boolean away;

    private String awayMessage;

    public IRCUser( String name ) {
        String[] token = splitNick( name );
        oper = token[0];
        nick = token[1];
        real = token[2];
    }

    public void setNetwork( IRCNetwork network ) {
        if ( net != null )
            throw new RuntimeException( "already exsists: " + net );
        net = network;
    }

    public IRCChannel[] getChannels() {
        synchronized ( channel_lock ) {
            return (IRCChannel[]) channels.toArray( new IRCChannel[0] );
        }
    }

    public boolean containsChannel( String channel ) {
        IRCChannel ch = net.findChannel( channel );
        return ch != null && ch.containsUser( this );
    }

    public void nick( String newNick ) {
        net.renameUser( this.nick, newNick );
        this.nick = newNick;
    }

    public void mode( String mode ) {
        this.mode = mode;
    }

    public void join( IRCChannel channel ) {
        channel.addUser( this );
        synchronized ( channel_lock ) {
            channels.add( channel );
        }
    }

    public void part( IRCChannel channel ) {
        channel.removeUser( this );
        synchronized ( channel_lock ) {
            channels.remove( channel );
        }
    }

    public void quit() {
        synchronized ( channel_lock ) {
            for ( IRCChannel ch : channels ) {
                part( ch );
            }
        }
        net.removeUser( getNick() );
    }

    public String getNick() {
        return nick;
    }

    public String getUser() {
        return user;
    }

    public String getReal() {
        return real;
    }

    public String getOper() {
        return oper;
    }

    public String getMode() {
        return mode;
    }

    public boolean isAway() {
        return away;
    }

    public String getAwayMessage() {
        return awayMessage;
    }

    public void setAway( boolean away, String message ) {
        this.away = away;
        this.awayMessage = message;
    }

    protected static String[] splitNick( String name ) {
        String[] nick = new String[3];
        nick[1] = name;
        if ( name.startsWith( "@" ) ) {
            name = name.substring( 1 );
            nick[0] = "@";
            nick[1] = name;
        }
        if ( name.indexOf( "~" ) >= 0 ) {
            int index = name.indexOf( "~" );
            nick[1] = name.substring( 0, index );
            nick[2] = name.substring( index );
        }

        return nick;
    }

    public String toString() {
        return nick;
    }
}
