/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.df;

/**
 * @author nori090
 * @version $Rev: 167 $ $Date: 2008-09-05 23:46:39 +0900 (Fri, 05 Sep 2008) $
 */
public class Player {
    String name;

    int number;

    int point;

    public Player( String name, int number ) {
        this.name = name;
        this.number = number;
    }

    public int getPoint() {
        return point;
    }

    public void setPoint( int point ) {
        this.point = point;
    }

    public void addPoint( int point ) {
        this.point += point;
    }

    public String getName() {
        return name;
    }

    public int getNumber() {
        return number;
    }

    @Override
    public boolean equals( Object obj ) {
        if ( this == obj )
            return true;
        if ( obj == null )
            return false;
        if ( getClass() != obj.getClass() )
            return false;
        final Player other = (Player) obj;
        if ( name == null ) {
            if ( other.name != null )
                return false;
        }
        else if ( !name.equals( other.name ) )
            return false;
        return true;
    }

    @Override
    public String toString() {
        return String.format( "%s(%d) point=%d", this.getName(), this.getNumber(),
                              this.getPoint() );
    }
}
