/*
 * StringArray.java
 * IRCCore
 *
 * Created by tarchan on 2006/12/21.
 * Copyright (c) 2006 tarchan. All rights reserved.
 */
package com.mac.tarchan.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * StringArray
 * 
 * @author tarchan
 */
public class StringArray {
    private List<String> strings;

    public StringArray( String... input ) {
        this.strings = new ArrayList<String>( Arrays.asList( input ) );
    }

    public static StringArray split( String input, String delimiter ) {
        String[] strings = input.split( delimiter );
        return new StringArray( strings );
    }

    public static StringArray split( String input, String... delimiter ) {
        // System.out.println("delimiter=" + Arrays.asList(delimiter));
        ArrayList<String> list = new ArrayList<String>();
        for ( String d : delimiter ) {
            // System.out.println("str=" + str);
            String[] strings = input.split( d, 2 );
            input = strings.length < 2 ? "" : strings[1];
            list.add( strings[0] );
        }
        list.add( input );
        String[] strings = new String[list.size()];
        list.toArray( strings );
        // System.out.println("sa=" + new StringArray(strings));
        return new StringArray( strings );
    }

    public String join( String delimiter ) {
        StringBuilder buf = null;
        for ( String param : strings ) {
            if ( buf == null ) {
                buf = new StringBuilder( param );
            }
            else {
                buf.append( delimiter );
                buf.append( param );
            }
        }

        return buf.toString();
    }

    public boolean contains( String input ) {
        for ( String param : strings ) {
            if ( param.equals( input ) )
                return true;
        }

        return false;
    }

    public boolean containsIgnoreCase( String input ) {
        for ( String param : strings ) {
            if ( param.equalsIgnoreCase( input ) )
                return true;
        }

        return false;
    }

    public String indexAt( int index ) {
        return strings.get( index );
    }

    public String toString() {
        return "[" + join( ", " ) + "]";
    }
}
