﻿using System;
using Box2DX.Common;
using Box2DX.Dynamics;
using DxLibDLL;
using Nlgp1.Common;
using Nlgp1.Drawers;
using Nlgp1.Sprites;
using Nlgp1.Stages;
using Nlgp1.Utilities;

namespace Nlgp1.Characters {
	public static class SpriteFactory {
		/// <summary>
		/// スプライトを生成してマップ上に配置します。
		/// </summary>
		/// <param name="world">Worldオブジェクト</param>
		/// <param name="chipId">生成するスプライトを表すチップID</param>
		/// <param name=param name="friction">摩擦力</param>
		/// <param name="location">初期位置</param>
		/// <returns>生成されたスプライトオブジェクト</returns>
		public static Sprite Load( World world , ChipId chipId , double friction , Vec2 location ) {
			var sprite = new Sprite( world , chipId , friction , location );
			switch( chipId.LayerType ) {
			case LayerType.Front:
				switch( chipId.Index ) {
				}
				break;
			case LayerType.Characters:
				switch( chipId.Index ) {
				case 2:
					break;
				case 4:
					#region ゆっくりと左に歩いてくる
					#endregion
					break;
				case 5:
					#region ゆっくりと右に歩いてくる
					#endregion
					break;
				case 6:
					#region ジャンプしながら左に向かってくる
					#endregion
					break;
				case 7:
					#region ジャンプしながら右に向かってくる
					#endregion
					break;
				case 8:
					#region 壁にぶつかったら方向転換して左右に移動する
					#endregion
					break;
				case 9:
					#region 床から落下しないように左右に移動する。
					#endregion
					break;
				case 10:
					#region 上下に浮遊する
					#endregion
					break;
				case 11:
					#region 時計回り
					#endregion
					break;
				case 12:
					#region 反時計回り
					#endregion
					break;
				case 13:
					#region 空中を回転しながら浮遊する
					#endregion
					break;
				case 14:
					#region 10秒アイテム
					#endregion
					break;
				case 15:
					#region 乗ると強制的に右に移動する
					#endregion
					break;
				case 16:
					#region 乗ると強制的に左に移動する
					#endregion
					break;
				case 17:
					break;
				}
				break;
			}
			return sprite;
		}
	}
}
