﻿using System;
using System.IO;
using DxLibDLL;
using Nlgp1.Common;

namespace Nlgp1 {

	public sealed class MenuScreen : Screen , IDisposable {

		public MenuScreen( int stageIndex ) {
			this.font = DX.CreateFontToHandle( "ＭＳ ゴシック" , 8 * unit , -1 );
			this.stageIndex = stageIndex;
		}

		public MenuScreen() : this( 1 ) {
			// ステージを読み込む(マップ・チップ)
			string stageFile = Path.Combine( Program.CurrentDirectory , "stagenumber.txt" );
			if( File.Exists( stageFile ) )
				stageIndex = Utility.TryParse<int>( File.ReadAllText( stageFile ).Trim() );
		}

		public void Dispose() {
			this.font.Dispose();
		}

		public override void Draw() {
			DX.DrawTriangle( -11 * unit + originX , 0 * unit + originY , -8 * unit + originX , -3 * unit + originY , -8 * unit + originX , +3 * unit + originY , new DX.COLOR_U8( 0xFF , 0xFF , 0xFF ) , true );
			DX.DrawStringToHandle( -8 * unit + originX , -4 * unit + originY , string.Format( "{0,3}" , stageIndex ) , new DX.COLOR_U8( 0xFF , 0xFF , 0xFF ) , this.font );
			DX.DrawTriangle( +11 * unit + originX , 0 * unit + originY , +8 * unit + originX , -3 * unit + originY , +8 * unit + originX , +3 * unit + originY , new DX.COLOR_U8( 0xFF , 0xFF , 0xFF ) , true );
		}

		public override Screen Update( Controller controller ) {
			if( controller.Cancel.IsDown ) {
				this.Dispose();
				return null;
			}
			if( controller.Ok.IsDown ) {
				this.Dispose();
				return new GameScreen( this.stageIndex );
			}
			if( controller.Left.IsDown ) {
				if( this.stageIndex > 1 ) {
					--this.stageIndex;
				}
			}
			if( controller.Right.IsDown ) {
				++this.stageIndex;
			}
			return this;
		}

		private const int unit = 3;
		private const int originX = Program.ScreenWidth / 2;
		private const int originY = Program.ScreenHeight / 2;
		private readonly DX.Font font;
		private int stageIndex;
	}
}
