﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using DxLibDLL;
using Nlgp1.Common;
using Nlgp1.Sprites;

// [重要]このコードは、暫定版であり実験用コードを含みます。将来的に設計・実装が変更されます。
// これらのコードを生放送等で配信することは、構いませんが実装者の許可無く無断で
// 放送等で晒し目的で利用することを禁止します。改変・改良は、構いません。
// 不満点があれば、開発者に直接伝達を行うか各自で修正を行い、その理由をコメント等で明記して下さい。

namespace Nlgp1.Drawers {
	/// <summary>
	/// チップセット(グラフィッククラス)
	/// </summary>
	public sealed class ChipsetImage {
		/// <summary>
		/// ステージを読み込みます。
		/// </summary>
		/// <param name="chipCount">チップ数</param>
		public static void LoadStage( int chipCount ) {
			chipsetImageList = new Dictionary< ChipId , ChipsetImage >( chipCount );
		}

		private List<ChipImage> chipImages;

		/// <summary>
		/// Chipsetクラス(コンストラクタ)
		/// </summary>
		/// <param name="chipsetGraph">チップセットのイメージ</param>
		private ChipsetImage( DX.Graph chipsetGraph ) {
			int graphHeight;
			int graphWidth;
			DX.GetGraphSize(chipsetGraph, out graphWidth, out graphHeight);
			int height = graphHeight / ChipImage.SizeSide;
			int width = graphWidth / ChipImage.SizeSide;
			chipImages = new List<ChipImage>(height * width);

			for (int y = 0; y < height; ++y) {
				for (int x = 0; x < width; ++x) {
					chipImages.Add(new ChipImage(chipsetGraph, new DX.POINT(x * ChipImage.SizeSide, y * ChipImage.SizeSide)));
				}
			}
			chipImages.TrimExcess();
		}

		/// <summary>
		/// チップ番号(画像番号)で指定したチップを取得します。
		/// </summary>
		/// <param name="number">チップ番号(画像番号)</param>
		/// <returns>チップイメージ</returns>
		public ChipImage GetChipImage(int number) {
			return chipImages[number];
		}

		/// <summary>
		/// 読み込まれたチップの枚数を取得します。
		/// </summary>
		public int Count {
			get{
				return chipImages.Count;
			}
		}

		private static Dictionary< ChipId , ChipsetImage > chipsetImageList;

		public static ChipsetImage Load( string path , ChipId chipId ) {
			ChipsetImage chipsetImage;
			if( chipsetImageList.TryGetValue( chipId , out chipsetImage ) ) {
				return chipsetImage;
			}
			else {
				var graph = CreateGraph( path );
				if( graph == null )
					return null;
				chipsetImage = new ChipsetImage( graph );
				chipsetImageList[ chipId ] = chipsetImage;
				return chipsetImage;
			}
		}
		private static DX.Graph CreateGraph( string path ) {
			if( Program.CurrentDirectory == null )
				return null;
			if( File.Exists( Path.Combine( Program.CurrentDirectory , path ) ) == false )
				return null;

			return DX.LoadGraph( Path.Combine( Program.CurrentDirectory , path ) );
		}
	}
}
