﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Controls;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Notifies.LayerChipProperties;
using System.Drawing;
using Nlgp1.Common;
using Nlgp1.StageEditor.Instances;

namespace Nlgp1.StageEditor.Notifies {
	public static class NotifyLoader {
		public static void LoadStageFromFile( StageNotify stageNotify , EditorNotify editor , string path ) {
			var stageData = StageData.Load( path );

			var chipSize = LayerChipData.SizeSide;
			var mapRowCount = stageData.MapRowCount;
			var mapColumnCount = stageData.MapColumnCount;

			editor.Create();
			stageNotify.Create( path , chipSize , mapRowCount , mapColumnCount );

            stageNotify.BgmPath = stageData.BgmPath;

			foreach( var layerData in stageData.Layers ) {
				var layerNotify = LayerInstance.Add( layerData.Name );
				foreach( var chipData in layerData.Chips ) {
					var chipProperty = new LayerChipProperty();
					chipProperty.Name = chipData.Name;
					chipProperty.Friction = chipData.Friction;
					chipProperty.Type = chipData.Type.ToString();
					chipProperty.Summary = chipData.Summary;
					ChipsetInstance.Add( layerNotify , new LayerChipNotify( chipData.Index , chipProperty ) );
				}
				layerNotify.ChipsetPath = layerData.ChipsetPath;
				LayerInstance.LoadImage( layerNotify , layerData.ChipsetImagePath );
				var mapData = layerData.Map;
				var mapNotify =  new LayerChipNotify[ mapData.GetLength( 0 ) , mapData.GetLength( 1 ) ];
				for( int y = 0 ; y < mapNotify.GetLength( 0 ) ; y++ ) {
					for( int x = 0 ; x < mapNotify.GetLength( 1 ) ; x++ ) {
						mapNotify[ y , x ] = layerNotify.ChipTable[ mapData[ y , x ].Index ];
					}
				}
				LayerInstance.SetMap( layerNotify , mapNotify );

				editor.SetCurrentChip( layerNotify , layerNotify.ChipTable[ 0 ] );
			}

			LayerInstance.SetCurrentLayer( 0 );
			//LayerSettingController.SetGridProperty( true , 32 , Color.Black );
			LayerSettingInstance.SetGridProperty( true , 32 , Color.Yellow );
		}
	}
}
