﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Drawing.Design;
using Nlgp1.StageEditor.Notifies.LayerChipProperties;
using Nlgp1.Common;

namespace Nlgp1.StageEditor.Notifies {
	public class LayerChipNotify : INotifyPropertyChanged {
		public static readonly LayerChipNotify None = new LayerChipNotify( -1 );

		public int Index {
			get;
			private set;
		}
		public LayerChipProperty Property {
			get;
			private set;
		}

		public LayerChipNotify( int index ) {
			this.Index = index;
			LayerChipProperty chipProperty = new LayerChipProperty();
			if( index > 0 ) {
				chipProperty.Type = default( LayerChipType ).ToString();
				chipProperty.Name = index.ToString();
				chipProperty.Friction = 1;
				chipProperty.Summary = "新規チップ";
			}
			else if( index == 0 ) {
				chipProperty.Name = "NONE";
				chipProperty.Type = default( LayerChipType ).ToString();
				chipProperty.Summary = "none chip";
			}
			else {
				chipProperty.Name = "EMPT";
				chipProperty.Type = default( LayerChipType ).ToString();
				chipProperty.Friction = 0;
				chipProperty.Summary = "empty chip!";
			}
			this.Property = chipProperty;
		}

		public LayerChipNotify( int index , LayerChipProperty chipProperty ) {
			this.Index = index;
			this.Property = chipProperty;
		}

		public void SetIndex( int index ) {
			this.Index = index;

			OnPropertyChanged( "SetIndex" );
		}

		public void SetProperty( LayerChipProperty chipProperty ) {
			this.Property = chipProperty;

			OnPropertyChanged( "SetProperty" );
		}

		#region INotifyPropertyChanged メンバ

		public event PropertyChangedEventHandler PropertyChanged;
		public void OnPropertyChanged( string name ) {
			if( PropertyChanged == null )
				return;

			var e = new PropertyChangedEventArgs( name );
			PropertyChanged( this , e );
		}

		#endregion
	}
}
