﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nlgp1.StageEditor.Notifies;
using Nlgp1.StageEditor.Controls;
using Nlgp1.StageEditor.Notifies.LayerChipProperties;

namespace Nlgp1.StageEditor.Instances
{
	public static class ChipsetInstance
	{
		private static StageEditorForm stageEditor;
		private static StageNotify stage;
		private static EditorNotify editor;

		public static void Initialize(StageEditorForm stageEditor, EditorNotify editor, StageNotify stage)
		{
			ChipsetInstance.stageEditor = stageEditor;
			ChipsetInstance.stage = stage;
			ChipsetInstance.editor = editor;
		}

		public static void Add(LayerNotify layer, LayerChipNotify chip )
		{
			chip.PropertyChanged += stageEditor.MapControl.ChipData_PropertyChanged;
			chip.PropertyChanged += stageEditor.LayerChipControl.ChipData_PropertyChanged;
			chip.PropertyChanged += stageEditor.LayerChipsetControl.ChipData_PropertyChanged;

			layer.AddChip(chip);
			editor.SetCurrentChip(layer, chip);
			if (editor.CurrentLayer == layer)
			{
				editor.CurrentChip = chip;
			}
		}

		public static void Remove(LayerNotify layer, LayerChipNotify chip)
		{
			var prevChip = layer.GetPreviousChip(editor.CurrentChip);
			layer.RemoveChip(chip);
			editor.SetCurrentChip(layer, prevChip);
			if (editor.CurrentLayer == layer)
			{
				editor.CurrentChip = prevChip;
			}
		}


		public static void SetProperty(LayerChipNotify chip, LayerChipProperty chipProperty)
		{
			chip.SetProperty(chipProperty);
		}

		public static void SetCurrentChip(LayerChipNotify chip)
		{
			editor.CurrentChip = chip;
		}
	}
}