﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Nlgp1.Common;

namespace Nlgp1.StageEditor.Controls {
	public partial class LayerChipTypeControl : UserControl {
		private CheckBox[] checkBoxes;

		public LayerChipType Type {
			get {
				return this.checkBoxes.Aggregate( default( LayerChipType ) , ( type , checkBox ) => {
					if( checkBox.Checked ) {
						return type | checkBox.Text.ToEnum< LayerChipType >();
					}
					else {
						return type;
					}
				} );
			}
			set {
				foreach( var checkBox in this.checkBoxes ) {
					checkBox.Checked = ( ( value & checkBox.Text.ToEnum< LayerChipType >() ) != 0 );
				}
			}
		}

		public LayerChipTypeControl() {
			InitializeComponent();
			this.checkBoxes = new CheckBox[] {
				this.wallCheckBox ,
				this.destroyableCheckBox ,
				this.specialCheckBox ,
				this.characterCheckBox ,
			};
		}
	}
}
