﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Nlgp1.StageEditor.Notifies;

namespace Nlgp1.StageEditor.Controls
{
	public partial class LayerChipSelectorControl : Form
	{
		private int selectedNumber;
		public int SelectedNumber
		{
			get { return selectedNumber; }
			set
			{
				if (selectedNumber == value) return;
				selectedNumber = value;
				ImagePicture.Image = LayerImage[selectedNumber];
				NumberTextBox.Text = selectedNumber.ToString();
			}
		}
		public ChipsetImage LayerImage { get; set; }

		public LayerChipSelectorControl()
		{
			InitializeComponent();

			this.Load += UpdateSize;
			this.ThumbnailBase.Resize += UpdateSize;
			this.Thumbnail.Paint += Thumbnail_Paint;
			this.Thumbnail.MouseClick += Thumbnail_MouseClick;
		}

		private void UpdateSize(object sender, EventArgs e)
		{
			var scrollThick = 17;
			var clientWidth = ThumbnailBase.Width - scrollThick;
			var clientHeight = ThumbnailBase.Height - scrollThick;

			var chipSize = ChipsetImage.ChipSize;
			var chipNum = LayerImage.Count + 1;

			var width = (clientWidth / chipSize) * chipSize;
			var column = width / chipSize;

			var newColumn = Math.Max(column, 1);
			var newRow = (int)Math.Ceiling((float)chipNum / newColumn);
			newRow = Math.Max(newRow, 1);

			var newWidth = newColumn * chipSize + 1;
			var newHeight = newRow * chipSize + 1;

			this.Thumbnail.Size = new Size(newWidth, newHeight);
		}

		public void Thumbnail_MouseClick(object sender, MouseEventArgs e)
		{
			if (e.Button != MouseButtons.Left) return;

			var chipSize = ChipsetImage.ChipSize;
			var width = (Thumbnail.Width / chipSize) * chipSize;
			var height = (Thumbnail.Height / chipSize) * chipSize;
			var isRangeOver = (e.X > width || e.Y > height);
			if (isRangeOver) return;

			var row = height / chipSize;
			var column = width / chipSize;
			var x = e.X / chipSize;
			var y = e.Y / chipSize;
			var gridNumber = x + y * column;

			if (gridNumber >= LayerImage.Count + 1) return;

			this.SelectedNumber = gridNumber - 1;

			Refresh();
		}

		public void Thumbnail_Paint(object sender, PaintEventArgs e)
		{
			var chipSize = ChipsetImage.ChipSize;
			var column = Thumbnail.Width / chipSize;

			var gridPen = Pens.Black;
			var imageList = LayerImage.ToList();
			imageList.Insert(0, null);
			var i = 0;
			foreach (var image in imageList)
			{
				var x = (i % column) * chipSize;
				var y = (i / column) * chipSize;
				if (image != null)
				{
					e.Graphics.DrawImage(image, x, y);
				}

				var rect = new Rectangle(x, y, chipSize, chipSize);
				e.Graphics.DrawRectangle(gridPen, rect);
				i++;
			}

			var currentPen = Pens.Yellow;
			var number = SelectedNumber + 1;
			var currentX = (number % column) * chipSize;
			var currentY = (number / column) * chipSize;
			var currentRect = new Rectangle(currentX, currentY, chipSize, chipSize);
			e.Graphics.DrawRectangle(currentPen, currentRect);
		}

		private void SelectedButton_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}

		private void CancelButton_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
		}
	}
}
