﻿using System;

namespace Nlgp1.Common {
	/// <summary>
	/// チップの属性を表します。
	/// </summary>
	[Flags]
	public enum LayerChipType {
		/// <summary>
		/// なし
		/// </summary>
		None = 0 ,
		/// <summary>
		/// ブロック
		/// </summary>
		Wall = 2 ,
		/// <summary>
		/// 破壊できる
		/// </summary>
		Destroyable = 4 ,
		/// <summary>
		/// 破壊できるブロック
		/// </summary>
		DestroyableWall = Destroyable | Wall ,
		/// <summary>
		/// 特殊
		/// </summary>
		Special = 512 ,
		/// <summary>
		/// キャラクタ
		/// </summary>
		Character = 1024
	}

	/// <summary>
	/// レイヤーの種類を表します。
	/// </summary>
	public enum LayerType {
		/// <summary>
		/// バックグラウンド
		/// </summary>
		Back ,
		/// <summary>
		/// バックグラウンド(中間)
		/// </summary>
		BackMiddle ,
		/// <summary>
		/// 中間
		/// </summary>
		Middle ,
		/// <summary>
		/// 中間(前面)
		/// </summary>
		MiddleFront ,
		/// <summary>
		/// 前面
		/// </summary>
		Front ,
		/// <summary>
		/// キャラクタ
		/// </summary>
		Characters
	}

	/// <summary>
	/// モーションの種類
	/// </summary>
	public enum MotionChipType {
		/// <summary>
		/// なし
		/// </summary>
		[Utility.EnumLabel( "なし" )]
		None ,
		/// <summary>
		/// 右を向いて静止
		/// </summary>
		[Utility.EnumLabel( "右向き(静止)" )]
		RestRight ,
		/// <summary>
		/// 左を向いて静止
		/// </summary>
		[Utility.EnumLabel( "左向き(静止)" )]
		RestLeft ,
		/// <summary>
		/// 右に歩行
		/// </summary>
		[Utility.EnumLabel( "右-歩行" )]
		WalkRight ,
		/// <summary>
		/// 左に歩行
		/// </summary>
		[Utility.EnumLabel( "左-歩行" )]
		WalkLeft ,

		/// <summary>
		/// 右上に移動
		/// </summary>
		[Utility.EnumLabel( "右上-移動" )]
		UpRight ,
		/// <summary>
		/// 左上に移動
		/// </summary>
		[Utility.EnumLabel( "左上-移動" )]
		UpLeft ,
		/// <summary>
		/// 右下に移動
		/// </summary>
		[Utility.EnumLabel( "右下-移動" )]
		DownRight ,
		/// <summary>
		/// 左下に移動
		/// </summary>
		[Utility.EnumLabel( "左下-移動" )]
		DownLeft,


		/// <summary>
		/// 右に高速移動
		/// </summary>
		[Utility.EnumLabel( "右-高速移動" )]
		BoostRight ,
		/// <summary>
		/// 左に高速移動
		/// </summary>
		[Utility.EnumLabel( "左-高速移動" )]
		BoostLeft ,
		/// <summary>
		/// 上に高速移動
		/// </summary>
		[Utility.EnumLabel( "上-高速移動" )]
		BoostTop ,
		/// <summary>
		/// 下に高速移動
		/// </summary>
		[Utility.EnumLabel( "下-高速移動" )]
		BoostBottom ,

		/// <summary>
		/// 右上に高速移動
		/// </summary>
		[Utility.EnumLabel( "右上-高速移動" )]
		BoostUpRight ,
		/// <summary>
		/// 左上に高速移動
		/// </summary>
		[Utility.EnumLabel( "左上-高速移動" )]
		BoostUpLeft ,
		/// <summary>
		/// 右下に高速移動
		/// </summary>
		[Utility.EnumLabel( "右下-高速移動" )]
		BoostDownRight ,
		/// <summary>
		/// 左下に高速移動
		/// </summary>
		[Utility.EnumLabel( "左下-高速移動" )]
		BoostDownLeft,

		/// <summary>
		/// 右向きで撃していない
		/// </summary>
		[Utility.EnumLabel( "右向き未攻撃" )]
		RightAttackNone,
		/// <summary>
		/// 右向きで攻撃準備中
		/// </summary>
		[Utility.EnumLabel( "右向き攻撃準備中" )]
		RightAttackStarting,
		/// <summary>
		/// 右向きで攻撃中
		/// </summary>
		[Utility.EnumLabel( "右向き攻撃中" )]
		RightAttacking,
		/// <summary>
		/// 右向きで攻撃完了
		/// </summary>
		[Utility.EnumLabel( "右向き攻撃完了" )]
		RightAttacked,

		/// <summary>
		/// 左向きで攻撃していない
		/// </summary>
		[Utility.EnumLabel( "左向き未攻撃" )]
		LeftAttackNone ,
		/// <summary>
		/// 左向きで攻撃準備中
		/// </summary>
		[Utility.EnumLabel( "左向き攻撃準備中" )]
		LeftAttackStarting ,
		/// <summary>
		/// 左向きで攻撃中
		/// </summary>
		[Utility.EnumLabel( "左向き攻撃中" )]
		LeftAttacking ,
		/// <summary>
		/// 左向きで攻撃完了
		/// </summary>
		[Utility.EnumLabel( "左向き攻撃完了" )]
		LeftAttacked
	}
}
