﻿using System;
using System.Collections.Generic;
using System.Text;
using Box2DX.Collision;


namespace Nlgp1.B2DX
{
	/// <summary>
	/// HPだとか発動したいイベントを内包したり、オブジェクトがデータを持つ時に使用する
	/// </summary>
	public class myUserData
	{
		public string name;
		public int id;
		public Shape preCollide;
		public FilterData filter;
		public int HP;
		public bool JointBroken;
		public RigidBody Body;
		
		public myUserData()
		{
			
			filter.CategoryBits = Convert.ToUInt16("2");
			filter.MaskBits = filter.CategoryBits;
			filter.GroupIndex = 1;
			name = "default";
			id = 0;
			preCollide = null;
			HP = 1;
			JointBroken = false;
		}
		/// <summary>
		/// 名前やID、フィルターを指定します
		/// </summary>
		/// <param name="name">名前</param>
		/// <param name="id">ID</param>
		/// <param name="filter">フィルター</param>
		/// <param name="HP">HP、ぶつかったときに相手のHPを減らすとかできます（ContactEvent参照）</param>
		public myUserData(string name, int id, FilterData filter, int HP)
		{
			this.name = name;
			this.id = id;
			this.filter = filter;
			this.HP = HP;
		}
		/// <summary>
		/// 名前やID、フィルターを指定します
		/// </summary>
		/// <param name="name">名前</param>
		/// <param name="id">ID</param>
		/// <param name="filter">フィルター</param>
		/// <param name="HP">HP、ぶつかったときに相手のHPを減らすとかできます（ContactEvent参照）</param>
		/// <param name="body">RigidBodyを追加します、このコンストラクタでしか追加されないので、nullにご用心</param>
		public myUserData(string name, int id, FilterData filter, int HP, RigidBody body)
			: this(name, id, filter, HP)
		{
			Body = body;
		}
		
	}
	
}
