﻿using System;
using System.Collections.Generic;
using System.Text;
using Box2DX.Collision;
using Box2DX.Common;
using Box2DX.Dynamics;

namespace Nlgp1.B2DX
{
	public class StaticRigid:RigidBody
	{


		//float rest = 0.6f, dens = 0, fric = 0.3f;
		
		public StaticRigid(Vec2 pos, float angle, World world,
			float boxwidth, float boxheight, bool noRotateFlag,
			Dictionary<UserDataKind, string> userdata,
			bool allowregenerate)
			: base(pos, angle, world, boxwidth, boxheight, noRotateFlag, userdata, 
			new Dictionary<ObjectDataKind, float> {{ObjectDataKind.Density,0 }},allowregenerate)
		{
			//ボディの仮想的な初期状態を定義する
			//Bodydef.Angle = angle;
			//Bodydef.Position = pos;
			//Bodydef.FixedRotation = noRotateFlag;
			//ボディの回転減衰率
			//Bodydef.AngularDamping = 5;

			//NoRotateFlag = noRotateFlag;
			//makepolygon(boxwidth, boxheight, world, userdata);


		}
		public StaticRigid(Vec2 pos, float angle, World world,
			float boxwidth, float boxheight, bool noRotateFlag,
			Dictionary<UserDataKind, string> userdata):
			base(pos, angle, world, boxwidth, boxheight, noRotateFlag, userdata,
			new Dictionary<ObjectDataKind, float> { { ObjectDataKind.Density, 0 } }, false)
		{

		}
		/// <summary>
		/// 動かないBoxです
		/// </summary>
		/// <param name="pos">位置</param>
		/// <param name="angle">角度</param>
		/// <param name="lind">運動しないので0で</param>
		/// <param name="angd">角速度なんかないので0で</param>
		public StaticRigid(Vec2 pos, float angle, float lind, float angd) : base(pos, angle, lind, angd) { }
		/*
		//特に必要ない
		void makepolygon(float boxwidth, float boxheight, World world, Dictionary<UserDataKind, string> userdata)
		{
			//ポリゴンの形状を決定する
			Boxheight = boxheight;
			Boxwidth = boxwidth;

			//if (userdata.ContainsKey(UserDataKind.Name)) UserData.name = userdata[UserDataKind.Name];
			if (userdata.ContainsKey(UserDataKind.Filter))
			{
				FilterData fil = new FilterData();
				fil.CategoryBits = Convert.ToUInt16(userdata[UserDataKind.Filter]);
				fil.MaskBits = fil.CategoryBits;
				UserData.filter = fil;
			}
			Bodydef.UserData = UserData;


			SelfBody = world.CreateBody(Bodydef);
			PolygonDef p = def(rest, dens, fric, UserData.filter);
			p.SetAsBox(boxwidth, boxheight);
			SelfBody.CreateShape(p);
			
			//SelfBody.SetMassFromShapes();
		}
		*/
		/// <summary>
		/// ポリゴン定義
		/// </summary>
		/// <param name="rest">反発</param>
		/// <param name="dens">密度</param>
		/// <param name="fric">摩擦</param>
		/// <returns></returns>
		static PolygonDef def(float rest, float dens, float fric,FilterData fil)
		{
			PolygonDef p = new PolygonDef();
			p.Restitution = rest;
			p.Density = dens;
			p.Friction = fric;
			p.Filter = fil;
			return p;
		}
		
	
	}
}
