﻿using System;
using System.Collections.Generic;
using System.Text;
using Box2DX.Collision;
using Box2DX.Common;
using Box2DX.Dynamics;

namespace Nlgp1.B2DX
{
	public class Joints
	{
		Body box1, box2;
		JointDef jd;

		public Joints(Body b1, Body b2)
		{
			box1 = b1; box2 = b2;
		}

		
		/// <summary>
		/// bodyとbodyの距離を固定する
		/// </summary>
		/// <returns></returns>
		public DistanceJointDef MakeDistanceJoint()
		{
			DistanceJointDef djd = new DistanceJointDef();
			djd.Initialize(box1, box2, box1.GetWorldCenter(), box2.GetWorldCenter());
			jd=djd;
			return djd;
		}
		/// <summary>
		/// box1をbox2(groundbody等)に固定させ、box1の重心を中心に回転させる
		/// </summary>
		/// <returns></returns>
		public RevoluteJointDef MakeRevoluteJoint()
		{
			RevoluteJointDef rjd = new RevoluteJointDef();
			rjd.Initialize(box1, box2,box1.GetWorldCenter());
			jd=rjd;
			return rjd;
		}
		/// <summary>
		/// ジョイントを再結合する
		/// </summary>
		/// <param name="b1">結合されるbody</param>
		/// <param name="b2">結合するbody</param>
		public void ReConnect(Body b1, Body b2)
		{
			try
			{
				jd.Body1 = b1;
				jd.Body2 = b2;
			} catch
			{
				throw new Exception("ジョイントが未定義です");
			}
		}

	}
}
