﻿namespace Nlgp1.B2DX
{
	public enum UserDataKind
	{
		Name,
		/// <summary>
		/// フィルター。単純な衝突判定の時にはこちらを使う、マスクとカテゴリに同値が入る。
		/// </summary>
		Filter,
		/// <summary>
		/// カテゴリのビット。マスクと組み合わせて複雑な衝突判定をあらわす。
		/// </summary>
		CategoryBits,
		/// <summary>
		/// マスクのビット。カテゴリと組み合わせて複雑な衝突判定をあらわす。
		/// </summary>
		MaskBits,
		/// <summary>
		/// グループのインデックス。同じグループにいる場合、必ず衝突し、負の同じグループにいるのなら必ず衝突しない
		/// </summary>
		GroupIndex,
	}

	public enum ObjectDataKind
	{
		/// <summary>
		/// 物質の密度を指定します、50位でかなり重たい物体、0.1f位でかなり軽い物体、0で動かない物体になります
		/// </summary>
		Density,
		/// <summary>
		/// 反発を指定します、デフォルトでは0.6fが入ります、結構強めに跳ね返ってます
		/// </summary>
		Restitution,
		/// <summary>
		/// 摩擦を指定します、デフォルトでは0.3fが入ります、あまり滑らない感じです
		/// </summary>
		Friction,
		/// <summary>
		/// 回転の減衰率を指定します、デフォルトでは5、あまり回りません
		/// </summary>
		AngularDamping,
		/// <summary>
		/// 加速の減衰率を指定します、デフォルトでは0、特に減衰しません
		/// </summary>
		LinearDamping,
		
	}
	public enum Colors
	{
		/// <summary>
		/// 非表示
		/// </summary>
		None,
		Red,
		Blue,

	}
}