﻿using System;
using System.Collections.Generic;
using System.Text;
using Box2DX.Collision;
using Box2DX.Common;
using Box2DX.Dynamics;

namespace Nlgp1.B2DX
{
	public class ContactEvent:ContactListener
	{
		public override void Persist(ContactPoint point)
		{
			contactRaise(point);
			Debug.PrintContact(point.Position);
		}

		public override void Add(ContactPoint point)
		{

			contactRaise(point);
			Debug.PrintContact(point.Position);
		}
		public override void Result(ContactResult point)
		{
			base.Result(point);
		}

		void contactRaise(ContactPoint p)
		{
			/*todo GetBodyを参照しないといけない理由
			 */
			myUserData u = p.Shape1.GetBody().GetUserData() as myUserData;
			myUserData u2 = p.Shape2.GetBody().GetUserData() as myUserData;
			//何故かはわからないが、shape1は必ずあたった方になる
			//あてられた方のデータをUserDataに記憶している
			u.preCollide = p.Shape2;
			p.Shape1.GetBody().SetUserData(u);

			if (u == null || u2 == null) return;

			if (u.name == "player")
			{
				Debug.DebugHit(u.name + " hits " + u2.name);

			}
		}
	}
}
