﻿using System;
using System.Collections.Generic;
using System.Text;
using Box2DX.Collision;
using Box2DX.Dynamics;
using Box2DX.Common;


namespace Nlgp1.B2DX
{
	public static class CalcfromShape
	{
		public static float GetUpper(Shape s)
		{
			AABB aabb;
			Caabb(out aabb, s);
			return aabb.LowerBound.Y;
		}
		public static float GetBottom(Shape s)
		{
			AABB aabb;
			Caabb(out aabb, s);
			return aabb.UpperBound.Y;
		}
		public static float GetLeft(Shape s)
		{
			AABB aabb;
			Caabb(out aabb, s);
			return aabb.LowerBound.X;
		}
		public static float GetRight(Shape s)
		{
			AABB aabb;
			Caabb(out aabb, s);
			return aabb.UpperBound.X;
		}

		static void Caabb(out AABB aabb, Shape s)
		{
			XForm x = new XForm(s.GetBody().GetPosition(), new Mat22(s.GetBody().GetAngle()));
			s.ComputeAABB(out aabb, x);
		}
	}
}
