using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public sealed class Model : Handler< Model >
		{

			internal static Model FromHandle( int handle )
			{
				Model handler = FindHandler( handle ) ;

				if( handler != null )
				{
					return handler ;
				}
				else
				{
					handler = new Model( handle ) ;
					AddHandler( handle, handler ) ;
					return handler ;
				}
			}

			private Model( int handle ) : base( handle )
			{
			}

			internal protected override sealed void DestructHandler( int handle )
			{
				lock( DX.locker )
				{
					int result = dx_MV1DeleteModel( handle ) ;
				}
			}

		#if UNICODE
			[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
		#else
			[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
		#endif
			private static extern int dx_MV1DeleteModel( int MHandle ) ;
		}

		/// <summary> f폜 </summary>
		public static void MV1DeleteModel( Model MHandle )
		{
			Disposable.Dispose( MHandle ) ;
		}
	}
}
