using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public sealed class Font : Handler< Font >
		{

			internal static Font FromHandle( int handle )
			{
				Font handler = FindHandler( handle ) ;

				if( handler != null )
				{
					return handler ;
				}
				else
				{
					handler = new Font( handle ) ;
					AddHandler( handle, handler ) ;
					return handler ;
				}
			}

			private Font( int handle ) : base( handle )
			{
			}

			internal protected override sealed void DestructHandler( int handle )
			{
				lock( DX.locker )
				{
					int result = dx_DeleteFontToHandle( handle ) ;
				}
			}

			/// <summary> tHgLbV̐I </summary>
		#if UNICODE
			[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
		#else
			[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
		#endif
			private static extern int dx_DeleteFontToHandle( int FontHandle ) ;
		}

		/// <summary> tHgLbV̐I </summary>
		public static void DeleteFontToHandle( Font FontHandle )
		{
			Disposable.Dispose( FontHandle ) ;
		}
	}
}
