using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public sealed class FileFinder : Handler< FileFinder >
		{

			internal static FileFinder FromHandle( int handle )
			{
				FileFinder handler = FindHandler( handle ) ;

				if( handler != null )
				{
					return handler ;
				}
				else
				{
					handler = new FileFinder( handle ) ;
					AddHandler( handle, handler ) ;
					return handler ;
				}
			}

			private FileFinder( int handle ) : base( handle )
			{
			}

			internal protected override sealed void DestructHandler( int handle )
			{
				lock( DX.locker )
				{
					int result = dx_FileRead_findClose( handle ) ;
				}
			}

			/// <summary> t@Cnh( ߂l: -1=G[  0= ) </summary>
		#if UNICODE
			[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
		#else
			[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
		#endif
			private static extern int dx_FileRead_findClose( int FindHandle ) ;
		}

		/// <summary> t@Cnh( ߂l: -1=G[  0= ) </summary>
		public static void FileRead_findClose( FileFinder FindHandle )
		{
			Disposable.Dispose( FindHandle ) ;
		}
	}
}
