using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		/// <summary> t@C̍Đ </summary>
		public static void PlayMovie( string FileName , int ExRate , DX_PLAYTYPE PlayType )
		{
			lock( locker )
			{
				int result = dx_PlayMovie( FileName , ExRate , PlayType ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayMovie( string FileName , int ExRate , DX_PLAYTYPE PlayType ) ;


		/// <summary> [r[J </summary>
		public static Movie OpenMovieToGraph( string FileName )
		{
			lock( locker )
			{
				return OpenMovieToGraph( FileName , true ) ;
			}
		}

		/// <summary> [r[J </summary>
		public static Movie OpenMovieToGraph( string FileName , bool FullColor )
		{
			lock( locker )
			{
				int result = dx_OpenMovieToGraph( FileName , FullColor ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Movie.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_OpenMovieToGraph( string FileName , bool FullColor ) ;


		/// <summary> [r[OtBbNɊ܂܂郀[r[̍ĐJn </summary>
		public static void PlayMovieToGraph( Movie GraphHandle )
		{
			PlayMovieToGraph( GraphHandle , DX_PLAYTYPE.BACK ) ;
		}

		/// <summary> [r[OtBbNɊ܂܂郀[r[̍ĐJn </summary>
		public static void PlayMovieToGraph( Movie GraphHandle , DX_PLAYTYPE PlayType )
		{
			PlayMovieToGraph( GraphHandle , PlayType , false ) ;
		}

		/// <summary> [r[OtBbNɊ܂܂郀[r[̍ĐJn </summary>
		public static void PlayMovieToGraph( Movie GraphHandle , DX_PLAYTYPE PlayType , bool SysPlay )
		{
			lock( locker )
			{
				int result = dx_PlayMovieToGraph( Movie.ToHandle( GraphHandle ) , PlayType , SysPlay ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PlayMovieToGraph( int GraphHandle , DX_PLAYTYPE PlayType , bool SysPlay ) ;


		/// <summary> [r[OtBbNɊ܂܂郀[r[̍ĐXgbv </summary>
		public static void PauseMovieToGraph( Movie GraphHandle )
		{
			PauseMovieToGraph( GraphHandle , false ) ;
		}

		/// <summary> [r[OtBbNɊ܂܂郀[r[̍ĐXgbv </summary>
		public static void PauseMovieToGraph( Movie GraphHandle , bool SysPause )
		{
			lock( locker )
			{
				int result = dx_PauseMovieToGraph( Movie.ToHandle( GraphHandle ) , SysPause ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_PauseMovieToGraph( int GraphHandle , bool SysPause ) ;


		/// <summary> [r[̃t[i߂A߂Ƃ͏oȂ( [r[~ԂŁA Ogg Theora ̂ݗL ) </summary>
		public static void AddMovieFrameToGraph( Movie GraphHandle , int FrameNum )
		{
			lock( locker )
			{
				int result = dx_AddMovieFrameToGraph( Movie.ToHandle( GraphHandle ) , FrameNum ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AddMovieFrameToGraph( int GraphHandle , int FrameNum ) ;


		/// <summary> [r[̍Đʒuݒ肷(~bP) </summary>
		public static void SeekMovieToGraph( Movie GraphHandle , int Time )
		{
			lock( locker )
			{
				int result = dx_SeekMovieToGraph( Movie.ToHandle( GraphHandle ) , Time ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SeekMovieToGraph( int GraphHandle , int Time ) ;


		/// <summary> [r[̍ĐԂ𓾂 </summary>
		public static bool GetMovieStateToGraph( Movie GraphHandle )
		{
			lock( locker )
			{
				int result = dx_GetMovieStateToGraph( Movie.ToHandle( GraphHandle ) ) ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMovieStateToGraph( int GraphHandle ) ;


		/// <summary> [r[̃{[Zbg(0`10000) </summary>
		public static void SetMovieVolumeToGraph( int Volume , Movie GraphHandle )
		{
			lock( locker )
			{
				int result = dx_SetMovieVolumeToGraph( Volume , Movie.ToHandle( GraphHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMovieVolumeToGraph( int Volume , int GraphHandle ) ;


		/// <summary> [r[̊{C[Wf[^擾 </summary>
		public static BaseImage GetMovieBaseImageToGraph( Movie GraphHandle )
		{
			lock( locker )
			{
				IntPtr result = dx_GetMovieBaseImageToGraph( Movie.ToHandle( GraphHandle ) ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				BASEIMAGE BaseImage_ = ( BASEIMAGE )( Marshal.PtrToStructure( result , typeof( BASEIMAGE ) ) ) ;
				int GraphDataSize_ = BaseImage_.Height * BaseImage_.Pitch ;
				IntPtr GraphData_ = DxAlloc( GraphDataSize_ ) ;
				CopyMemory( GraphData_ , BaseImage_.GraphData , ( IntPtr )( GraphDataSize_ ) ) ;
				BaseImage_.GraphData = GraphData_ ;
				return new BaseImage( BaseImage_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetMovieBaseImageToGraph( int GraphHandle ) ;

	#if UNICODE
		[ DllImport( "user32.dll" , CharSet = CharSet.Unicode ) ]
	#else
		[ DllImport( "user32.dll" , CharSet = CharSet.Ansi ) ]
	#endif
		private static extern void CopyMemory( IntPtr Destination , IntPtr Source , IntPtr Length ) ;


		/// <summary> [r[̑t[𓾂( Ogg Theora ł̂ݗL ) </summary>
		public static int GetMovieTotalFrameToGraph( Movie GraphHandle )
		{
			lock( locker )
			{
				int result = dx_GetMovieTotalFrameToGraph( Movie.ToHandle( GraphHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMovieTotalFrameToGraph( int GraphHandle ) ;


		/// <summary> [r[̍Đʒu擾(~bP) </summary>
		public static int TellMovieToGraph( Movie GraphHandle )
		{
			lock( locker )
			{
				int result = dx_TellMovieToGraph( Movie.ToHandle( GraphHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_TellMovieToGraph( int GraphHandle ) ;


		/// <summary> [r[̍Đʒu擾(t[P) </summary>
		public static int TellMovieToGraphToFrame( Movie GraphHandle )
		{
			lock( locker )
			{
				int result = dx_TellMovieToGraphToFrame( Movie.ToHandle( GraphHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_TellMovieToGraphToFrame( int GraphHandle ) ;


		/// <summary> [r[̍Đʒuݒ肷(t[P) </summary>
		public static int SeekMovieToGraphToFrame( Movie GraphHandle , int Frame )
		{
			lock( locker )
			{
				int result = dx_SeekMovieToGraphToFrame( Movie.ToHandle( GraphHandle ) , Frame ) ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SeekMovieToGraphToFrame( int GraphHandle , int Frame ) ;


		/// <summary> [r[̂Pt[̎Ԃ𓾂 </summary>
		public static long GetOneFrameTimeMovieToGraph( Movie GraphHandle )
		{
			lock( locker )
			{
				long result = dx_GetOneFrameTimeMovieToGraph( Movie.ToHandle( GraphHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern long dx_GetOneFrameTimeMovieToGraph( int GraphHandle ) ;


		/// <summary> [r[̃C[WŌɍXVԂ𓾂(~bP) </summary>
		public static int GetLastUpdateTimeMovieToGraph( Movie GraphHandle )
		{
			lock( locker )
			{
				int result = dx_GetLastUpdateTimeMovieToGraph( Movie.ToHandle( GraphHandle ) ) ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLastUpdateTimeMovieToGraph( int GraphHandle ) ;


		/// <summary> t@C̉EAt@ƂĈǂZbg( TRUE:At@ƂĈ ) </summary>
		public static void SetMovieRightImageAlphaFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetMovieRightImageAlphaFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMovieRightImageAlphaFlag( bool Flag ) ;
	}
}
