using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		/// <summary> }XNXN[쐬 </summary>
		public static void CreateMaskScreen()
		{
			lock( locker )
			{
				int result = dx_CreateMaskScreen() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateMaskScreen() ;


		/// <summary> }XNXN[폜 </summary>
		public static void DeleteMaskScreen()
		{
			lock( locker )
			{
				dx_DeleteMaskScreen() ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DeleteMaskScreen() ;


		/// <summary> }XNT[tFX擾 </summary>
		/// <returns> ߂l IDirectDrawSurface7 * ɃLXgĉ </returns>
		public static IntPtr GetMaskSurface()
		{
			lock( locker )
			{
				IntPtr result = dx_GetMaskSurface() ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetMaskSurface() ;


		/// <summary> }XÑf[^𒼐ڃZbg </summary>
		public static void DrawMaskToDirectData( int x , int y , int Width , int Height , IntPtr MaskData , DX_MASKTRANS TransMode )
		{
			lock( locker )
			{
				int result = dx_DrawMaskToDirectData( x , y , Width , Height , MaskData , TransMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawMaskToDirectData( int x , int y , int Width , int Height , IntPtr MaskData , DX_MASKTRANS TransMode ) ;


		/// <summary> }XÑf[^𒼐ڃ}XNʑŜɕ`悷 </summary>
		public static void DrawFillMaskToDirectData( int x1 , int y1 , int x2 , int y2 , int Width , int Height , IntPtr MaskData )
		{
			lock( locker )
			{
				int result = dx_DrawFillMaskToDirectData( x1 , y1 , x2 , y2 , Width , Height , MaskData ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawFillMaskToDirectData( int x1 , int y1 , int x2 , int y2 , int Width , int Height , IntPtr MaskData ) ;


		/// <summary> }XNgp[hύX </summary>
		public static void SetUseMaskScreenFlag( bool ValidFlag )
		{
			lock( locker )
			{
				int result = dx_SetUseMaskScreenFlag( ValidFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseMaskScreenFlag( bool ValidFlag ) ;


		/// <summary> }XNgp[h̎擾 </summary>
		public static bool GetUseMaskScreenFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseMaskScreenFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseMaskScreenFlag() ;


		/// <summary> }XNXN[w̐FœhԂ </summary>
		public static void FillMaskScreen( bool Flag )
		{
			lock( locker )
			{
				int result = dx_FillMaskScreen( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FillMaskScreen( bool Flag ) ;


		/// <summary> }XNf[^̒ǉ </summary>
		public static Mask MakeMask( int Width , int Height )
		{
			lock( locker )
			{
				int result = dx_MakeMask( Width , Height ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Mask.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeMask( int Width , int Height ) ;


		/// <summary> }XN̑傫𓾂  </summary>
		public static void GetMaskSize( out int WidthBuf , out int HeightBuf , Mask MaskHandle )
		{
			lock( locker )
			{
				int result = dx_GetMaskSize( out WidthBuf , out HeightBuf , Mask.ToHandle( MaskHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMaskSize( out int WidthBuf , out int HeightBuf , int MaskHandle ) ;


		/// <summary> }XÑf[^}XNɓ] </summary>
		public static void SetDataToMask( int Width , int Height , IntPtr MaskData , Mask MaskHandle )
		{
			lock( locker )
			{
				int result = dx_SetDataToMask( Width , Height , MaskData , Mask.ToHandle( MaskHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDataToMask( int Width , int Height , IntPtr MaskData , int MaskHandle ) ;


		/// <summary> }XNf[^ɂalof[^}XNf[^ƌĂē] </summary>
		/// <param name="Bmp"> HBITMAP </param>
		public static void BmpBltToMask( IntPtr Bmp , int BmpPointX , int BmpPointY , Mask MaskHandle )
		{
			lock( locker )
			{
				int result = dx_BmpBltToMask( Bmp , BmpPointX , BmpPointY , Mask.ToHandle( MaskHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BmpBltToMask( IntPtr Bmp , int BmpPointX , int BmpPointY , int MaskHandle ) ;


		/// <summary> }XNf[^[h </summary>
		public static Mask LoadMask( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadMask( FileName ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Mask.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadMask( string FileName ) ;


		/// <summary> }XN摜番ǂ݂ </summary>
		public static void LoadDivMask( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Mask[] HandleBuf )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_LoadDivMask( FileName , AllNum , XNum , YNum , XSize , YSize , HandleBuf_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Mask.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadDivMask( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , [ Out ] int[] HandleBuf ) ;


		/// <summary> }XNZbg </summary>
		public static void DrawMask( int x , int y , Mask MaskHandle , DX_MASKTRANS TransMode )
		{
			lock( locker )
			{
				int result = dx_DrawMask( x , y , Mask.ToHandle( MaskHandle ) , TransMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawMask( int x , int y , int MaskHandle , DX_MASKTRANS TransMode ) ;


		/// <summary> }XNXN[ɕ`悷 </summary>
		public static void DrawStringMask( int x , int y , bool Flag , string String )
		{
			lock( locker )
			{
				int result = dx_DrawStringMask( x , y , Flag , String ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawStringMask( int x , int y , bool Flag , string String ) ;


		/// <summary> }XNXN[ɕ`悷(tHgnhw)( SetFontCacheToTextureFlag( FALSE ) ; ɂč쐬tHgnĥݎgp\ ) </summary>
		public static void DrawStringMaskToHandle( int x , int y , bool Flag , Font FontHandle , string String )
		{
			lock( locker )
			{
				int result = dx_DrawStringMaskToHandle( x , y , Flag , Font.ToHandle( FontHandle ) , String ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawStringMaskToHandle( int x , int y , bool Flag , int FontHandle , string String ) ;


		/// <summary> w̃}XNʂςɓWJ	 </summary>
		public static void DrawFillMask( int x1 , int y1 , int x2 , int y2 , Mask MaskHandle )
		{
			lock( locker )
			{
				int result = dx_DrawFillMask( x1 , y1 , x2 , y2 , Mask.ToHandle( MaskHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawFillMask( int x1 , int y1 , int x2 , int y2 , int MaskHandle ) ;


		/// <summary> }XNɎgߐF̃Zbg </summary>
		public static void SetMaskTransColor( COLOR_U8 ColorCode )
		{
			lock( locker )
			{
				int result = dx_SetMaskTransColor( ColorCode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMaskTransColor( COLOR_U8 ColorCode ) ;


		/// <summary> }XN̐lɑ΂ʂt] </summary>
		public static void SetMaskReverseEffectFlag( bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_SetMaskReverseEffectFlag( ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMaskReverseEffectFlag( bool ReverseFlag ) ;


		/// <summary> }XNʏ̕`Ԃ擾 </summary>
		public static void GetMaskScreenData( int x1 , int y1 , int x2 , int y2 , Mask MaskHandle )
		{
			lock( locker )
			{
				int result = dx_GetMaskScreenData( x1 , y1 , x2 , y2 , Mask.ToHandle( MaskHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMaskScreenData( int x1 , int y1 , int x2 , int y2 , int MaskHandle ) ;


		/// <summary> }XNXN[gptO̎擾 </summary>
		public static bool GetMaskUseFlag()
		{
			lock( locker )
			{
				int result = dx_GetMaskUseFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetMaskUseFlag() ;
	}
}
