using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		/// <summary> 摜ǂ݂  </summary>
		public static Graph LoadBmpToGraph( string GraphName , bool TextureFlag , bool ReverseFlag )
		{
			return LoadBmpToGraph( GraphName , TextureFlag , ReverseFlag , DX_MOVIESURFACE.NORMAL ) ;
		}

		/// <summary> 摜ǂ݂  </summary>
		public static Graph LoadBmpToGraph( string GraphName , bool TextureFlag , bool ReverseFlag , DX_MOVIESURFACE SurfaceMode )
		{
			lock( locker )
			{
				int result = dx_LoadBmpToGraph( GraphName , TextureFlag , ReverseFlag , SurfaceMode ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadBmpToGraph( string GraphName , bool TextureFlag , bool ReverseFlag , DX_MOVIESURFACE SurfaceMode ) ;


		/// <summary> 摜t@C̃ւ̓ǂ݂ </summary>
		public static Graph LoadGraph( string FileName )
		{
			return LoadGraph( FileName , false ) ;
		}

		/// <summary> 摜t@C̃ւ̓ǂ݂ </summary>
		public static Graph LoadGraph( string FileName , bool NotUse3DFlag )
		{
			lock( locker )
			{
				int result = dx_LoadGraph( FileName , NotUse3DFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadGraph( string FileName , bool NotUse3DFlag ) ;


		/// <summary> 摜t@C̃ւ̔]ǂݍ </summary>
		public static Graph LoadReverseGraph( string FileName )
		{
			return LoadReverseGraph( FileName , false ) ;
		}

		/// <summary> 摜t@C̃ւ̔]ǂݍ </summary>
		public static Graph LoadReverseGraph( string FileName , bool NotUse3DFlag )
		{
			lock( locker )
			{
				int result = dx_LoadReverseGraph( FileName , NotUse3DFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadReverseGraph( string FileName , bool NotUse3DFlag ) ;


		/// <summary> 摜̕ǂ݂ </summary>
		public static void LoadDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf )
		{
			LoadDivGraph( FileName , AllNum , XNum , YNum , XSize , YSize , out HandleBuf , false ) ;
		}

		/// <summary> 摜̕ǂ݂ </summary>
		public static void LoadDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf , bool NotUse3DFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_LoadDivGraph( FileName , AllNum , XNum , YNum , XSize , YSize , HandleBuf_ , NotUse3DFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , [ Out ] int[] HandleBuf , bool NotUse3DFlag ) ;


		/// <summary> 摜t@C̕ǂ݂ </summary>
		public static void LoadDivBmpToGraph( string FileName , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_LoadDivBmpToGraph( FileName , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadDivBmpToGraph( string FileName , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag ) ;


		/// <summary> 摜̔]ǂ݂ </summary>
		public static void LoadReverseDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf )
		{
			LoadReverseDivGraph( FileName , AllNum , XNum , YNum , XSize , YSize , out HandleBuf , false ) ;
		}

		/// <summary> 摜̔]ǂ݂ </summary>
		public static void LoadReverseDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf , bool NotUse3DFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_LoadReverseDivGraph( FileName , AllNum , XNum , YNum , XSize , YSize , HandleBuf_ , NotUse3DFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadReverseDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , [ Out ] int[] HandleBuf , bool NotUse3DFlag ) ;


		/// <summary> 摜t@Cuhp摜ǂݍ </summary>
		public static BlendGraph LoadBlendGraph( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadBlendGraph( FileName ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return BlendGraph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadBlendGraph( string FileName ) ;


		/// <summary> \[X摜f[^ǂݍ </summary>
		public static Graph LoadGraphToResource( int ResourceID )
		{
			lock( locker )
			{
				int result = dx_LoadGraphToResource( ResourceID ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadGraphToResource( int ResourceID ) ;


		/// <summary> \[X摜f[^𕪊ǂݍ݂ </summary>
		public static void LoadDivGraphToResource( int ResourceID , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_LoadDivGraphToResource( ResourceID , AllNum , XNum , YNum , XSize , YSize , HandleBuf_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadDivGraphToResource( int ResourceID , int AllNum , int XNum , int YNum , int XSize , int YSize , [ Out ] int[] HandleBuf ) ;


		/// <summary> \[X摜f[^ǂݍ </summary>
		public static Graph LoadGraphToResource( string ResourceName , string ResourceType )
		{
			lock( locker )
			{
				int result = dx_LoadGraphToResource_2( ResourceName , ResourceType ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadGraphToResource_2( string ResourceName , string ResourceType ) ;


		/// <summary> \[X摜f[^𕪊ǂݍ݂ </summary>
		public static void LoadDivGraphToResource( string ResourceName , string ResourceType , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_LoadDivGraphToResource_2( ResourceName , ResourceType , AllNum , XNum , YNum , XSize , YSize , HandleBuf_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadDivGraphToResource_2( string ResourceName , string ResourceType , int AllNum , int XNum , int YNum , int XSize , int YSize , [ Out ] int[] HandleBuf ) ;


		/// <summary> ̃OtBbNC[WOtBbNnh쐬 </summary>
		public static Graph CreateGraphFromMem( IntPtr MemImage , int MemImageSize )
		{
			return CreateGraphFromMem( MemImage , MemImageSize , IntPtr.Zero , 0 ) ;
		}

		/// <summary> ̃OtBbNC[WOtBbNnh쐬 </summary>
		public static Graph CreateGraphFromMem( IntPtr MemImage , int MemImageSize , IntPtr AlphaImage , int AlphaImageSize )
		{
			return CreateGraphFromMem( MemImage , MemImageSize , AlphaImage , AlphaImageSize , true ) ;
		}

		/// <summary> ̃OtBbNC[WOtBbNnh쐬 </summary>
		public static Graph CreateGraphFromMem( IntPtr MemImage , int MemImageSize , IntPtr AlphaImage , int AlphaImageSize , bool TextureFlag )
		{
			return CreateGraphFromMem( MemImage , MemImageSize , AlphaImage , AlphaImageSize , TextureFlag , false ) ;
		}

		/// <summary> ̃OtBbNC[WOtBbNnh쐬 </summary>
		public static Graph CreateGraphFromMem( IntPtr MemImage , int MemImageSize , IntPtr AlphaImage , int AlphaImageSize , bool TextureFlag , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromMem( MemImage , MemImageSize , AlphaImage , AlphaImageSize , TextureFlag , ReverseFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromMem( IntPtr MemImage , int MemImageSize , IntPtr AlphaImage , int AlphaImageSize , bool TextureFlag , bool ReverseFlag ) ;


		/// <summary> ̃OtBbNC[W̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromMem( IntPtr MemImage , int MemImageSize , Graph GrHandle )
		{
			ReCreateGraphFromMem( MemImage , MemImageSize , GrHandle , IntPtr.Zero , 0 ) ;
		}

		/// <summary> ̃OtBbNC[W̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromMem( IntPtr MemImage , int MemImageSize , Graph GrHandle , IntPtr AlphaImage , int AlphaImageSize )
		{
			ReCreateGraphFromMem( MemImage , MemImageSize , GrHandle , AlphaImage , AlphaImageSize , true ) ;
		}

		/// <summary> ̃OtBbNC[W̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromMem( IntPtr MemImage , int MemImageSize , Graph GrHandle , IntPtr AlphaImage , int AlphaImageSize , bool TextureFlag )
		{
			ReCreateGraphFromMem( MemImage , MemImageSize , GrHandle , AlphaImage , AlphaImageSize , TextureFlag , false ) ;
		}

		/// <summary> ̃OtBbNC[W̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromMem( IntPtr MemImage , int MemImageSize , Graph GrHandle , IntPtr AlphaImage , int AlphaImageSize , bool TextureFlag , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromMem( MemImage , MemImageSize , Graph.ToHandle( GrHandle ) , AlphaImage , AlphaImageSize , TextureFlag , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromMem( IntPtr MemImage , int MemImageSize , int GrHandle , IntPtr AlphaImage , int AlphaImageSize , bool TextureFlag , bool ReverseFlag ) ;


		/// <summary> ̃OtBbNC[W番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			CreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> ̃OtBbNC[W番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			CreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> ̃OtBbNC[W番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			CreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , IntPtr.Zero , 0 ) ;
		}

		/// <summary> ̃OtBbNC[W番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaImage , int AlphaImageSize )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_CreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , AlphaImage , AlphaImageSize ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaImage , int AlphaImageSize ) ;


		/// <summary> ̃OtBbNC[W̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			ReCreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> ̃OtBbNC[W̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			ReCreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> ̃OtBbNC[W̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			ReCreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , IntPtr.Zero , 0 ) ;
		}

		/// <summary> ̃OtBbNC[W̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaImage , int AlphaImageSize )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_ReCreateDivGraphFromMem( MemImage , MemImageSize , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , AlphaImage , AlphaImageSize ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateDivGraphFromMem( IntPtr MemImage , int MemImageSize , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaImage , int AlphaImageSize ) ;


		/// <summary> rbg}bvf[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData )
		{
			return CreateGraphFromBmp( BmpInfo , GraphData , IntPtr.Zero , IntPtr.Zero ) ;
		}

		/// <summary> rbg}bvf[^OtBbNnh쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static Graph CreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , IntPtr AlphaInfo , IntPtr AlphaData )
		{
			return CreateGraphFromBmp( BmpInfo , GraphData , AlphaInfo , AlphaData , true ) ;
		}

		/// <summary> rbg}bvf[^OtBbNnh쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static Graph CreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , IntPtr AlphaInfo , IntPtr AlphaData , bool TextureFlag )
		{
			return CreateGraphFromBmp( BmpInfo , GraphData , AlphaInfo , AlphaData , TextureFlag , false ) ;
		}

		/// <summary> rbg}bvf[^OtBbNnh쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static Graph CreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , IntPtr AlphaInfo , IntPtr AlphaData , bool TextureFlag , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromBmp( BmpInfo , GraphData , AlphaInfo , AlphaData , TextureFlag , ReverseFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , IntPtr AlphaInfo , IntPtr AlphaData , bool TextureFlag , bool ReverseFlag ) ;


		/// <summary> rbg}bvf[^̃OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void ReCreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , Graph GrHandle )
		{
			ReCreateGraphFromBmp( BmpInfo , GraphData , GrHandle , IntPtr.Zero , IntPtr.Zero ) ;
		}

		/// <summary> rbg}bvf[^̃OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static void ReCreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , Graph GrHandle , IntPtr AlphaInfo , IntPtr AlphaData )
		{
			ReCreateGraphFromBmp( BmpInfo , GraphData , GrHandle , AlphaInfo , AlphaData , true ) ;
		}

		/// <summary> rbg}bvf[^̃OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static void ReCreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , Graph GrHandle , IntPtr AlphaInfo , IntPtr AlphaData , bool TextureFlag )
		{
			ReCreateGraphFromBmp( BmpInfo , GraphData , GrHandle , AlphaInfo , AlphaData , TextureFlag , false ) ;
		}

		/// <summary> rbg}bvf[^̃OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static void ReCreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , Graph GrHandle , IntPtr AlphaInfo , IntPtr AlphaData , bool TextureFlag , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromBmp( BmpInfo , GraphData , Graph.ToHandle( GrHandle ) , AlphaInfo , AlphaData , TextureFlag , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int GrHandle , IntPtr AlphaInfo , IntPtr AlphaData , bool TextureFlag , bool ReverseFlag ) ;


		/// <summary> rbg}bvf[^番OtBbNnh쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void CreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			CreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> rbg}bvf[^番OtBbNnh쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void CreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			CreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> rbg}bvf[^番OtBbNnh쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void CreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			CreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , IntPtr.Zero , IntPtr.Zero ) ;
		}

		/// <summary> rbg}bvf[^番OtBbNnh쐬 </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static void CreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaInfo , IntPtr AlphaData )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_CreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , AlphaInfo , AlphaData ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaInfo , IntPtr AlphaData ) ;


		/// <summary> rbg}bvf[^̕OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void ReCreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			ReCreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> rbg}bvf[^̕OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void ReCreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			ReCreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> rbg}bvf[^̕OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		public static void ReCreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			ReCreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , IntPtr.Zero , IntPtr.Zero ) ;
		}

		/// <summary> rbg}bvf[^̕OtBbNnhɃf[^] </summary>
		/// <param name="BmpInfo"> BITMAPINFO * </param>
		/// <param name="AlphaInfo"> BITMAPINFO * </param>
		public static void ReCreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaInfo , IntPtr AlphaData )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_ReCreateDivGraphFromBmp( BmpInfo , GraphData , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , AlphaInfo , AlphaData ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateDivGraphFromBmp( IntPtr BmpInfo , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , IntPtr AlphaInfo , IntPtr AlphaData ) ;


		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image )
		{
			return CreateGraphFromGraphImage( Image , true ) ;
		}

		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image , bool TextureFlag )
		{
			return CreateGraphFromGraphImage( Image , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image , bool TextureFlag , bool ReverseFlag )
		{
			return CreateGraphFromGraphImage( Image , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromGraphImage( ref Image.buffer , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromGraphImage( [ In ] ref BASEIMAGE Image , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage )
		{
			return CreateGraphFromGraphImage( Image , AlphaImage , true ) ;
		}

		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , bool TextureFlag )
		{
			return CreateGraphFromGraphImage( Image , AlphaImage , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , bool TextureFlag , bool ReverseFlag )
		{
			return CreateGraphFromGraphImage( Image , AlphaImage , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromGraphImage_2( ref Image.buffer , ref AlphaImage.buffer , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromGraphImage_2( [ In ] ref BASEIMAGE Image , [ In ] ref BASEIMAGE AlphaImage , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , Graph GrHandle )
		{
			ReCreateGraphFromGraphImage( Image , GrHandle , true ) ;
		}

		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , Graph GrHandle , bool TextureFlag )
		{
			ReCreateGraphFromGraphImage( Image , GrHandle , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , Graph GrHandle , bool TextureFlag , bool ReverseFlag )
		{
			ReCreateGraphFromGraphImage( Image , GrHandle , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , Graph GrHandle , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromGraphImage( ref Image.buffer , Graph.ToHandle( GrHandle ) , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromGraphImage( [ In ] ref BASEIMAGE Image , int GrHandle , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , Graph GrHandle )
		{
			ReCreateGraphFromGraphImage( Image , AlphaImage , GrHandle , true ) ;
		}

		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , Graph GrHandle , bool TextureFlag )
		{
			ReCreateGraphFromGraphImage( Image , AlphaImage , GrHandle , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , Graph GrHandle , bool TextureFlag , bool ReverseFlag )
		{
			ReCreateGraphFromGraphImage( Image , AlphaImage , GrHandle , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^̃OtBbNnhɃf[^] </summary>
		public static void ReCreateGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , Graph GrHandle , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromGraphImage_2( ref Image.buffer , ref AlphaImage.buffer , Graph.ToHandle( GrHandle ) , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromGraphImage_2( [ In ] ref BASEIMAGE Image , [ In ] ref BASEIMAGE AlphaImage , int GrHandle , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			CreateDivGraphFromGraphImage( Image , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			CreateDivGraphFromGraphImage( Image , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			CreateDivGraphFromGraphImage( Image , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_CreateDivGraphFromGraphImage( ref Image.buffer , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDivGraphFromGraphImage( [ In ] ref BASEIMAGE Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			CreateDivGraphFromGraphImage( Image , AlphaImage , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			CreateDivGraphFromGraphImage( Image , AlphaImage , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			CreateDivGraphFromGraphImage( Image , AlphaImage , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_CreateDivGraphFromGraphImage_2( ref Image.buffer , ref AlphaImage.buffer , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDivGraphFromGraphImage_2( [ In ] ref BASEIMAGE Image , [ In ] ref BASEIMAGE AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			ReCreateDivGraphFromGraphImage( Image , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			ReCreateDivGraphFromGraphImage( Image , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			ReCreateDivGraphFromGraphImage( Image , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_ReCreateDivGraphFromGraphImage( ref Image.buffer , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateDivGraphFromGraphImage( [ In ] ref BASEIMAGE Image , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			ReCreateDivGraphFromGraphImage( Image , AlphaImage , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , true ) ;
		}

		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag )
		{
			ReCreateDivGraphFromGraphImage( Image , AlphaImage , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , false ) ;
		}

		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag )
		{
			ReCreateDivGraphFromGraphImage( Image , AlphaImage , AllNum , XNum , YNum , SizeX , SizeY , out HandleBuf , TextureFlag , ReverseFlag , true ) ;
		}

		/// <summary> GraphImagef[^̕OtBbNnhɃf[^] </summary>
		public static void ReCreateDivGraphFromGraphImage( BaseImage Image , BaseImage AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_ReCreateDivGraphFromGraphImage_2( ref Image.buffer , ref AlphaImage.buffer , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , TextureFlag , ReverseFlag , DataReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateDivGraphFromGraphImage_2( [ In ] ref BASEIMAGE Image , [ In ] ref BASEIMAGE AlphaImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , bool TextureFlag , bool ReverseFlag , bool DataReverseFlag ) ;


		/// <summary> ̃OtBbNf[^OtBbNnh쐬 </summary>
		public static Graph CreateGraph( int Width , int Height , int Pitch , IntPtr GraphData )
		{
			return CreateGraph( Width , Height , Pitch , GraphData , IntPtr.Zero ) ;
		}

		/// <summary> ̃OtBbNf[^OtBbNnh쐬 </summary>
		public static Graph CreateGraph( int Width , int Height , int Pitch , IntPtr GraphData , IntPtr AlphaData )
		{
			lock( locker )
			{
				int result = dx_CreateGraph( Width , Height , Pitch , GraphData , AlphaData , -1 ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

		/// <summary> ̃OtBbNf[^OtBbNnh쐬 </summary>
		public static void CreateGraph( int Width , int Height , int Pitch , IntPtr GraphData , IntPtr AlphaData , Graph GrHandle )
		{
			lock( locker )
			{
				if( GrHandle == null ) { throw new ArgumentException() ; }
				int result = dx_CreateGraph( Width , Height , Pitch , GraphData , AlphaData , Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraph( int Width , int Height , int Pitch , IntPtr GraphData , IntPtr AlphaData , int GrHandle ) ;


		/// <summary> ̃OtBbNf[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraph( int Width , int Height , int Pitch , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			int[] HandleBuf_ = new int[ AllNum ] ;
			int result = dx_CreateDivGraph( Width , Height , Pitch , GraphData , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , IntPtr.Zero ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
		}

		/// <summary> ̃OtBbNf[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraph( int Width , int Height , int Pitch , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf , IntPtr AlphaData )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_CreateDivGraph( Width , Height , Pitch , GraphData , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ , AlphaData ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDivGraph( int Width , int Height , int Pitch , IntPtr GraphData , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf , IntPtr AlphaData ) ;


		/// <summary> ̃OtBbNf[^OtBbNnhč쐬 </summary>
		public static void ReCreateGraph( int Width , int Height , int Pitch , IntPtr GraphData , Graph GrHandle )
		{
			ReCreateGraph( Width , Height , Pitch , GraphData , GrHandle , IntPtr.Zero ) ;
		}

		/// <summary> ̃OtBbNf[^OtBbNnhč쐬 </summary>
		public static void ReCreateGraph( int Width , int Height , int Pitch , IntPtr GraphData , Graph GrHandle , IntPtr AlphaData )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraph( Width , Height , Pitch , GraphData , Graph.ToHandle( GrHandle ) , AlphaData ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraph( int Width , int Height , int Pitch , IntPtr GraphData , int GrHandle , IntPtr AlphaData ) ;


		/// <summary> \tgEGAňC[WOtBbNnh쐬( -1:G[  -1ȊO:OtBbNnh ) </summary>
		public static Graph CreateGraphFromSoftImage( SoftImage SIHandle )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromSoftImage( SoftImage.ToHandle( SIHandle ) ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromSoftImage( int SIHandle ) ;


		/// <summary> \tgEGAňC[W̎ẅ̗găOtBbNnh쐬( -1:G[  -1ȊO:OtBbNnh ) </summary>
		public static Graph CreateGraphFromRectSoftImage( SoftImage SIHandle , int x , int y , int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromRectSoftImage( SoftImage.ToHandle( SIHandle ) , x , y , SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromRectSoftImage( int SIHandle , int x , int y , int SizeX , int SizeY ) ;


		/// <summary> \tgEGAňC[W̃OtBbNnhɉ摜f[^] </summary>
		public static void ReCreateGraphFromSoftImage( SoftImage SIHandle , Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromSoftImage( SoftImage.ToHandle( SIHandle ) , Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromSoftImage( int SIHandle , int GrHandle ) ;


		/// <summary> \tgEGAňC[W̃OtBbNnhɉ摜f[^] </summary>
		public static void ReCreateGraphFromRectSoftImage( SoftImage SIHandle , int x , int y , int SizeX , int SizeY , Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromRectSoftImage( SoftImage.ToHandle( SIHandle ) , x , y , SizeX , SizeY , Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromRectSoftImage( int SIHandle , int x , int y , int SizeX , int SizeY , int GrHandle ) ;


		/// <summary> \tgEGAňC[W番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromSoftImage( SoftImage SIHandle , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_CreateDivGraphFromSoftImage( SoftImage.ToHandle( SIHandle ) , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDivGraphFromSoftImage( int SIHandle , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf ) ;


		/// <summary> {C[Wf[^OtBbNnh쐬 </summary>
		public static Graph CreateGraphFromBaseImage( BaseImage BaseImage )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromBaseImage( ref BaseImage.buffer ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromBaseImage( [ In ] ref BASEIMAGE BaseImage ) ;


		/// <summary> {C[W̎ẅ̗găOtBbNnh쐬 </summary>
		public static Graph CreateGraphFromRectBaseImage( BaseImage BaseImage , int x , int y , int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_CreateGraphFromRectBaseImage( ref BaseImage.buffer , x , y , SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateGraphFromRectBaseImage( [ In ] ref BASEIMAGE BaseImage , int x , int y , int SizeX , int SizeY ) ;


		/// <summary> {C[Wf[^̃OtBbNnhɉ摜f[^] </summary>
		public static void ReCreateGraphFromBaseImage( BaseImage BaseImage , Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromBaseImage( ref BaseImage.buffer , Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromBaseImage( [ In ] ref BASEIMAGE BaseImage , int GrHandle ) ;


		/// <summary> {C[W̎ẅ̗gĊ̃OtBbNnhɉ摜f[^] </summary>
		public static void ReCreateGraphFromRectBaseImage( BaseImage BaseImage , int x , int y , int SizeX , int SizeY , Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_ReCreateGraphFromRectBaseImage( ref BaseImage.buffer , x , y , SizeX , SizeY , Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReCreateGraphFromRectBaseImage( [ In ] ref BASEIMAGE BaseImage , int x , int y , int SizeX , int SizeY , int GrHandle ) ;


		/// <summary> {C[Wf[^番OtBbNnh쐬 </summary>
		public static void CreateDivGraphFromBaseImage( BaseImage BaseImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , out Graph[] HandleBuf )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_CreateDivGraphFromBaseImage( ref BaseImage.buffer , AllNum , XNum , YNum , SizeX , SizeY , HandleBuf_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDivGraphFromBaseImage( [ In ] ref BASEIMAGE BaseImage , int AllNum , int XNum , int YNum , int SizeX , int SizeY , [ Out ] int[] HandleBuf ) ;


		/// <summary> 摜ւ̉摜f[^̓ǂݍ </summary>
		public static void ReloadGraph( string FileName , Graph GrHandle )
		{
			ReloadGraph( FileName , GrHandle , false ) ;
		}

		/// <summary> 摜ւ̉摜f[^̓ǂݍ </summary>
		public static void ReloadGraph( string FileName , Graph GrHandle , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_ReloadGraph( FileName , Graph.ToHandle( GrHandle ) , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReloadGraph( string FileName , int GrHandle , bool ReverseFlag ) ;


		/// <summary> 摜ւ̉摜f[^̕ǂݍ </summary>
		public static void ReloadDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf )
		{
			ReloadDivGraph( FileName , AllNum , XNum , YNum , XSize , YSize , out HandleBuf , false ) ;
		}

		/// <summary> 摜ւ̉摜f[^̕ǂݍ </summary>
		public static void ReloadDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf , bool ReverseFlag )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_ReloadDivGraph( FileName , AllNum , XNum , YNum , XSize , YSize , HandleBuf_ , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReloadDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , [ Out ] int[] HandleBuf , bool ReverseFlag ) ;


		/// <summary> 摜ւ̉摜f[^̓ǂݍ </summary>
		public static void ReloadReverseGraph( string FileName , Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_ReloadReverseGraph( FileName , Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReloadReverseGraph( string FileName , int GrHandle ) ;


		/// <summary> 摜ւ̉摜f[^̕ǂݍ </summary>
		public static void ReloadReverseDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , out Graph[] HandleBuf )
		{
			lock( locker )
			{
				int[] HandleBuf_ = new int[ AllNum ] ;
				int result = dx_ReloadReverseDivGraph( FileName , AllNum , XNum , YNum , XSize , YSize , HandleBuf_ ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
				HandleBuf = Graph.FromHandleArray( HandleBuf_ ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReloadReverseDivGraph( string FileName , int AllNum , int XNum , int YNum , int XSize , int YSize , [ Out ] int[] HandleBuf ) ;


		/// <summary> {C[Wf[^`悷 </summary>
		public static void DrawBaseImage( int x , int y , BaseImage BaseImage )
		{
			lock( locker )
			{
				int result = dx_DrawBaseImage( x , y , ref BaseImage.buffer ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawBaseImage( int x , int y , [ In ] ref BASEIMAGE BaseImage ) ;


		/// <summary> J NearNbvʂ FarNbvʂ̋ݒ肷 </summary>
		public static void SetCameraNearFar( float Near , float Far )
		{
			lock( locker )
			{
				int result = dx_SetCameraNearFar( Near , Far ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCameraNearFar( float Near , float Far ) ;


		/// <summary> J̐ݒA_A_AAbvxNg͂x </summary>
		public static void SetCameraPositionAndTarget_UpVecY( VECTOR Position , VECTOR Target )
		{
			lock( locker )
			{
				int result = dx_SetCameraPositionAndTarget_UpVecY( Position , Target ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCameraPositionAndTarget_UpVecY( VECTOR Position , VECTOR Target ) ;


		/// <summary> J̐ݒA_A_AAbvxNgw </summary>
		public static void SetCameraPositionAndTargetAndUpVec( VECTOR Position , VECTOR Target , VECTOR Up )
		{
			lock( locker )
			{
				int result = dx_SetCameraPositionAndTargetAndUpVec( Position , Target , Up ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCameraPositionAndTargetAndUpVec( VECTOR Position , VECTOR Target , VECTOR Up ) ;


		/// <summary> J̐ݒA]pxA]pxAP]pxA_w </summary>
		public static void SetCameraPositionAndAngle( VECTOR Position , float VRotate , float HRotate , float TRotate )
		{
			lock( locker )
			{
				int result = dx_SetCameraPositionAndAngle( Position , VRotate , HRotate , TRotate ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCameraPositionAndAngle( VECTOR Position , float VRotate , float HRotate , float TRotate ) ;


		/// <summary> r[s𒼐ڐݒ肷 </summary>
		public static void SetCameraViewMatrix( MATRIX ViewMatrix )
		{
			lock( locker )
			{
				int result = dx_SetCameraViewMatrix( ViewMatrix ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCameraViewMatrix( MATRIX ViewMatrix ) ;


		/// <summary> ʏɂJĂf̒S̍Wݒ肷 </summary>
		public static void SetCameraScreenCenter( float x , float y )
		{
			lock( locker )
			{
				int result = dx_SetCameraScreenCenter( x , y ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCameraScreenCenter( float x , float y ) ;


		/// <summary> ߖ@JZbgAbv </summary>
		public static void SetupCamera_Perspective( float Fov )
		{
			lock( locker )
			{
				int result = dx_SetupCamera_Perspective( Fov ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetupCamera_Perspective( float Fov ) ;


		/// <summary> ˉeJZbgAbv </summary>
		public static void SetupCamera_Ortho( float Size )
		{
			lock( locker )
			{
				int result = dx_SetupCamera_Ortho( Size ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetupCamera_Ortho( float Size ) ;


		/// <summary> ˉesݒ肷 </summary>
		public static void SetupCamera_ProjectionMatrix( MATRIX ProjectionMatrix )
		{
			lock( locker )
			{
				int result = dx_SetupCamera_ProjectionMatrix( ProjectionMatrix ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetupCamera_ProjectionMatrix( MATRIX ProjectionMatrix ) ;


		/// <summary> J̃hbgAXyNgݒ肷 </summary>
		public static void SetCameraDotAspect( float DotAspect )
		{
			lock( locker )
			{
				int result = dx_SetCameraDotAspect( DotAspect ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCameraDotAspect( float DotAspect ) ;


		/// <summary> J Near Nbvʂ̋擾 </summary>
		public static float GetCameraNear()
		{
			lock( locker )
			{
				float result = dx_GetCameraNear() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraNear() ;


		/// <summary> J Far Nbvʂ̋擾 </summary>
		public static float GetCameraFar()
		{
			lock( locker )
			{
				float result = dx_GetCameraFar() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraFar() ;


		/// <summary> J̈ʒu擾 </summary>
		public static VECTOR GetCameraPosition()
		{
			lock( locker )
			{
				VECTOR result = dx_GetCameraPosition() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_GetCameraPosition() ;


		/// <summary> J̒_擾 </summary>
		public static VECTOR GetCameraTarget()
		{
			lock( locker )
			{
				VECTOR result = dx_GetCameraTarget() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_GetCameraTarget() ;


		/// <summary> J̎ɐȏ̃xNg𓾂 </summary>
		public static VECTOR GetCameraUpVector()
		{
			lock( locker )
			{
				VECTOR result = dx_GetCameraUpVector() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_GetCameraUpVector() ;


		/// <summary> J̐̌擾 </summary>
		public static float GetCameraAngleHRotate()
		{
			lock( locker )
			{
				float result = dx_GetCameraAngleHRotate() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraAngleHRotate() ;


		/// <summary> J̐̌擾 </summary>
		public static float GetCameraAngleVRotate()
		{
			lock( locker )
			{
				float result = dx_GetCameraAngleVRotate() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraAngleVRotate() ;


		/// <summary> J̌̔Ppx擾 </summary>
		public static float GetCameraAngleTRotate()
		{
			lock( locker )
			{
				float result = dx_GetCameraAngleTRotate() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraAngleTRotate() ;


		/// <summary> r[s擾 </summary>
		public static MATRIX GetCameraViewMatrix()
		{
			lock( locker )
			{
				MATRIX result = dx_GetCameraViewMatrix() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_GetCameraViewMatrix() ;


		/// <summary> J̎p擾 </summary>
		public static float GetCameraFov()
		{
			lock( locker )
			{
				float result = dx_GetCameraFov() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraFov() ;


		/// <summary> J̎TCY擾 </summary>
		public static float GetCameraSize()
		{
			lock( locker )
			{
				float result = dx_GetCameraSize() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraSize() ;


		/// <summary> ˉes擾 </summary>
		public static MATRIX GetCameraProjectionMatrix()
		{
			lock( locker )
			{
				MATRIX result = dx_GetCameraProjectionMatrix() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern MATRIX dx_GetCameraProjectionMatrix() ;


		/// <summary> J̃hbgAXyNg𓾂 </summary>
		public static float GetCameraDotAspect()
		{
			lock( locker )
			{
				float result = dx_GetCameraDotAspect() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern float dx_GetCameraDotAspect() ;


		/// <summary> CeBOvZ@\gp邩ǂݒ肷 </summary>
		public static void SetUseLighting( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseLighting( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseLighting( bool Flag ) ;


		/// <summary> Rc}``̃CeBOvZɒ_J[̃fBt[YJ[gp邩ǂݒ肷 </summary>
		public static void SetMaterialUseVertDifColor( bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_SetMaterialUseVertDifColor( UseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMaterialUseVertDifColor( bool UseFlag ) ;


		/// <summary> Rc}``̃CeBOvZɒ_J[̃XyLJ[gp邩ǂݒ肷 </summary>
		public static void SetMaterialUseVertSpcColor( bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_SetMaterialUseVertSpcColor( UseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMaterialUseVertSpcColor( bool UseFlag ) ;


		/// <summary> Rc}``̃CeBOvZɎgp}eAp[^ݒ肷 </summary>
		public static void SetMaterialParam( MATERIALPARAM Material )
		{
			lock( locker )
			{
				int result = dx_SetMaterialParam( Material ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMaterialParam( MATERIALPARAM Material ) ;


		/// <summary> Rc}``ɃXyLgp邩ǂݒ肷 </summary>
		public static void SetUseSpecular( bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_SetUseSpecular( UseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseSpecular( bool UseFlag ) ;


		/// <summary> O[oArGgCgJ[ݒ肷 </summary>
		public static void SetGlobalAmbientLight( COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_SetGlobalAmbientLight( Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetGlobalAmbientLight( COLOR_F Color ) ;


		/// <summary> Cg̃^CvfBNViCgɂ </summary>
		public static void ChangeLightTypeDir( VECTOR Direction )
		{
			lock( locker )
			{
				int result = dx_ChangeLightTypeDir( Direction ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeLightTypeDir( VECTOR Direction ) ;


		/// <summary> Cg̃^CvX|bgCgɂ </summary>
		public static void ChangeLightTypeSpot( VECTOR Position , VECTOR Direction , float OutAngle , float InAngle , float Range , float Atten0 , float Atten1 , float Atten2 )
		{
			lock( locker )
			{
				int result = dx_ChangeLightTypeSpot( Position , Direction , OutAngle , InAngle , Range , Atten0 , Atten1 , Atten2 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeLightTypeSpot( VECTOR Position , VECTOR Direction , float OutAngle , float InAngle , float Range , float Atten0 , float Atten1 , float Atten2 ) ;


		/// <summary> Cg̃^Cv|CgCgɂ </summary>
		public static void ChangeLightTypePoint( VECTOR Position , float Range , float Atten0 , float Atten1 , float Atten2 )
		{
			lock( locker )
			{
				int result = dx_ChangeLightTypePoint( Position , Range , Atten0 , Atten1 , Atten2 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ChangeLightTypePoint( VECTOR Position , float Range , float Atten0 , float Atten1 , float Atten2 ) ;


		/// <summary> Cg̗LAZbg </summary>
		public static void SetLightEnable( bool EnableFlag )
		{
			lock( locker )
			{
				int result = dx_SetLightEnable( EnableFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightEnable( bool EnableFlag ) ;


		/// <summary> Cg̃fBt[YJ[ݒ肷 </summary>
		public static void SetLightDifColor( COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_SetLightDifColor( Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightDifColor( COLOR_F Color ) ;


		/// <summary> Cg̃XyLJ[ݒ肷 </summary>
		public static void SetLightSpcColor( COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_SetLightSpcColor( Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightSpcColor( COLOR_F Color ) ;


		/// <summary> Cg̃ArGgJ[ݒ肷 </summary>
		public static void SetLightAmbColor( COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_SetLightAmbColor( Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightAmbColor( COLOR_F Color ) ;


		/// <summary> Cg̕ݒ肷 </summary>
		public static void SetLightDirection( VECTOR Direction )
		{
			lock( locker )
			{
				int result = dx_SetLightDirection( Direction ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightDirection( VECTOR Direction ) ;


		/// <summary> Cg̈ʒuݒ肷 </summary>
		public static void SetLightPosition( VECTOR Position )
		{
			lock( locker )
			{
				int result = dx_SetLightPosition( Position ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightPosition( VECTOR Position ) ;


		/// <summary> Cg̋p[^ݒ肷( LAWOAPAQ ) </summary>
		public static void SetLightRangeAtten( float Range , float Atten0 , float Atten1 , float Atten2 )
		{
			lock( locker )
			{
				int result = dx_SetLightRangeAtten( Range , Atten0 , Atten1 , Atten2 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightRangeAtten( float Range , float Atten0 , float Atten1 , float Atten2 ) ;


		/// <summary> Cg̃X|bgCg̃p[^ݒ肷( OR[pxAR[px ) </summary>
		public static void SetLightAngle( float OutAngle , float InAngle )
		{
			lock( locker )
			{
				int result = dx_SetLightAngle( OutAngle , InAngle ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightAngle( float OutAngle , float InAngle ) ;


		/// <summary> Cg̃^Cv擾( ߂l DX_LIGHTTYPE_DIRECTIONAL  ) </summary>
		public static DX_LIGHTTYPE GetLightType()
		{
			lock( locker )
			{
				DX_LIGHTTYPE result = dx_GetLightType() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_LIGHTTYPE dx_GetLightType() ;


		/// <summary> Cgʂ̗LA擾( TRUE:L  FALSE: ) </summary>
		public static bool GetLightEnable()
		{
			lock( locker )
			{
				int result = dx_GetLightEnable() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLightEnable() ;


		/// <summary> Cg̃fBt[YJ[擾 </summary>
		public static COLOR_F GetLightDifColor()
		{
			lock( locker )
			{
				COLOR_F result = dx_GetLightDifColor() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_GetLightDifColor() ;


		/// <summary> Cg̃XyLJ[擾 </summary>
		public static COLOR_F GetLightSpcColor()
		{
			lock( locker )
			{
				COLOR_F result = dx_GetLightSpcColor() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_GetLightSpcColor() ;


		/// <summary> Cg̃ArGgJ[擾 </summary>
		public static COLOR_F GetLightAmbColor()
		{
			lock( locker )
			{
				COLOR_F result = dx_GetLightAmbColor() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_GetLightAmbColor() ;


		/// <summary> Cg̕擾 </summary>
		public static VECTOR GetLightDirection()
		{
			lock( locker )
			{
				VECTOR result = dx_GetLightDirection() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_GetLightDirection() ;


		/// <summary> Cg̈ʒu擾 </summary>
		public static VECTOR GetLightPosition()
		{
			lock( locker )
			{
				VECTOR result = dx_GetLightPosition() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_GetLightPosition() ;


		/// <summary> Cg̋p[^擾( LAWOAPAQ ) </summary>
		public static void GetLightRangeAtten( out float Range , out float Atten0 , out float Atten1 , out float Atten2 )
		{
			lock( locker )
			{
				int result = dx_GetLightRangeAtten( out Range , out Atten0 , out Atten1 , out Atten2 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLightRangeAtten( out float Range , out float Atten0 , out float Atten1 , out float Atten2 ) ;


		/// <summary> Cg̃X|bgCg̃p[^擾( OR[pxAR[px ) </summary>
		public static void GetLightAngle( out float OutAngle , out float InAngle )
		{
			lock( locker )
			{
				int result = dx_GetLightAngle( out OutAngle , out InAngle ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLightAngle( out float OutAngle , out float InAngle ) ;


		/// <summary> fBNViCgnh쐬 </summary>
		public static Light CreateDirLightHandle( VECTOR Direction )
		{
			lock( locker )
			{
				int result = dx_CreateDirLightHandle( Direction ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Light.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDirLightHandle( VECTOR Direction ) ;


		/// <summary> X|bgCgnh쐬 </summary>
		public static Light CreateSpotLightHandle( VECTOR Position , VECTOR Direction , float OutAngle , float InAngle , float Range , float Atten0 , float Atten1 , float Atten2 )
		{
			lock( locker )
			{
				int result = dx_CreateSpotLightHandle( Position , Direction , OutAngle , InAngle , Range , Atten0 , Atten1 , Atten2 ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Light.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateSpotLightHandle( VECTOR Position , VECTOR Direction , float OutAngle , float InAngle , float Range , float Atten0 , float Atten1 , float Atten2 ) ;


		/// <summary> |CgCgnh쐬 </summary>
		public static Light CreatePointLightHandle( VECTOR Position , float Range , float Atten0 , float Atten1 , float Atten2 )
		{
			lock( locker )
			{
				int result = dx_CreatePointLightHandle( Position , Range , Atten0 , Atten1 , Atten2 ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Light.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreatePointLightHandle( VECTOR Position , float Range , float Atten0 , float Atten1 , float Atten2 ) ;


		/// <summary> Cgnh̃Cg̃^CvύX( DX_LIGHTTYPE_DIRECTIONAL  ) </summary>
		public static void SetLightTypeHandle( Light LHandle , DX_LIGHTTYPE LightType )
		{
			lock( locker )
			{
				int result = dx_SetLightTypeHandle( Light.ToHandle( LHandle ) , LightType ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightTypeHandle( int LHandle , DX_LIGHTTYPE LightType ) ;


		/// <summary> Cgnh̃Cgʂ̗LAݒ肷( TRUE:L  FALSE: ) </summary>
		public static void SetLightEnableHandle( Light LHandle , bool EnableFlag )
		{
			lock( locker )
			{
				int result = dx_SetLightEnableHandle( Light.ToHandle( LHandle ) , EnableFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightEnableHandle( int LHandle , bool EnableFlag ) ;


		/// <summary> Cgnh̃Cg̃fBt[YJ[ݒ肷 </summary>
		public static void SetLightDifColorHandle( Light LHandle , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_SetLightDifColorHandle( Light.ToHandle( LHandle ) , Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightDifColorHandle( int LHandle , COLOR_F Color ) ;


		/// <summary> Cgnh̃Cg̃XyLJ[ݒ肷 </summary>
		public static void SetLightSpcColorHandle( Light LHandle , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_SetLightSpcColorHandle( Light.ToHandle( LHandle ) , Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightSpcColorHandle( int LHandle , COLOR_F Color ) ;


		/// <summary> Cgnh̃Cg̃ArGgJ[ݒ肷 </summary>
		public static void SetLightAmbColorHandle( Light LHandle , COLOR_F Color )
		{
			lock( locker )
			{
				int result = dx_SetLightAmbColorHandle( Light.ToHandle( LHandle ) , Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightAmbColorHandle( int LHandle , COLOR_F Color ) ;


		/// <summary> Cgnh̃Cg̕ݒ肷 </summary>
		public static void SetLightDirectionHandle( Light LHandle , VECTOR Direction )
		{
			lock( locker )
			{
				int result = dx_SetLightDirectionHandle( Light.ToHandle( LHandle ) , Direction ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightDirectionHandle( int LHandle , VECTOR Direction ) ;


		/// <summary> Cgnh̃Cg̈ʒuݒ肷 </summary>
		public static void SetLightPositionHandle( Light LHandle , VECTOR Position )
		{
			lock( locker )
			{
				int result = dx_SetLightPositionHandle( Light.ToHandle( LHandle ) , Position ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightPositionHandle( int LHandle , VECTOR Position ) ;


		/// <summary> Cgnh̃Cg̋p[^ݒ肷( LAWOAPAQ ) </summary>
		public static void SetLightRangeAttenHandle( Light LHandle , float Range , float Atten0 , float Atten1 , float Atten2 )
		{
			lock( locker )
			{
				int result = dx_SetLightRangeAttenHandle( Light.ToHandle( LHandle ) , Range , Atten0 , Atten1 , Atten2 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightRangeAttenHandle( int LHandle , float Range , float Atten0 , float Atten1 , float Atten2 ) ;


		/// <summary> Cgnh̃Cg̃X|bgCg̃p[^ݒ肷( OR[pxAR[px ) </summary>
		public static void SetLightAngleHandle( Light LHandle , float OutAngle , float InAngle )
		{
			lock( locker )
			{
				int result = dx_SetLightAngleHandle( Light.ToHandle( LHandle ) , OutAngle , InAngle ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLightAngleHandle( int LHandle , float OutAngle , float InAngle ) ;


		/// <summary> Cgnh̃Cg̃^Cv擾( ߂l DX_LIGHTTYPE_DIRECTIONAL  ) </summary>
		public static DX_LIGHTTYPE GetLightTypeHandle( Light LHandle )
		{
			lock( locker )
			{
				DX_LIGHTTYPE result = dx_GetLightTypeHandle( Light.ToHandle( LHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_LIGHTTYPE dx_GetLightTypeHandle( int LHandle ) ;


		/// <summary> Cgnh̃Cgʂ̗LA擾( TRUE:L  FALSE: ) </summary>
		public static DX_LIGHTTYPE GetLightEnableHandle( Light LHandle )
		{
			lock( locker )
			{
				DX_LIGHTTYPE result = dx_GetLightEnableHandle( Light.ToHandle( LHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_LIGHTTYPE dx_GetLightEnableHandle( int LHandle ) ;


		/// <summary> Cgnh̃Cg̃fBt[YJ[擾 </summary>
		public static COLOR_F GetLightDifColorHandle( Light LHandle )
		{
			lock( locker )
			{
				COLOR_F result = dx_GetLightDifColorHandle( Light.ToHandle( LHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_GetLightDifColorHandle( int LHandle ) ;


		/// <summary> Cgnh̃Cg̃XyLJ[擾 </summary>
		public static COLOR_F GetLightSpcColorHandle( Light LHandle )
		{
			lock( locker )
			{
				COLOR_F result = dx_GetLightSpcColorHandle( Light.ToHandle( LHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_GetLightSpcColorHandle( int LHandle ) ;


		/// <summary> Cgnh̃Cg̃ArGgJ[擾 </summary>
		public static COLOR_F GetLightAmbColorHandle( Light LHandle )
		{
			lock( locker )
			{
				COLOR_F result = dx_GetLightAmbColorHandle( Light.ToHandle( LHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern COLOR_F dx_GetLightAmbColorHandle( int LHandle ) ;


		/// <summary> Cgnh̃Cg̕擾 </summary>
		public static VECTOR GetLightDirectionHandle( Light LHandle )
		{
			lock( locker )
			{
				VECTOR result = dx_GetLightDirectionHandle( Light.ToHandle( LHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_GetLightDirectionHandle( int LHandle ) ;


		/// <summary> Cgnh̃Cg̈ʒu擾 </summary>
		public static VECTOR GetLightPositionHandle( Light LHandle )
		{
			lock( locker )
			{
				VECTOR result = dx_GetLightPositionHandle( Light.ToHandle( LHandle ) ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_GetLightPositionHandle( int LHandle ) ;


		/// <summary> Cgnh̃Cg̋p[^擾( LAWOAPAQ ) </summary>
		public static void GetLightRangeAttenHandle( Light LHandle , out float Range , out float Atten0 , out float Atten1 , out float Atten2 )
		{
			lock( locker )
			{
				int result = dx_GetLightRangeAttenHandle( Light.ToHandle( LHandle ) , out Range , out Atten0 , out Atten1 , out Atten2 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLightRangeAttenHandle( int LHandle , out float Range , out float Atten0 , out float Atten1 , out float Atten2 ) ;


		/// <summary> Cgnh̃Cg̃X|bgCg̃p[^擾( OR[pxAR[px ) </summary>
		public static void GetLightAngleHandle( Light LHandle , out float OutAngle , out float InAngle )
		{
			lock( locker )
			{
				int result = dx_GetLightAngleHandle( Light.ToHandle( LHandle ) , out OutAngle , out InAngle ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetLightAngleHandle( int LHandle , out float OutAngle , out float InAngle ) ;


		/// <summary> SetCreateGraphColorBitDepth ̋ </summary>
		public static void SetGraphColorBitDepth( int ColorBitDepth )
		{
			lock( locker )
			{
				int result = dx_SetGraphColorBitDepth( ColorBitDepth ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetGraphColorBitDepth( int ColorBitDepth ) ;

		/// <summary> 쐬OtBbN̐F[xݒ肷 </summary>
		public static void SetCreateGraphColorBitDepth( int BitDepth )
		{
			lock( locker )
			{
				int result = dx_SetCreateGraphColorBitDepth( BitDepth ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetCreateGraphColorBitDepth( int BitDepth ) ;


		/// <summary> 쐬OtBbN̐F[xݒ肷 </summary>
		public static int GetCreateGraphColorBitDepth()
		{
			lock( locker )
			{
				int result = dx_GetCreateGraphColorBitDepth() ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetCreateGraphColorBitDepth() ;


		/// <summary> GetCreateGraphColorBitDepth ̋ </summary>
		public static int GetGraphColorBitDepth()
		{
			lock( locker )
			{
				int result = dx_GetGraphColorBitDepth() ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetGraphColorBitDepth() ;


		/// <summary> `\ȃOtBbN쐬邩ǂ̃tOZbg( TRUE:`\  FALSE:`s\ ) </summary>
		public static void SetDrawValidGraphCreateFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetDrawValidGraphCreateFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawValidGraphCreateFlag( bool Flag ) ;


		/// <summary> `\ȃOtBbN쐬邩ǂ̃tO擾 </summary>
		public static bool GetDrawValidGraphCreateFlag()
		{
			lock( locker )
			{
				int result = dx_GetDrawValidGraphCreateFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawValidGraphCreateFlag() ;


		/// <summary> 摜̐F𓧉ߐFɂ邩ǂ̃tOZbg </summary>
		public static void SetLeftUpColorIsTransColorFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetLeftUpColorIsTransColorFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetLeftUpColorIsTransColorFlag( bool Flag ) ;


		/// <summary> uhp摜쐬邩ǂ̃tO擾 </summary>
		public static bool GetUseBlendGraphCreateFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseBlendGraphCreateFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseBlendGraphCreateFlag() ;


		/// <summary> VXeɃOtBbN쐬邩ǂ̃tO擾( TRUE:VXeɍ쐬  FALSE:uq`lɍ쐬 ) </summary>
		public static bool GetUseSystemMemGraphCreateFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseSystemMemGraphCreateFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseSystemMemGraphCreateFlag() ;


		/// <summary> uhp摜쐬邩ǂ̃tOZbg </summary>
		public static void SetUseBlendGraphCreateFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseBlendGraphCreateFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseBlendGraphCreateFlag( bool Flag ) ;


		/// <summary> At@eXggpOtBbN쐬邩ǂ̃tOZbg </summary>
		public static void SetUseAlphaTestGraphCreateFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseAlphaTestGraphCreateFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseAlphaTestGraphCreateFlag( bool Flag ) ;


		/// <summary> SetUseAlphaTestGraphCreateFlag ̋ </summary>
		public static void SetUseAlphaTestFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseAlphaTestFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseAlphaTestFlag( bool Flag ) ;


		/// <summary> SetDrawBlendMode ֐̑ DX_BLENDMODE_NOBLEND ۂɁAftHgł͓͑łQTTw肵ƂɂȂ邪A̎QTTȂǂݒ肷( TRUE:Ȃ(̒lgp)   FALSE:(̒l͖ 255 Ɏgp)(ftHg) )`lt摜ɑ΂ĕ`sꍇ݈̂Ӗ֐ </summary>
		public static void SetUseNoBlendModeParam( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseNoBlendModeParam( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseNoBlendModeParam( bool Flag ) ;
		

		/// <summary> SetDrawValidGraphCreateFlag ̋ </summary>
		public static void SetDrawValidFlagOf3DGraph( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetDrawValidFlagOf3DGraph( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawValidFlagOf3DGraph( bool Flag ) ;


		/// <summary> GetUseAlphaTestGraphCreateFlag ̋ </summary>
		public static bool GetUseAlphaTestFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseAlphaTestFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseAlphaTestFlag() ;


		/// <summary> At@eXggpOtBbN쐬邩ǂ̃tO擾 </summary>
		public static bool GetUseAlphaTestGraphCreateFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseAlphaTestGraphCreateFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseAlphaTestGraphCreateFlag() ;


		/// <summary> `\ȃ`lt摜쐬邩ǂ̃tOZbg ,SetDrawValidGraphCreateFlag ֐ŕ`\摜쐬悤ɐݒ肳ĂȂƌʂȂ( TRUE:`lt FALSE:`lȂ ) </summary>
		public static void SetDrawValidAlphaChannelGraphCreateFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetDrawValidAlphaChannelGraphCreateFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawValidAlphaChannelGraphCreateFlag( bool Flag ) ;


		/// <summary> yobt@Lɂ邩AtOZbg( QcƂRc`ɉe ) </summary>
		public static void SetUseZBufferFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseZBufferFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseZBufferFlag( bool Flag ) ;


		/// <summary> yobt@ɏ݂sAtOZbg( QcƂRc`ɉe ) </summary>
		public static void SetWriteZBufferFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetWriteZBufferFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWriteZBufferFlag( bool Flag ) ;


		/// <summary> yl̔r[hZbg( QcƂRc`ɉe ) </summary>
		/// <param name="CmpType"> DX_CMP_NEVER  </param>
		public static void SetZBufferCmpType( DX_CMP CmpType )
		{
			lock( locker )
			{
				int result = dx_SetZBufferCmpType( CmpType ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetZBufferCmpType( DX_CMP CmpType ) ;


		/// <summary> yoCAXZbg( QcƂRc`ɉe ) </summary>
		public static void SetZBias( int Bias )
		{
			lock( locker )
			{
				int result = dx_SetZBias( Bias ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetZBias( int Bias ) ;


		/// <summary> yobt@Lɂ邩AtOZbg( Rc}``݂̂ɉe ) </summary>
		public static void SetUseZBuffer3D( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseZBuffer3D( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseZBuffer3D( bool Flag ) ;


		/// <summary> yobt@ɏ݂sAtOZbg( Rc}``݂̂ɉe ) </summary>
		public static void SetWriteZBuffer3D( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetWriteZBuffer3D( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWriteZBuffer3D( bool Flag ) ;


		/// <summary> yl̔r[hZbg( Rc}``݂̂ɉe ) </summary>
		/// <param name="CmpType"> DX_CMP_NEVER  </param>
		public static void SetZBufferCmpType3D( DX_CMP CmpType )
		{
			lock( locker )
			{
				int result = dx_SetZBufferCmpType3D( CmpType ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetZBufferCmpType3D( DX_CMP CmpType ) ;


		/// <summary> yoCAXZbg( Rc}``݂̂ɉe ) </summary>
		public static void SetZBias3D( int Bias )
		{
			lock( locker )
			{
				int result = dx_SetZBias3D( Bias ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetZBias3D( int Bias ) ;


		/// <summary> Qc`掞ɂyobt@ɏނylύX </summary>
		public static void SetDrawZ( float z )
		{
			lock( locker )
			{
				int result = dx_SetDrawZ( z ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawZ( float z ) ;


		/// <summary> ߐF@\gp邩ǂݒ肷 </summary>
		public static void SetUseTransColor( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseTransColor( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseTransColor( bool Flag ) ;


		/// <summary> ߐF@\gp邱ƂOƂ摜̓ǂݍݏsǂݒ肷( TRUE ɂ SetDrawMode( DX_DRAWMODE_BILINEAR ); Ԃ DrawGraphF ̕_^W󂯎֐ŏ_ȉ̒lw肵ꍇɔ`挋ʂ̕sRɘaʂ ( ftHg FALSE ) ) </summary>
		public static void SetUseTransColorGraphCreateFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseTransColorGraphCreateFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseTransColorGraphCreateFlag( bool Flag ) ;


		/// <summary> `ltOtBbN쐬邩ǂ̃tOZbg( TRUE:`lt   FALSE:`l ) </summary>
		public static void SetUseAlphaChannelGraphCreateFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseAlphaChannelGraphCreateFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseAlphaChannelGraphCreateFlag( bool Flag ) ;


		/// <summary> SetUseAlphaChannelGraphCreateFlag ̋ </summary>
		public static void SetUseGraphAlphaChannel( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseGraphAlphaChannel( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseGraphAlphaChannel( bool Flag ) ;


		/// <summary> `ltOtBbN쐬邩ǂ̃tO擾( TRUE:`lt   FALSE:`l ) </summary>
		public static bool GetUseAlphaChannelGraphCreateFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseAlphaChannelGraphCreateFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseAlphaChannelGraphCreateFlag() ;


		/// <summary> GetUseAlphaChannelGraphCreateFlag ̋ </summary>
		public static bool GetUseGraphAlphaChannel()
		{
			lock( locker )
			{
				int result = dx_GetUseGraphAlphaChannel() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseGraphAlphaChannel() ;


		/// <summary> ǗeNX`gp邩ÃtOZbg( TRUE:gp  FALSE:gpȂ ) </summary>
		public static void SetUseNotManageTextureFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseNotManageTextureFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseNotManageTextureFlag( bool Flag ) ;


		/// <summary> OtBbNɐݒ肷铧ߐFZbg </summary>
		public static void SetTransColor( int Red , int Green , int Blue )
		{
			lock( locker )
			{
				int result = dx_SetTransColor( Red , Green , Blue ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTransColor( int Red , int Green , int Blue ) ;


		/// <summary> ߐF𓾂 </summary>
		public static void GetTransColor( out int Red , out int Green , out int Blue )
		{
			lock( locker )
			{
				int result = dx_GetTransColor( out Red , out Green , out Blue ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetTransColor( out int Red , out int Green , out int Blue ) ;


		/// <summary> `\̈𓾂 </summary>
		public static void GetDrawArea( out RECT Rect )
		{
			lock( locker )
			{
				int result = dx_GetDrawArea( out Rect ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawArea( out RECT Rect ) ;


		/// <summary> ǗeNX`gp邩ÃtO擾( TRUE:gp  FALSE:gpȂ ) </summary>
		public static bool GetUseNotManageTextureFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseNotManageTextureFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseNotManageTextureFlag() ;


		/// <summary> P}`̕`ɂRcfoCX̋@\gp邩ǂ̃tOZbg </summary>
		public static void SetUseBasicGraphDraw3DDeviceMethodFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseBasicGraphDraw3DDeviceMethodFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseBasicGraphDraw3DDeviceMethodFlag( bool Flag ) ;


		/// <summary> ʏgpȂ </summary>
		public static void SetWindowDrawRect( RECT DrawRect )
		{
			lock( locker )
			{
				int result = dx_SetWindowDrawRect( ref DrawRect ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWindowDrawRect( [ In ] ref RECT DrawRect ) ;


		/// <summary> `uh[h擾 </summary>
		public static void GetDrawBlendMode( out DX_BLENDMODE BlendMode , out int BlendParam )
		{
			lock( locker )
			{
				int result = dx_GetDrawBlendMode( out BlendMode , out BlendParam ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawBlendMode( out DX_BLENDMODE BlendMode , out int BlendParam ) ;


		/// <summary> `惂[h擾 </summary>
		public static DX_DRAWMODE GetDrawMode()
		{
			lock( locker )
			{
				DX_DRAWMODE result = dx_GetDrawMode() ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern DX_DRAWMODE dx_GetDrawMode() ;


		/// <summary> `Px擾 </summary>
		public static void GetDrawBright( out int Red , out int Green , out int Blue )
		{
			lock( locker )
			{
				int result = dx_GetDrawBright( out Red , out Green , out Blue ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawBright( out int Red , out int Green , out int Blue ) ;


		/// <summary> ANeBuɂȂĂOtBbÑnh𓾂 </summary>
		public static Graph GetActiveGraph()
		{
			lock( locker )
			{
				int result = dx_GetActiveGraph() ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetActiveGraph() ;


		/// <summary> eNX`tH[}bg̃CfbNX𓾂 </summary>
		public static int GetTexFormatIndex( IMAGEFORMATDESC Format )
		{
			lock( locker )
			{
				int result = dx_GetTexFormatIndex( ref Format ) ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetTexFormatIndex( [ In ] ref IMAGEFORMATDESC Format ) ;


		/// <summary> urxmb҂邩̃tOZbg </summary>
		public static void SetWaitVSyncFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetWaitVSyncFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetWaitVSyncFlag( bool Flag ) ;


		/// <summary> urxmb҂ݒɂȂĂ邩ǂ擾 </summary>
		public static bool GetWaitVSyncFlag()
		{
			lock( locker )
			{
				int result = dx_GetWaitVSyncFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetWaitVSyncFlag() ;


		/// <summary> ftHg̕ϊsZbg </summary>
		public static void SetDefTransformMatrix()
		{
			lock( locker )
			{
				int result = dx_SetDefTransformMatrix() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDefTransformMatrix() ;


		/// <summary> USOSWỎʂłRQOQSỎʉ𑜓xɂ邩ǂ̃tOZbgAUSOSWOȊỎ𑜓xł͖( TRUE:L  FALSE: ) </summary>
		public static void SetEmulation320x240( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetEmulation320x240( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetEmulation320x240( bool Flag ) ;
	}
}
