using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public delegate void RestoreShredPoint() ;

	public delegate void RestoreGraphCallback() ;


	public static partial class DX
	{


		/// <summary> ̃OtBbN쐬 </summary>
		public static Graph MakeGraph( int SizeX , int SizeY )
		{
			return MakeGraph( SizeX , SizeY , false ) ;
		}

		/// <summary> ̃OtBbN쐬 </summary>
		public static Graph MakeGraph( int SizeX , int SizeY , bool NotUse3DFlag )
		{
			lock( locker )
			{
				int result = dx_MakeGraph( SizeX , SizeY , NotUse3DFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeGraph( int SizeX , int SizeY , bool NotUse3DFlag ) ;


		/// <summary> `\ȉʂ쐬 </summary>
		public static Graph MakeScreen( int SizeX , int SizeY )
		{
			lock( locker )
			{
				int result = dx_MakeScreen( SizeX , SizeY ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_MakeScreen( int SizeX , int SizeY ) ;


		/// <summary> LȃOtBbN̐擾 </summary>
		public static int GetGraphNum()
		{
			lock( locker )
			{
				int result = dx_GetGraphNum() ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetGraphNum() ;


		/// <summary> ɗĂtÕ|C^Zbg </summary>
		/// <param name="LostFlag"> int * </param>
		public static void SetGraphLostFlag( Graph GrHandle , IntPtr LostFlag )
		{
			lock( locker )
			{
				int result = dx_SetGraphLostFlag( Graph.ToHandle( GrHandle ) , LostFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetGraphLostFlag( int GrHandle , IntPtr LostFlag ) ;


		/// <summary> 摜f[^̓] </summary>
		/// <param name="Bmp"> HBITMAP </param>
		/// <param name="AlphaMask"> HBITMAP </param>
		public static void BltBmpToGraph( COLORDATA SrcColor , IntPtr Bmp , IntPtr AlphaMask , string GraphName , int CopyPointX , int CopyPointY , Graph GrHandle , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_BltBmpToGraph( ref SrcColor , Bmp , AlphaMask , GraphName , CopyPointX , CopyPointY , Graph.ToHandle( GrHandle ) , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBmpToGraph( [ In ] ref COLORDATA SrcColor , IntPtr Bmp , IntPtr AlphaMask , string GraphName , int CopyPointX , int CopyPointY , int GrHandle , bool ReverseFlag ) ;


		/// <summary> 摜ւ̂alo̓] </summary>
		/// <param name="Bmp"> HBITMAP </param>
		/// <param name="AlphaMask"> HBITMAP </param>
		public static void BltBmpToDivGraph( COLORDATA SrcColor , IntPtr Bmp , IntPtr AlphaMask , string GraphName , int XNum , int YNum , int Width , int Height , Graph[] GrHandle , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_BltBmpToDivGraph( ref SrcColor , Bmp , AlphaMask , GraphName , GrHandle.Length , XNum , YNum , Width , Height , Graph.ToHandleArray( GrHandle ) , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBmpToDivGraph( [ In ] ref COLORDATA SrcColor , IntPtr Bmp , IntPtr AlphaMask , string GraphName , int AllNum , int XNum , int YNum , int Width , int Height , [ In ] int[] GrHandle , bool ReverseFlag ) ;


		/// <summary> alo  GraphImage 摜ɓ] </summary>
		/// <param name="Bmp"> HBITMAP </param>
		/// <param name="AlphaMask"> HBITMAP </param>
		public static void BltBmpOrGraphImageToGraph( COLORDATA SrcColorData , IntPtr Bmp , IntPtr AlphaMask , string GraphName , bool BmpFlag , BaseImage RgbImage , BaseImage AlphaImage , int CopyPointX , int CopyPointY , Graph GrHandle , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_BltBmpOrGraphImageToGraph( ref SrcColorData , Bmp , AlphaMask , GraphName , BmpFlag , ref RgbImage.buffer , ref AlphaImage.buffer , CopyPointX , CopyPointY , Graph.ToHandle( GrHandle ) , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBmpOrGraphImageToGraph( [ In ] ref COLORDATA SrcColorData , IntPtr Bmp , IntPtr AlphaMask , string GraphName , bool BmpFlag , [ In ] ref BASEIMAGE RgbImage , [ In ] ref BASEIMAGE AlphaImage , int CopyPointX , int CopyPointY , int GrHandle , bool ReverseFlag ) ;


		/// <summary> alo  GraphImage 摜ɓ] </summary>
		/// <param name="Bmp"> HBITMAP </param>
		/// <param name="AlphaMask"> HBITMAP </param>
		public static void BltBmpOrGraphImageToGraph2( COLORDATA SrcColorData , IntPtr Bmp , IntPtr AlphaMask , string GraphName , bool BmpFlag , BaseImage RgbImage , BaseImage AlphaImage , RECT SrcRect , int DestX , int DestY , Graph GrHandle , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_BltBmpOrGraphImageToGraph2( ref SrcColorData , Bmp , AlphaMask , GraphName , BmpFlag , ref RgbImage.buffer , ref AlphaImage.buffer , ref SrcRect , DestX , DestY , Graph.ToHandle( GrHandle ) , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBmpOrGraphImageToGraph2( [ In ] ref COLORDATA SrcColorData , IntPtr Bmp , IntPtr AlphaMask , string GraphName , bool BmpFlag , [ In ] ref BASEIMAGE RgbImage , [ In ] ref BASEIMAGE AlphaImage , [ In ] ref RECT SrcRect , int DestX , int DestY , int GrHandle , bool ReverseFlag ) ;


		/// <summary> 摜ւ alo  GraphImage ̓] </summary>
		/// <param name="Bmp"> HBITMAP </param>
		/// <param name="AlphaMask"> HBITMAP </param>
		public static void BltBmpOrGraphImageToDivGraph( COLORDATA SrcColor , IntPtr Bmp , IntPtr AlphaMask , string GraphName , bool BmpFlag , BaseImage RgbImage , BaseImage AlphaImage , int XNum , int YNum , int Width , int Height , Graph[] GrHandle , bool ReverseFlag )
		{
			lock( locker )
			{
				int result = dx_BltBmpOrGraphImageToDivGraph( ref SrcColor , Bmp , AlphaMask , GraphName , BmpFlag , ref RgbImage.buffer , ref AlphaImage.buffer , GrHandle.Length , XNum , YNum , Width , Height , Graph.ToHandleArray( GrHandle ) , ReverseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_BltBmpOrGraphImageToDivGraph( [ In ] ref COLORDATA SrcColor , IntPtr Bmp , IntPtr AlphaMask , string GraphName , bool BmpFlag , [ In ] ref BASEIMAGE RgbImage , [ In ] ref BASEIMAGE AlphaImage , int AllNum , int XNum , int YNum , int Width , int Height , [ In ] int[] GrHandle , bool ReverseFlag ) ;


		/// <summary> I[o[CT[tFXgp[r[t@C̃I[v </summary>
		public static MovieToOverlay OpenMovieToOverlay( string FileName )
		{
			lock( locker )
			{
				int result = dx_OpenMovieToOverlay( FileName ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return MovieToOverlay.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_OpenMovieToOverlay( string FileName ) ;


		/// <summary> I[o[CT[tFXgp[r[̕\Xe[^XZbg </summary>
		public static void UpdateMovieToOverlay( int x , int y , int ExRate , bool ShowFlag , MovieToOverlay MovieHandle )
		{
			lock( locker )
			{
				int result = dx_UpdateMovieToOverlay( x , y , ExRate , ShowFlag , MovieToOverlay.ToHandle( MovieHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_UpdateMovieToOverlay( int x , int y , int ExRate , bool ShowFlag , int MovieHandle ) ;


		/// <summary> t@Cǂݍ񂾉摜ēxǂݍ </summary>
		public static void ReloadFileGraphAll()
		{
			lock( locker )
			{
				int result = dx_ReloadFileGraphAll() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ReloadFileGraphAll() ;


		/// <summary> 摜̓ߐFύX(At@`lgp͖) </summary>
		public static void SetGraphTransColor( Graph GrHandle , int Red , int Green , int Blue )
		{
			lock( locker )
			{
				int result = dx_SetGraphTransColor( Graph.ToHandle( GrHandle ) , Red , Green , Blue ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetGraphTransColor( int GrHandle , int Red , int Green , int Blue ) ;


		/// <summary> 摜f[^̃XgA </summary>
		public static void RestoreGraph( Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_RestoreGraph( Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_RestoreGraph( int GrHandle ) ;


		/// <summary> ׂẲ摜f[^̃XgA </summary>
		public static void AllRestoreGraph()
		{
			lock( locker )
			{
				int result = dx_AllRestoreGraph() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_AllRestoreGraph() ;


		/// <summary> ʂ̏Ԃ </summary>
		public static void ClearDrawScreen()
		{
			lock( locker )
			{
				int result = dx_ClearDrawScreen( IntPtr.Zero ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		/// <summary> ʂ̏Ԃ </summary>
		public static void ClearDrawScreen( RECT ClearRect )
		{
			lock( locker )
			{
				int result = dx_ClearDrawScreen( ref ClearRect ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearDrawScreen( IntPtr ClearRect ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearDrawScreen( [ In ] ref RECT ClearRect ) ;


		/// <summary> ʂ̂yobt@̏Ԃ </summary>
		public static void ClearDrawScreenZBuffer()
		{
			lock( locker )
			{
				int result = dx_ClearDrawScreenZBuffer( IntPtr.Zero ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		/// <summary> ʂ̂yobt@̏Ԃ </summary>
		public static void ClearDrawScreenZBuffer( RECT ClearRect )
		{
			lock( locker )
			{
				int result = dx_ClearDrawScreenZBuffer( ref ClearRect ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearDrawScreenZBuffer( IntPtr ClearRect ) ;

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClearDrawScreenZBuffer( [ In ] ref RECT ClearRect ) ;


		/// <summary> ʂ̏Ԃ(ClearDrawScreen̋) </summary>
		public static void ClsDrawScreen()
		{
			lock( locker )
			{
				int result = dx_ClsDrawScreen() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ClsDrawScreen() ;


		/// <summary> alot@Cǂ݂ŉʂɕ`悷 </summary>
		public static void LoadGraphScreen( int x , int y , string GraphName , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_LoadGraphScreen( x , y , GraphName , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadGraphScreen( int x , int y , string GraphName , bool TransFlag ) ;


		/// <summary> OtBbN̕` </summary>
		public static void DrawGraph( int x , int y , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawGraph( x , y , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawGraph( int x , int y , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̕` </summary>
		public static void DrawGraphF( float xf , float yf , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawGraphF( xf , yf , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawGraphF( float xf , float yf , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̊gk` </summary>
		public static void DrawExtendGraph( int x1 , int y1 , int x2 , int y2 , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawExtendGraph( x1 , y1 , x2 , y2 , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendGraph( int x1 , int y1 , int x2 , int y2 , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̊gk` </summary>
		public static void DrawExtendGraphF( float x1f , float y1f , float x2f , float y2f , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawExtendGraphF( x1f , y1f , x2f , y2f , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendGraphF( float x1f , float y1f , float x2f , float y2f , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̉]` </summary>
		public static void DrawRotaGraph( int x , int y , double ExRate , double Angle , Graph GrHandle , bool TransFlag )
		{
			DrawRotaGraph( x , y , ExRate , Angle , GrHandle , TransFlag , false ) ;
		}

		/// <summary> OtBbN̉]` </summary>
		public static void DrawRotaGraph( int x , int y , double ExRate , double Angle , Graph GrHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRotaGraph( x , y , ExRate , Angle , Graph.ToHandle( GrHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRotaGraph( int x , int y , double ExRate , double Angle , int GrHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̉]` </summary>
		public static void DrawRotaGraphF( float xf , float yf , double ExRate , double Angle , Graph GrHandle , bool TransFlag )
		{
			DrawRotaGraphF( xf , yf , ExRate , Angle , GrHandle , TransFlag , false ) ;
		}

		/// <summary> OtBbN̉]` </summary>
		public static void DrawRotaGraphF( float xf , float yf , double ExRate , double Angle , Graph GrHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRotaGraphF( xf , yf , ExRate , Angle , Graph.ToHandle( GrHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRotaGraphF( float xf , float yf , double ExRate , double Angle , int GrHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̉]`Q </summary>
		public static void DrawRotaGraph2( int x , int y , int cx , int cy , double ExtRate , double Angle , Graph GrHandle , bool TransFlag )
		{
			DrawRotaGraph2( x , y , cx , cy , ExtRate , Angle , GrHandle , TransFlag , false ) ;
		}

		/// <summary> OtBbN̉]`Q </summary>
		public static void DrawRotaGraph2( int x , int y , int cx , int cy , double ExtRate , double Angle , Graph GrHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRotaGraph2( x , y , cx , cy , ExtRate , Angle , Graph.ToHandle( GrHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRotaGraph2( int x , int y , int cx , int cy , double ExtRate , double Angle , int GrHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̉]`Q </summary>
		public static void DrawRotaGraph2F( float xf , float yf , float cxf , float cyf , double ExtRate , double Angle , Graph GrHandle , bool TransFlag )
		{
			DrawRotaGraph2F( xf , yf , cxf , cyf , ExtRate , Angle , GrHandle , TransFlag , false ) ;
		}

		/// <summary> OtBbN̉]`Q </summary>
		public static void DrawRotaGraph2F( float xf , float yf , float cxf , float cyf , double ExtRate , double Angle , Graph GrHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRotaGraph2F( xf , yf , cxf , cyf , ExtRate , Angle , Graph.ToHandle( GrHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRotaGraph2F( float xf , float yf , float cxf , float cyf , double ExtRate , double Angle , int GrHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> 摜̎Rό`` </summary>
		public static void DrawModiGraph( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , int x4 , int y4 , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawModiGraph( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawModiGraph( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , int x4 , int y4 , int GrHandle , bool TransFlag ) ;


		/// <summary> 摜̎Rό``( float  ) </summary>
		public static void DrawModiGraphF( float x1 , float y1 , float x2 , float y2 , float x3 , float y3 , float x4 , float y4 , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawModiGraphF( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawModiGraphF( float x1 , float y1 , float x2 , float y2 , float x3 , float y3 , float x4 , float y4 , int GrHandle , bool TransFlag ) ;


		/// <summary> 摜̍E]` </summary>
		public static void DrawTurnGraph( int x , int y , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawTurnGraph( x , y , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawTurnGraph( int x , int y , int GrHandle , bool TransFlag ) ;


		/// <summary> 摜̍E]` </summary>
		public static void DrawTurnGraphF( float xf , float yf , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawTurnGraphF( xf , yf , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawTurnGraphF( float xf , float yf , int GrHandle , bool TransFlag ) ;


		/// <summary> `bvOtBbNg}bv` </summary>
		public static void DrawChipMap( int Sx , int Sy , int[ ,] MapData , int MapDataPitch , Graph[] GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawChipMap( Sx , Sy , MapData.GetLength( 1 ) , MapData.GetLength( 0 ) , MapData , GrHandle.Length , MapDataPitch , Graph.ToHandleArray( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawChipMap( int Sx , int Sy , int XNum , int YNum , [ In ] int[ ,] MapData , int ChipTypeNum , int MapDataPitch , [ In ] int[] GrHandle , bool TransFlag ) ;


		/// <summary> `bvOtBbNg}bv` </summary>
		public static void DrawChipMap( int[ ,] MapData , Graph[] ChipGrHandle , bool TransFlag , int MapDrawPointX , int MapDrawPointY , int MapDrawWidth , int MapDrawHeight , int ScreenX , int ScreenY )
		{
			lock( locker )
			{
				int result = dx_DrawChipMap_2( MapData.GetLength( 1 ) , MapData.GetLength( 0 ) , MapData , ChipGrHandle.Length , Graph.ToHandleArray( ChipGrHandle ) , TransFlag , MapDrawPointX , MapDrawPointY , MapDrawWidth , MapDrawHeight , ScreenX , ScreenY ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawChipMap_2( int MapWidth , int MapHeight , [ In ] int[ ,] MapData , int ChipTypeNum , [ In ] int[] ChipGrHandle , bool TransFlag , int MapDrawPointX , int MapDrawPointY , int MapDrawWidth , int MapDrawHeight , int ScreenX , int ScreenY ) ;


		/// <summary> OtBbNẅɃ^Cɕ`悷 </summary>
		public static void DrawTile( int x1 , int y1 , int x2 , int y2 , int Tx , int Ty , double ExtRate , double Angle , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawTile( x1 , y1 , x2 , y2 , Tx , Ty , ExtRate , Angle , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawTile( int x1 , int y1 , int x2 , int y2 , int Tx , int Ty , double ExtRate , double Angle , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̎w`݂̂` </summary>
		public static void DrawRectGraph( int DestX , int DestY , int SrcX , int SrcY , int Width , int Height , Graph GraphHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRectGraph( DestX , DestY , SrcX , SrcY , Width , Height , Graph.ToHandle( GraphHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRectGraph( int DestX , int DestY , int SrcX , int SrcY , int Width , int Height , int GraphHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̎w`݂̂g` </summary>
		public static void DrawRectExtendGraph( int DestX1 , int DestY1 , int DestX2 , int DestY2 , int SrcX , int SrcY , int SrcWidth , int SrcHeight , Graph GraphHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRectExtendGraph( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , Graph.ToHandle( GraphHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRectExtendGraph( int DestX1 , int DestY1 , int DestX2 , int DestY2 , int SrcX , int SrcY , int SrcWidth , int SrcHeight , int GraphHandle , bool TransFlag ) ;


		public static void DrawRectRotaGraph( int X , int Y , int SrcX , int SrcY , int Width , int Height , double ExtRate , double Angle , Graph GraphHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRectRotaGraph( X , Y , SrcX , SrcY , Width , Height , ExtRate , Angle , Graph.ToHandle( GraphHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRectRotaGraph( int X , int Y , int SrcX , int SrcY , int Width , int Height , double ExtRate , double Angle , int GraphHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̎w`݂̂` </summary>
		public static void DrawRectGraphF( float DestX , float DestY , int SrcX , int SrcY , int Width , int Height , Graph GraphHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRectGraphF( DestX , DestY , SrcX , SrcY , Width , Height , Graph.ToHandle( GraphHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRectGraphF( float DestX , float DestY , int SrcX , int SrcY , int Width , int Height , int GraphHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̎w`݂̂g` </summary>
		public static void DrawRectExtendGraphF( float DestX1 , float DestY1 , float DestX2 , float DestY2 , int SrcX , int SrcY , int SrcWidth , int SrcHeight , Graph GraphHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRectExtendGraphF( DestX1 , DestY1 , DestX2 , DestY2 , SrcX , SrcY , SrcWidth , SrcHeight , Graph.ToHandle( GraphHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRectExtendGraphF( float DestX1 , float DestY1 , float DestX2 , float DestY2 , int SrcX , int SrcY , int SrcWidth , int SrcHeight , int GraphHandle , bool TransFlag ) ;


		public static void DrawRectRotaGraphF( float X , float Y , int SrcX , int SrcY , int Width , int Height , double ExtRate , double Angle , Graph GraphHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRectRotaGraphF( X , Y , SrcX , SrcY , Width , Height , ExtRate , Angle , Graph.ToHandle( GraphHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRectRotaGraphF( float X , float Y , int SrcX , int SrcY , int Width , int Height , double ExtRate , double Angle , int GraphHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> uh摜ƍĉ摜`悷 </summary>
		public static void DrawBlendGraph( int x , int y , Graph GrHandle , bool TransFlag , BlendGraph BlendGraph , int BorderParam , int BorderRange )
		{
			lock( locker )
			{
				int result = dx_DrawBlendGraph( x , y , Graph.ToHandle( GrHandle ) , TransFlag , BlendGraph.ToHandle( BlendGraph ) , BorderParam , BorderRange ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawBlendGraph( int x , int y , int GrHandle , bool TransFlag , int BlendGraph , int BorderParam , int BorderRange ) ;


		/// <summary> uh摜ƍĉ摜`悷( uh摜̋N_Ww肷 ) </summary>
		public static void DrawBlendGraphPos( int x , int y , Graph GrHandle , bool TransFlag , int Bx , int By , BlendGraph BlendGraph , int BorderParam , int BorderRange )
		{
			lock( locker )
			{
				int result = dx_DrawBlendGraphPos( x , y , Graph.ToHandle( GrHandle ) , TransFlag , Bx , By , BlendGraph.ToHandle( BlendGraph ) , BorderParam , BorderRange ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawBlendGraphPos( int x , int y , int GrHandle , bool TransFlag , int Bx , int By , int BlendGraph , int BorderParam , int BorderRange ) ;


		/// <summary> ~OtIȕ`s </summary>
		public static void DrawCircleGauge( int CenterX , int CenterY , double Percent , Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_DrawCircleGauge( CenterX , CenterY , Percent , Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawCircleGauge( int CenterX , int CenterY , double Percent , int GrHandle ) ;


		/// <summary> yobt@ɑ΂ĉ摜̕`s </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawGraphToZBuffer( int X , int Y , Graph GrHandle , DX_ZWRITE WriteZMode )
		{
			lock( locker )
			{
				int result = dx_DrawGraphToZBuffer( X , Y , Graph.ToHandle( GrHandle ) , WriteZMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawGraphToZBuffer( int X , int Y , int GrHandle , DX_ZWRITE WriteZMode ) ;


		/// <summary> yobt@ɑ΂ĉ摜̍E]` </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawTurnGraphToZBuffer( int x , int y , Graph GrHandle , DX_ZWRITE WriteZMode )
		{
			lock( locker )
			{
				int result = dx_DrawTurnGraphToZBuffer( x , y , Graph.ToHandle( GrHandle ) , WriteZMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawTurnGraphToZBuffer( int x , int y , int GrHandle , DX_ZWRITE WriteZMode ) ;


		/// <summary> yobt@ɑ΂ĉ摜̊gk` </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawExtendGraphToZBuffer( int x1 , int y1 , int x2 , int y2 , Graph GrHandle , DX_ZWRITE WriteZMode )
		{
			lock( locker )
			{
				int result = dx_DrawExtendGraphToZBuffer( x1 , y1 , x2 , y2 , Graph.ToHandle( GrHandle ) , WriteZMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendGraphToZBuffer( int x1 , int y1 , int x2 , int y2 , int GrHandle , DX_ZWRITE WriteZMode ) ;


		/// <summary> yobt@ɑ΂ĉ摜̉]` </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawRotaGraphToZBuffer( int x , int y , double ExRate , double Angle , Graph GrHandle , DX_ZWRITE WriteZMode )
		{
			DrawRotaGraphToZBuffer( x , y , ExRate , Angle , GrHandle , WriteZMode , false ) ;
		}

		/// <summary> yobt@ɑ΂ĉ摜̉]` </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawRotaGraphToZBuffer( int x , int y , double ExRate , double Angle , Graph GrHandle , DX_ZWRITE WriteZMode , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRotaGraphToZBuffer( x , y , ExRate , Angle , Graph.ToHandle( GrHandle ) , WriteZMode , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRotaGraphToZBuffer( int x , int y , double ExRate , double Angle , int GrHandle , DX_ZWRITE WriteZMode , bool TurnFlag ) ;


		/// <summary> yobt@ɑ΂ĉ摜̎Rό`` </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawModiGraphToZBuffer( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , int x4 , int y4 , Graph GrHandle , DX_ZWRITE WriteZMode )
		{
			lock( locker )
			{
				int result = dx_DrawModiGraphToZBuffer( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Graph.ToHandle( GrHandle ) , WriteZMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawModiGraphToZBuffer( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , int x4 , int y4 , int GrHandle , DX_ZWRITE WriteZMode ) ;


		/// <summary> yobt@ɑ΂ċ`̕`s </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawBoxToZBuffer( int x1 , int y1 , int x2 , int y2 , bool FillFlag , DX_ZWRITE WriteZMode )
		{
			lock( locker )
			{
				int result = dx_DrawBoxToZBuffer( x1 , y1 , x2 , y2 , FillFlag , WriteZMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawBoxToZBuffer( int x1 , int y1 , int x2 , int y2 , bool FillFlag , DX_ZWRITE WriteZMode ) ;


		/// <summary> yobt@ɑ΂ĉ~̕`s </summary>
		/// <param name="WriteZMode"> DX_ZWRITE_MASK  </param>
		public static void DrawCircleToZBuffer( int x , int y , int r , bool FillFlag , DX_ZWRITE WriteZMode )
		{
			lock( locker )
			{
				int result = dx_DrawCircleToZBuffer( x , y , r , FillFlag , WriteZMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawCircleToZBuffer( int x , int y , int r , bool FillFlag , DX_ZWRITE WriteZMode ) ;


		/// <summary> Qc|S`悷 </summary>
		public static void DrawPolygonBase( VERTEX[] Vertex , DX_PRIMTYPE PrimitiveType , Graph GrHandle , bool TransFlag )
		{
			DrawPolygonBase( Vertex , PrimitiveType , GrHandle , TransFlag , false ) ;
		}

		/// <summary> Qc|S`悷 </summary>
		public static void DrawPolygonBase( VERTEX[] Vertex , DX_PRIMTYPE PrimitiveType , Graph GrHandle , bool TransFlag , bool UVScaling )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX *Vertex_ = Vertex )
					{
						int result = dx_DrawPolygonBase( Vertex_ , Vertex.Length , PrimitiveType , Graph.ToHandle( GrHandle ) , TransFlag , UVScaling ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPolygonBase( VERTEX *Vertex , int VertexNum , DX_PRIMTYPE PrimitiveType , int GrHandle , bool TransFlag , bool UVScaling ) ;


		/// <summary> Qc|S`悷 </summary>
		public static void DrawPolygon( VERTEX[] Vertex , Graph GrHandle , bool TransFlag )
		{
			DrawPolygon( Vertex , GrHandle , TransFlag , false ) ;
		}

		/// <summary> Qc|S`悷 </summary>
		public static void DrawPolygon( VERTEX[] Vertex , Graph GrHandle , bool TransFlag , bool UVScaling )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX *Vertex_ = Vertex )
					{
						int result = dx_DrawPolygon( Vertex_ , Vertex.Length / 3 , Graph.ToHandle( GrHandle ) , TransFlag , UVScaling ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPolygon( VERTEX *Vertex , int PolygonNum , int GrHandle , bool TransFlag , bool UVScaling ) ;


		/// <summary> Qcv~eBu`悷 </summary>
		public static void DrawPrimitive2D( VERTEX2D[] Vertex , DX_PRIMTYPE PrimitiveType , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX2D *Vertex_ = Vertex )
					{
						int result = dx_DrawPrimitive2D( Vertex_ , Vertex.Length , PrimitiveType , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitive2D( VERTEX2D *Vertex , int VertexNum , DX_PRIMTYPE PrimitiveType , int GrHandle , bool TransFlag ) ;


		/// <summary> Qcv~eBu`悷(CfbNX) </summary>
		public static void DrawPrimitiveIndexed2D( VERTEX2D[] Vertex , ushort[] Indices , DX_PRIMTYPE PrimitiveType , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX2D *Vertex_ = Vertex ) fixed( ushort *Indices_ = Indices )
					{
						int result = dx_DrawPrimitiveIndexed2D( Vertex_ , Vertex.Length , Indices_ , Indices.Length , PrimitiveType , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitiveIndexed2D( VERTEX2D *Vertex , int VertexNum , ushort *Indices , int IndexNum , DX_PRIMTYPE PrimitiveType , int GrHandle , bool TransFlag ) ;


		/// <summary> Rcv~eBu`悷 </summary>
		public static void DrawPrimitive3D( VERTEX3D[] Vertex , DX_PRIMTYPE PrimitiveType , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX3D *Vertex_ = Vertex )
					{
						int result = dx_DrawPrimitive3D( Vertex_ , Vertex.Length , PrimitiveType , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitive3D( VERTEX3D *Vertex , int VertexNum , DX_PRIMTYPE PrimitiveType , int GrHandle , bool TransFlag ) ;


		/// <summary> Rcv~eBu`悷(CfbNX) </summary>
		public static void DrawPrimitiveIndexed3D( VERTEX3D[] Vertex , ushort[] Indices , DX_PRIMTYPE PrimitiveType , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX3D *Vertex_ = Vertex ) fixed( ushort *Indices_ = Indices )
					{
						int result = dx_DrawPrimitiveIndexed3D( Vertex_ , Vertex.Length , Indices_ , Indices.Length , PrimitiveType , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitiveIndexed3D( VERTEX3D *Vertex , int VertexNum , ushort *Indices , int IndexNum , DX_PRIMTYPE PrimitiveType , int GrHandle , bool TransFlag ) ;


		/// <summary> Rc|S`悷 </summary>
		public static void DrawPolygon3D( VERTEX3D[] Vertex , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX3D *Vertex_ = Vertex )
					{
						int result = dx_DrawPolygon3D( Vertex_ , Vertex.Length / 3 , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPolygon3D( VERTEX3D *Vertex , int PolygonNum , int GrHandle , bool TransFlag ) ;


		/// <summary> Rc|S`悷(CfbNX) </summary>
		public static void DrawPolygonIndexed3D( VERTEX3D[] Vertex , ushort[] Indices , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX3D *Vertex_ = Vertex ) fixed( ushort *Indices_ = Indices )
					{
						int result = dx_DrawPolygonIndexed3D( Vertex_ , Vertex.Length , Indices_ , Indices.Length / 3 , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}
		
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPolygonIndexed3D( VERTEX3D *Vertex , int VertexNum , ushort *Indices , int PolygonNum , int GrHandle , bool TransFlag ) ;


		/// <summary> Rc|S`悷( o[Wp ) </summary>
		public static void DrawPolygon3DBase( VERTEX_3D[] Vertex , DX_PRIMTYPE PrimitiveType , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX_3D *Vertex_ = Vertex )
					{
						int result = dx_DrawPolygon3DBase( Vertex_ , Vertex.Length , PrimitiveType , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPolygon3DBase( VERTEX_3D *Vertex , int VertexNum , DX_PRIMTYPE PrimitiveType , int GrHandle , bool TransFlag ) ;


		/// <summary> Rc|S`悷( o[Wp ) </summary>
		public static void DrawPolygon3D( VERTEX_3D[] Vertex , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX_3D *Vertex_ = Vertex )
					{
						int result = dx_DrawPolygon3D_1( Vertex_ , Vertex.Length / 3 , Graph.ToHandle( GrHandle ) , TransFlag ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}
		
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPolygon3D_1( VERTEX_3D *Vertex , int PolygonNum , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̂Rc` </summary>
		public static void DrawGraph3D( float x , float y , float z , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawGraph3D( x , y , z , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawGraph3D( float x , float y , float z , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̊gRc` </summary>
		public static void DrawExtendGraph3D( float x , float y , float z , double ExRateX , double ExRateY , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawExtendGraph3D( x , y , z , ExRateX , ExRateY , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendGraph3D( float x , float y , float z , double ExRateX , double ExRateY , int GrHandle , bool TransFlag ) ;


		/// <summary> OtBbN̉]Rc` </summary>
		public static void DrawRotaGraph3D( float x , float y , float z , double ExRate , double Angle , Graph GrHandle , bool TransFlag )
		{
			DrawRotaGraph3D( x , y , z , ExRate , Angle , GrHandle , TransFlag , false ) ;
		}

		/// <summary> OtBbN̉]Rc` </summary>
		public static void DrawRotaGraph3D( float x , float y , float z , double ExRate , double Angle , Graph GrHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRotaGraph3D( x , y , z , ExRate , Angle , Graph.ToHandle( GrHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRotaGraph3D( float x , float y , float z , double ExRate , double Angle , int GrHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̉]Rc`(]Sw^) </summary>
		public static void DrawRota2Graph3D( float x , float y , float z , float cx , float cy , double ExtRateX , double ExtRateY , double Angle , Graph GrHandle , bool TransFlag )
		{
			DrawRota2Graph3D( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , GrHandle , TransFlag , false ) ;
		}

		/// <summary> OtBbN̉]Rc`(]Sw^) </summary>
		public static void DrawRota2Graph3D( float x , float y , float z , float cx , float cy , double ExtRateX , double ExtRateY , double Angle , Graph GrHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawRota2Graph3D( x , y , z , cx , cy , ExtRateX , ExtRateY , Angle , Graph.ToHandle( GrHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawRota2Graph3D( float x , float y , float z , float cx , float cy , double ExtRateX , double ExtRateY , double Angle , int GrHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̎Rό`Rc` </summary>
		public static void DrawModiBillboard3D( VECTOR Pos , float x1 , float y1 , float x2 , float y2 , float x3 , float y3 , float x4 , float y4 , Graph GrHandle , bool TransFlag )
		{
			lock( locker )
			{
				int result = dx_DrawModiBillboard3D( Pos , x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Graph.ToHandle( GrHandle ) , TransFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawModiBillboard3D( VECTOR Pos , float x1 , float y1 , float x2 , float y2 , float x3 , float y3 , float x4 , float y4 , int GrHandle , bool TransFlag ) ;


		/// <summary> RcԏɃOtBbN` </summary>
		public static void DrawBillboard3D( VECTOR Pos , float cx , float cy , float Size , float Angle , Graph GrHandle , bool TransFlag , bool TurnFlag )
		{
			lock( locker )
			{
				int result = dx_DrawBillboard3D( Pos , cx , cy , Size , Angle , Graph.ToHandle( GrHandle ) , TransFlag , TurnFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawBillboard3D( VECTOR Pos , float cx , float cy , float Size , float Angle , int GrHandle , bool TransFlag , bool TurnFlag ) ;


		/// <summary> OtBbN̐FœhԂ </summary>
		public static void FillGraph( Graph GrHandle , int Red , int Green , int Blue )
		{
			FillGraph( GrHandle , Red , Green , Blue , 255 ) ;
		}

		/// <summary> OtBbN̐FœhԂ </summary>
		public static void FillGraph( Graph GrHandle , int Red , int Green , int Blue , int Alpha )
		{
			lock( locker )
			{
				int result = dx_FillGraph( Graph.ToHandle( GrHandle ) , Red , Green , Blue , Alpha ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_FillGraph( int GrHandle , int Red , int Green , int Blue , int Alpha ) ;


		/// <summary> ` </summary>
		public static void DrawLine( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color )
		{
			DrawLine( x1 , y1 , x2 , y2 , Color , 1 ) ;
		}

		/// <summary> ` </summary>
		public static void DrawLine( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color , int Thickness )
		{
			lock( locker )
			{
				int result = dx_DrawLine( x1 , y1 , x2 , y2 , Color , Thickness ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawLine( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color , int Thickness ) ;


		/// <summary> lp`̕` </summary>
		public static void DrawBox( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawBox( x1 , y1 , x2 , y2 , Color , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawBox( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color , bool FillFlag ) ;


		/// <summary> ĝlp` </summary>
		public static void DrawFillBox( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color )
		{
			lock( locker )
			{
				int result = dx_DrawFillBox( x1 , y1 , x2 , y2 , Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawFillBox( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color ) ;


		/// <summary> lp`̕`  </summary>
		public static void DrawLineBox( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color )
		{
			lock( locker )
			{
				int result = dx_DrawLineBox( x1 , y1 , x2 , y2 , Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawLineBox( int x1 , int y1 , int x2 , int y2 , COLOR_U8 Color ) ;


		/// <summary> ~` </summary>
		public static void DrawCircle( int x , int y , int r , COLOR_U8 Color )
		{
			DrawCircle( x , y , r , Color , true ) ;
		}

		/// <summary> ~` </summary>
		public static void DrawCircle( int x , int y , int r , COLOR_U8 Color , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawCircle( x , y , r , Color , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawCircle( int x , int y , int r , COLOR_U8 Color , bool FillFlag ) ;


		/// <summary> ȉ~` </summary>
		public static void DrawOval( int x , int y , int Rx , int Ry , COLOR_U8 Color , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawOval( x , y , Rx , Ry , Color , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawOval( int x , int y , int Rx , int Ry , COLOR_U8 Color , bool FillFlag ) ;


		/// <summary> Op`̕` </summary>
		public static void DrawTriangle( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , COLOR_U8 Color , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawTriangle( x1 , y1 , x2 , y2 , x3 , y3 , Color , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawTriangle( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , COLOR_U8 Color , bool FillFlag ) ;


		/// <summary> lp`̕` </summary>
		public static void DrawQuadrangle( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , int x4 , int y4 , COLOR_U8 Color , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawQuadrangle( x1 , y1 , x2 , y2 , x3 , y3 , x4 , y4 , Color , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawQuadrangle( int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , int x4 , int y4 , COLOR_U8 Color , bool FillFlag ) ;


		/// <summary> _`悷 </summary>
		public static void DrawPixel( int x , int y , COLOR_U8 Color )
		{
			lock( locker )
			{
				int result = dx_DrawPixel( x , y , Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawPixel( int x , int y , COLOR_U8 Color ) ;


		/// <summary> _̏W` </summary>
		public static void DrawPixelSet( POINTDATA[] PointData )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( POINTDATA *PointData_ = PointData )
					{
						int result = dx_DrawPixelSet( PointData_ , PointData.Length ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPixelSet( POINTDATA *PointData , int Num ) ;


		/// <summary> ̏W` </summary>
		public static void DrawLineSet( LINEDATA[] LineData )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( LINEDATA *LineData_ = LineData )
					{
						int result = dx_DrawLineSet( LineData_ , LineData.Length ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawLineSet( LINEDATA *LineData , int Num ) ;


		/// <summary> Rc̐`悷 </summary>
		public static void DrawLine3D( VECTOR Pos1 , VECTOR Pos2 , COLOR_U8 Color )
		{
			lock( locker )
			{
				int result = dx_DrawLine3D( Pos1 , Pos2 , Color ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawLine3D( VECTOR Pos1 , VECTOR Pos2 , COLOR_U8 Color ) ;


		/// <summary> Rc̎Op``悷 </summary>
		public static void DrawTriangle3D( VECTOR Pos1 , VECTOR Pos2 , VECTOR Pos3 , COLOR_U8 Color , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawTriangle3D( Pos1 , Pos2 , Pos3 , Color , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawTriangle3D( VECTOR Pos1 , VECTOR Pos2 , VECTOR Pos3 , COLOR_U8 Color , bool FillFlag ) ;


		/// <summary> Rĉ̗`悷 </summary>
		public static void DrawCube3D( VECTOR Pos1 , VECTOR Pos2 , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawCube3D( Pos1 , Pos2 , DifColor , SpcColor , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawCube3D( VECTOR Pos1 , VECTOR Pos2 , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag ) ;


		/// <summary> Rc̋̂`悷 </summary>
		public static void DrawSphere3D( VECTOR CenterPos , float r , int DivNum , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawSphere3D( CenterPos , r , DivNum , DifColor , SpcColor , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawSphere3D( VECTOR CenterPos , float r , int DivNum , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag ) ;


		/// <summary> Rc̃JvZ`悷 </summary>
		public static void DrawCapsule3D( VECTOR Pos1 , VECTOR Pos2 , float r , int DivNum , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawCapsule3D( Pos1 , Pos2 , r , DivNum , DifColor , SpcColor , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		/// <summary> Rc̃JvZ`悷 </summary>
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawCapsule3D( VECTOR Pos1 , VECTOR Pos2 , float r , int DivNum , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag ) ;


		/// <summary> Rc̉~`悷 </summary>
		public static void DrawCone3D( VECTOR TopPos , VECTOR BottomPos , float r , int DivNum , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag )
		{
			lock( locker )
			{
				int result = dx_DrawCone3D( TopPos , BottomPos , r , DivNum , DifColor , SpcColor , FillFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawCone3D( VECTOR TopPos , VECTOR BottomPos , float r , int DivNum , COLOR_U8 DifColor , COLOR_U8 SpcColor , bool FillFlag ) ;


		/// <summary> ̕` </summary>
		public static void DrawString( int x , int y , string String , COLOR_U8 Color )
		{
			DrawString( x , y , String , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> ̕` </summary>
		public static void DrawString( int x , int y , string String , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawString( x , y , String , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawString( int x , int y , string String , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> ̕` </summary>
		public static void DrawVString( int x , int y , string String , COLOR_U8 Color )
		{
			DrawVString( x , y , String , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> ̕` </summary>
		public static void DrawVString( int x , int y , string String , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawVString( x , y , String , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawVString( int x , int y , string String , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> `悷 </summary>
		public static void DrawStringToHandle( int x , int y , string String , COLOR_U8 Color , Font FontHandle )
		{
			DrawStringToHandle( x , y , String , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> `悷 </summary>
		public static void DrawStringToHandle( int x , int y , string String , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			DrawStringToHandle( x , y , String , Color , FontHandle , EdgeColor , false ) ;
		}

		/// <summary> `悷 </summary>
		public static void DrawStringToHandle( int x , int y , string String , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_DrawStringToHandle( x , y , String , Color , Font.ToHandle( FontHandle ) , EdgeColor , VerticalFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawStringToHandle( int x , int y , string String , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor , bool VerticalFlag ) ;


		/// <summary> `悷 </summary>
		public static void DrawVStringToHandle( int x , int y , string String , COLOR_U8 Color , Font FontHandle )
		{
			DrawVStringToHandle( x , y , String , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> `悷 </summary>
		public static void DrawVStringToHandle( int x , int y , string String , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawVStringToHandle( x , y , String , Color , Font.ToHandle( FontHandle ) , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawVStringToHandle( int x , int y , string String , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor ) ;


		/// <summary> ̊g` </summary>
		public static void DrawExtendString( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color )
		{
			DrawExtendString( x , y , ExRateX , ExRateY , String , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> ̊g` </summary>
		public static void DrawExtendString( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawExtendString( x , y , ExRateX , ExRateY , String , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendString( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> ̊g` </summary>
		public static void DrawExtendVString( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color )
		{
			DrawExtendVString( x , y , ExRateX , ExRateY , String , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> ̊g` </summary>
		public static void DrawExtendVString( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawExtendVString( x , y , ExRateX , ExRateY , String , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendVString( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> g`悷 </summary>
		public static void DrawExtendStringToHandle( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , Font FontHandle )
		{
			DrawExtendStringToHandle( x , y , ExRateX , ExRateY , String , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> g`悷 </summary>
		public static void DrawExtendStringToHandle( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			DrawExtendStringToHandle( x , y , ExRateX , ExRateY , String , Color , FontHandle , EdgeColor , false ) ;
		}

		/// <summary> g`悷 </summary>
		public static void DrawExtendStringToHandle( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor , bool VerticalFlag )
		{
			lock( locker )
			{
				int result = dx_DrawExtendStringToHandle( x , y , ExRateX , ExRateY , String , Color , Font.ToHandle( FontHandle ) , EdgeColor , VerticalFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendStringToHandle( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor , bool VerticalFlag ) ;


		/// <summary> g`悷 </summary>
		public static void DrawExtendVStringToHandle( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , Font FontHandle )
		{
			DrawExtendVStringToHandle( x , y , ExRateX , ExRateY , String , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> g`悷 </summary>
		public static void DrawExtendVStringToHandle( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawExtendVStringToHandle( x , y , ExRateX , ExRateY , String , Color , Font.ToHandle( FontHandle ) , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawExtendVStringToHandle( int x , int y , double ExRateX , double ExRateY , string String , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor ) ;


		/// <summary> ^̐l`悷 </summary>
		public static void DrawNumberToI( int x , int y , int Num , int RisesNum , COLOR_U8 Color )
		{
			DrawNumberToI( x , y , Num , RisesNum , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> ^̐l`悷 </summary>
		public static void DrawNumberToI( int x , int y , int Num , int RisesNum , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberToI( x , y , Num , RisesNum , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberToI( int x , int y , int Num , int RisesNum , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> _^̐l`悷 </summary>
		public static void DrawNumberToF( int x , int y , double Num , int Length , COLOR_U8 Color )
		{
			DrawNumberToF( x , y , Num , Length , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> _^̐l`悷 </summary>
		public static void DrawNumberToF( int x , int y , double Num , int Length , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberToF( x , y , Num , Length , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberToF( int x , int y , double Num , int Length , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> ^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToI( int x , int y , string NoteString , int Num , int RisesNum , COLOR_U8 Color )
		{
			DrawNumberPlusToI( x , y , NoteString , Num , RisesNum , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> ^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToI( int x , int y , string NoteString , int Num , int RisesNum , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberPlusToI( x , y , NoteString , Num , RisesNum , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberPlusToI( int x , int y , string NoteString , int Num , int RisesNum , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> _^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToF( int x , int y , string NoteString , double Num , int Length , COLOR_U8 Color )
		{
			DrawNumberPlusToF( x , y , NoteString , Num , Length , Color , COLOR_U8.Empty ) ;
		}

		/// <summary> _^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToF( int x , int y , string NoteString , double Num , int Length , COLOR_U8 Color , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberPlusToF( x , y , NoteString , Num , Length , Color , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberPlusToF( int x , int y , string NoteString , double Num , int Length , COLOR_U8 Color , COLOR_U8 EdgeColor ) ;


		/// <summary> ^̐l`悷 </summary>
		public static void DrawNumberToIToHandle( int x , int y , int Num , int RisesNum , COLOR_U8 Color , Font FontHandle )
		{
			DrawNumberToIToHandle( x , y , Num , RisesNum , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> ^̐l`悷 </summary>
		public static void DrawNumberToIToHandle( int x , int y , int Num , int RisesNum , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberToIToHandle( x , y , Num , RisesNum , Color , Font.ToHandle( FontHandle ) , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberToIToHandle( int x , int y , int Num , int RisesNum , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor ) ;


		/// <summary> _^̐l`悷 </summary>
		public static void DrawNumberToFToHandle( int x , int y , double Num , int Length , COLOR_U8 Color , Font FontHandle )
		{
			DrawNumberToFToHandle( x , y , Num , Length , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> _^̐l`悷 </summary>
		public static void DrawNumberToFToHandle( int x , int y , double Num , int Length , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberToFToHandle( x , y , Num , Length , Color , Font.ToHandle( FontHandle ) , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberToFToHandle( int x , int y , double Num , int Length , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor ) ;


		/// <summary> ^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToIToHandle( int x , int y , string NoteString , int Num , int RisesNum , COLOR_U8 Color , Font FontHandle )
		{
			DrawNumberPlusToIToHandle( x , y , NoteString , Num , RisesNum , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> ^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToIToHandle( int x , int y , string NoteString , int Num , int RisesNum , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberPlusToIToHandle( x , y , NoteString , Num , RisesNum , Color , Font.ToHandle( FontHandle ) , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberPlusToIToHandle( int x , int y , string NoteString , int Num , int RisesNum , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor ) ;


		/// <summary> _^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToFToHandle( int x , int y , string NoteString , double Num , int Length , COLOR_U8 Color , Font FontHandle )
		{
			DrawNumberPlusToFToHandle( x , y , NoteString , Num , Length , Color , FontHandle , COLOR_U8.Empty ) ;
		}

		/// <summary> _^̐lƂ̐̕xɕ`悷 </summary>
		public static void DrawNumberPlusToFToHandle( int x , int y , string NoteString , double Num , int Length , COLOR_U8 Color , Font FontHandle , COLOR_U8 EdgeColor )
		{
			lock( locker )
			{
				int result = dx_DrawNumberPlusToFToHandle( x , y , NoteString , Num , Length , Color , Font.ToHandle( FontHandle ) , EdgeColor ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DrawNumberPlusToFToHandle( int x , int y , string NoteString , double Num , int Length , COLOR_U8 Color , int FontHandle , COLOR_U8 EdgeColor ) ;


		/// <summary> gpłVF[_[̃o[W擾( 0=gȂ  200=VF[_[fQDOgp\  300=VF[_[fRDOgp\ ) </summary>
		public static int GetValidShaderVersion()
		{
			lock( locker )
			{
				int result = dx_GetValidShaderVersion() ;
				if( !( result >= 0 ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetValidShaderVersion() ;


		/// <summary> _VF[_[oCit@Cǂݍݒ_VF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh ) </summary>
		public static Shader LoadVertexShader( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadVertexShader( FileName ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Shader.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadVertexShader( string FileName ) ;


		/// <summary> ԏɑ݂钸_VF[_[oCi璸_VF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh ) </summary>
		public static Shader LoadVertexShaderFromMem( IntPtr ImageAddress , int ImageSize )
		{
			lock( locker )
			{
				int result = dx_LoadVertexShaderFromMem( ImageAddress , ImageSize ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Shader.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadVertexShaderFromMem( IntPtr ImageAddress , int ImageSize ) ;


		/// <summary> sNZVF[_[oCit@Cǂݍ݃sNZVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh ) </summary>
		public static Shader LoadPixelShader( string FileName )
		{
			lock( locker )
			{
				int result = dx_LoadPixelShader( FileName ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Shader.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadPixelShader( string FileName ) ;


		/// <summary> ԏɑ݂sNZVF[_[oCisNZVF[_[nh쐬( ߂l -1:G[  -1ȊO:VF[_[nh ) </summary>
		public static Shader LoadPixelShaderFromMem( IntPtr ImageAddress , int ImageSize )
		{
			lock( locker )
			{
				int result = dx_LoadPixelShaderFromMem( ImageAddress , ImageSize ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Shader.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_LoadPixelShaderFromMem( IntPtr ImageAddress , int ImageSize ) ;


		/// <summary> w̖O萔̔ԍ擾 </summary>
		public static void GetConstIndexToShader( string ConstantName , Shader ShaderHandle )
		{
			lock( locker )
			{
				int result = dx_GetConstIndexToShader( ConstantName , Shader.ToHandle( ShaderHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetConstIndexToShader( string ConstantName , int ShaderHandle ) ;


		/// <summary> _VF[_[ float ^萔ݒ肷 </summary>
		public static void SetVSConstF( int ConstantIndex , FLOAT4 Param )
		{
			lock( locker )
			{
				int result = dx_SetVSConstF( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstF( int ConstantIndex , FLOAT4 Param ) ;


		/// <summary> _VF[_[ float ^萔ɍsݒ肷 </summary>
		public static void SetVSConstFMtx( int ConstantIndex , MATRIX Param )
		{
			lock( locker )
			{
				int result = dx_SetVSConstFMtx( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstFMtx( int ConstantIndex , MATRIX Param ) ;


		/// <summary> _VF[_[ int ^萔ݒ肷 </summary>
		public static void SetVSConstI( int ConstantIndex , INT4 Param )
		{
			lock( locker )
			{
				int result = dx_SetVSConstI( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstI( int ConstantIndex , INT4 Param ) ;


		/// <summary> _VF[_[ BOOL ^萔ݒ肷 </summary>
		public static void SetVSConstB( int ConstantIndex , bool Param )
		{
			lock( locker )
			{
				int result = dx_SetVSConstB( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstB( int ConstantIndex , bool Param ) ;


		/// <summary> _VF[_[ float ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetVSConstFArray( int ConstantIndex , FLOAT4[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetVSConstFArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstFArray( int ConstantIndex , [ In ] FLOAT4[] ParamArray , int ParamNum ) ;


		/// <summary> _VF[_[ float ^萔ɍsݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetVSConstFMtxArray( int ConstantIndex , MATRIX[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetVSConstFMtxArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstFMtxArray( int ConstantIndex , [ In ] MATRIX[] ParamArray , int ParamNum ) ;


		/// <summary> _VF[_[ int ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetVSConstIArray( int ConstantIndex , INT4[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetVSConstIArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstIArray( int ConstantIndex , [ In ] INT4[] ParamArray , int ParamNum ) ;


		/// <summary> _VF[_[ int ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetVSConstBArray( int ConstantIndex , int[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetVSConstBArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetVSConstBArray( int ConstantIndex , [ In ] int[] ParamArray , int ParamNum ) ;


		/// <summary> sNZVF[_[ float ^萔ݒ肷 </summary>
		public static void SetPSConstF( int ConstantIndex , FLOAT4 Param )
		{
			lock( locker )
			{
				int result = dx_SetPSConstF( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstF( int ConstantIndex , FLOAT4 Param ) ;


		/// <summary> sNZVF[_[ float ^萔ɍsݒ肷 </summary>
		public static void SetPSConstFMtx( int ConstantIndex , MATRIX Param )
		{
			lock( locker )
			{
				int result = dx_SetPSConstFMtx( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstFMtx( int ConstantIndex , MATRIX Param ) ;


		/// <summary> sNZVF[_[ int ^萔ݒ肷 </summary>
		public static void SetPSConstI( int ConstantIndex , INT4 Param )
		{
			lock( locker )
			{
				int result = dx_SetPSConstI( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstI( int ConstantIndex , INT4 Param ) ;


		/// <summary> sNZVF[_[ BOOL ^萔ݒ肷 </summary>
		public static void SetPSConstB( int ConstantIndex , bool Param )
		{
			lock( locker )
			{
				int result = dx_SetPSConstB( ConstantIndex , Param ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstB( int ConstantIndex , bool Param ) ;


		/// <summary> sNZVF[_[ float ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetPSConstFArray( int ConstantIndex , FLOAT4[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetPSConstFArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstFArray( int ConstantIndex , [ In ] FLOAT4[] ParamArray , int ParamNum ) ;


		/// <summary> sNZVF[_[ float ^萔ɍsݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetPSConstFMtxArray( int ConstantIndex , MATRIX[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetPSConstFMtxArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstFMtxArray( int ConstantIndex , [ In ] MATRIX[] ParamArray , int ParamNum ) ;


		/// <summary> sNZVF[_[ int ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetPSConstIArray( int ConstantIndex , INT4[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetPSConstIArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstIArray( int ConstantIndex , [ In ] INT4[] ParamArray , int ParamNum ) ;


		/// <summary> sNZVF[_[ int ^萔ݒ肷( zgĘAԃCfbNXɈxɐݒ ) </summary>
		public static void SetPSConstBArray( int ConstantIndex , int[] ParamArray )
		{
			lock( locker )
			{
				int result = dx_SetPSConstBArray( ConstantIndex , ParamArray , ParamArray.Length ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetPSConstBArray( int ConstantIndex , [ In ] int[] ParamArray , int ParamNum ) ;


		/// <summary> VF[_[`ŎgpOtBbNݒ肷 </summary>
		public static void SetUseTextureToShader( int StageIndex , Graph GraphHandle )
		{
			lock( locker )
			{
				int result = dx_SetUseTextureToShader( StageIndex , Graph.ToHandle( GraphHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseTextureToShader( int StageIndex , int GraphHandle ) ;


		/// <summary> VF[_[`Ɏgp钸_VF[_[ݒ肷( -1nƉ ) </summary>
		public static void SetUseVertexShader( Shader ShaderHandle )
		{
			lock( locker )
			{
				int result = dx_SetUseVertexShader( Shader.ToHandle( ShaderHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseVertexShader( int ShaderHandle ) ;


		/// <summary> VF[_[`ɎgpsNZVF[_[ݒ肷( -1nƉ ) </summary>
		public static void SetUsePixelShader( Shader ShaderHandle )
		{
			lock( locker )
			{
				int result = dx_SetUsePixelShader( Shader.ToHandle( ShaderHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUsePixelShader( int ShaderHandle ) ;


		/// <summary> VF[_[gĂQcv~eBu`悷 </summary>
		public static void DrawPrimitive2DToShader( VERTEX2DSHADER[] Vertex , DX_PRIMTYPE PrimitiveType )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX2DSHADER *Vertex_ = Vertex )
					{
						int result = dx_DrawPrimitive2DToShader( Vertex_ , Vertex.Length , PrimitiveType ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitive2DToShader( VERTEX2DSHADER *Vertex , int VertexNum , DX_PRIMTYPE PrimitiveType ) ;


		/// <summary> VF[_[gĂRcv~eBu`悷 </summary>
		public static void DrawPrimitive3DToShader( VERTEX3DSHADER[] Vertex , DX_PRIMTYPE PrimitiveType )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX3DSHADER *Vertex_ = Vertex )
					{
						int result = dx_DrawPrimitive3DToShader( Vertex_ , Vertex.Length , PrimitiveType ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitive3DToShader( VERTEX3DSHADER *Vertex , int VertexNum , DX_PRIMTYPE PrimitiveType ) ;


		/// <summary> VF[_[gĂQcv~eBu`悷(CfbNX) </summary>
		public static void DrawPrimitiveIndexed2DToShader( VERTEX2DSHADER[] Vertex , ushort[] Indices , DX_PRIMTYPE PrimitiveType )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX2DSHADER *Vertex_ = Vertex ) fixed( ushort *Indices_ = Indices )
					{
						int result = dx_DrawPrimitiveIndexed2DToShader( Vertex_ , Vertex.Length , Indices_ , Indices.Length , PrimitiveType ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitiveIndexed2DToShader( VERTEX2DSHADER *Vertex , int VertexNum , ushort *Indices , int IndexNum , DX_PRIMTYPE PrimitiveType ) ;


		/// <summary> VF[_[gĂRcv~eBu`悷(CfbNX) </summary>
		public static void DrawPrimitiveIndexed3DToShader( VERTEX3DSHADER[] Vertex , ushort[] Indices , DX_PRIMTYPE PrimitiveType )
		{
			lock( locker )
			{
				unsafe
				{
					fixed( VERTEX3DSHADER *Vertex_ = Vertex ) fixed( ushort *Indices_ = Indices )
					{
						int result = dx_DrawPrimitiveIndexed3DToShader( Vertex_ , Vertex.Length , Indices_ , Indices.Length , PrimitiveType ) ;
						if( !( result == 0 ) ) { throw new DX.Exception(); }
					}
				}
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern unsafe int dx_DrawPrimitiveIndexed3DToShader( VERTEX3DSHADER *Vertex , int VertexNum , ushort *Indices , int IndexNum , DX_PRIMTYPE PrimitiveType ) ;


		/// <summary> `惂[hZbg </summary>
		public static void SetDrawMode( DX_DRAWMODE DrawMode )
		{
			lock( locker )
			{
				int result = dx_SetDrawMode( DrawMode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawMode( DX_DRAWMODE DrawMode ) ;


		/// <summary> őٕ̒lZbg </summary>
		public static void SetMaxAnisotropy( int MaxAnisotropy )
		{
			lock( locker )
			{
				int result = dx_SetMaxAnisotropy( MaxAnisotropy ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetMaxAnisotropy( int MaxAnisotropy ) ;


		/// <summary> `uh[hZbg </summary>
		public static void SetDrawBlendMode( DX_BLENDMODE BlendMode , int BlendParam )
		{
			lock( locker )
			{
				int result = dx_SetDrawBlendMode( BlendMode , BlendParam ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawBlendMode( DX_BLENDMODE BlendMode , int BlendParam ) ;


		/// <summary> `揈ɕ`悷摜ƃuh郿`lt摜Zbg( BlendGraph  -1 Ńuh@\𖳌 ) </summary>
		public static void SetBlendGraph( BlendGraph BlendGraph , int BorderParam , int BorderRange )
		{
			lock( locker )
			{
				int result = dx_SetBlendGraph( BlendGraph.ToHandle( BlendGraph ) , BorderParam , BorderRange ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetBlendGraph( int BlendGraph , int BorderParam , int BorderRange ) ;


		/// <summary> uh摜̋N_WZbg </summary>
		public static void SetBlendGraphPosition( int x , int y )
		{
			lock( locker )
			{
				int result = dx_SetBlendGraphPosition( x , y ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetBlendGraphPosition( int x , int y ) ;


		/// <summary> `PxZbg </summary>
		public static void SetDrawBright( int RedBright , int GreenBright , int BlueBright )
		{
			lock( locker )
			{
				int result = dx_SetDrawBright( RedBright , GreenBright , BlueBright ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawBright( int RedBright , int GreenBright , int BlueBright ) ;


		/// <summary> `ʂ̃Zbg </summary>
		public static void SetDrawScreen( Graph DrawScreen )
		{
			lock( locker )
			{
				int result = dx_SetDrawScreen( Graph.ToHandle( DrawScreen ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawScreen( int DrawScreen ) ;


		/// <summary> `\̈̃Zbg </summary>
		public static void SetDrawArea( int x1 , int y1 , int x2 , int y2 )
		{
			lock( locker )
			{
				int result = dx_SetDrawArea( x1 , y1 , x2 , y2 ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawArea( int x1 , int y1 , int x2 , int y2 ) ;


		/// <summary> Rc`̃XP[Zbg </summary>
		public static void SetDraw3DScale( float Scale )
		{
			lock( locker )
			{
				int result = dx_SetDraw3DScale( Scale ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDraw3DScale( float Scale ) ;


		/// <summary> `\̈`ΏۉʑŜɂ </summary>
		public static void SetDrawAreaFull()
		{
			lock( locker )
			{
				int result = dx_SetDrawAreaFull() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetDrawAreaFull() ;


		/// <summary> Rc@\gÃtOZbg </summary>
		public static void SetUse3DFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUse3DFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUse3DFlag( bool Flag ) ;


		/// <summary> n[hEGA̒_Z@\gp邩ǂݒ肷 </summary>
		public static void SetUseHardwareVertexProcessing( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseHardwareVertexProcessing( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseHardwareVertexProcessing( bool Flag ) ;


		/// <summary> SetRestoreGraphCallback ̋ </summary>
		public static void SetRestoreShredPoint( RestoreShredPoint ShredPoint )
		{
			lock( locker )
			{
				RestoreShredPoint = delegate()
				{
					ShredPoint() ;
				} ;
				int result = dx_SetRestoreShredPoint( RestoreShredPoint ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetRestoreShredPoint( [ MarshalAs( UnmanagedType.FunctionPtr ) ] RESTORESHREDPOINT ShredPoint ) ;

		private static RESTORESHREDPOINT RestoreShredPoint ;
		
	#if UNICODE
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Unicode ) ]
	#else
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Ansi ) ]
	#endif
		private delegate void RESTORESHREDPOINT() ;


		/// <summary> OtBbNnh֐̓o^ </summary>
		public static void SetRestoreGraphCallback( RestoreGraphCallback Callback )
		{
			lock( locker )
			{
				RestoreGraphCallback = delegate()
				{
					Callback() ;
				} ;
				int result = dx_SetRestoreGraphCallback( RestoreGraphCallback ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetRestoreGraphCallback( [ MarshalAs( UnmanagedType.FunctionPtr ) ] RESTOREGRAPHCALLBACK Callback ) ;

		private static RESTOREGRAPHCALLBACK RestoreGraphCallback ;

	#if UNICODE
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Unicode ) ]
	#else
		[ UnmanagedFunctionPointer( CallingConvention.Cdecl , CharSet = CharSet.Ansi ) ]
	#endif
		private delegate void RESTOREGRAPHCALLBACK() ;


		/// <summary> OtBbN֐̎s </summary>
		public static void RunRestoreShred()
		{
			lock( locker )
			{
				int result = dx_RunRestoreShred() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_RunRestoreShred() ;


		/// <summary> [hϊpsZbg </summary>
		public static void SetTransformToWorld( MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_SetTransformToWorld( ref Matrix ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTransformToWorld( [ In ] ref MATRIX Matrix ) ;


		/// <summary> r[ϊpsZbg </summary>
		public static void SetTransformToView( MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_SetTransformToView( ref Matrix ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTransformToView( [ In ] ref MATRIX Matrix ) ;


		/// <summary> eϊpsZbg </summary>
		public static void SetTransformToProjection( MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_SetTransformToProjection( ref Matrix ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTransformToProjection( [ In ] ref MATRIX Matrix ) ;


		/// <summary> r[|[gsZbg </summary>
		public static void SetTransformToViewport( MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_SetTransformToViewport( ref Matrix ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTransformToViewport( [ In ] ref MATRIX Matrix ) ;


		/// <summary> SetUseBackCulling ̋ </summary>
		public static void SetUseCullingFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseCullingFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}
		
	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseCullingFlag( bool Flag ) ;


		/// <summary> |SJO̗LAZbg </summary>
		public static void SetUseBackCulling( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseBackCulling( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseBackCulling( bool Flag ) ;


		/// <summary> eNX`AhX[hݒ肷 </summary>
		/// <param name="Mode"> DX_TEXADDRESS_WRAP  </param>
		public static void SetTextureAddressMode( DX_TEXADDRESS Mode , int Stage )
		{
			lock( locker )
			{
				int result = dx_SetTextureAddressMode( Mode , Stage ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		/// <summary> eNX`AhX[hݒ肷 </summary>
		/// <param name="Mode"> DX_TEXADDRESS_WRAP  </param>
		public static void SetTextureAddressMode( DX_TEXADDRESS Mode )
		{
			SetTextureAddressMode( Mode , -1 ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTextureAddressMode( DX_TEXADDRESS Mode , int Stage ) ;


		/// <summary> eNX`AhX[hݒ肷 </summary>
		public static void SetTextureAddressModeUV( DX_TEXADDRESS ModeU , DX_TEXADDRESS ModeV , int Stage )
		{
			lock( locker )
			{
				int result = dx_SetTextureAddressModeUV( ModeU , ModeV , Stage ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

		/// <summary> eNX`AhX[hݒ肷 </summary>
		public static void SetTextureAddressModeUV( DX_TEXADDRESS ModeU , DX_TEXADDRESS ModeV )
		{
			SetTextureAddressModeUV( ModeU , ModeV , -1 ) ;
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTextureAddressModeUV( DX_TEXADDRESS ModeU , DX_TEXADDRESS ModeV , int Stage ) ;


		/// <summary> eNX`Wϊp[^Zbg </summary>
		public static void SetTextureAddressTransform( float TransU , float TransV , float ScaleU , float ScaleV , float RotCenterU , float RotCenterV , float Rotate )
		{
			lock( locker )
			{
				int result = dx_SetTextureAddressTransform( TransU , TransV , ScaleU , ScaleV , RotCenterU , RotCenterV , Rotate ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTextureAddressTransform( float TransU , float TransV , float ScaleU , float ScaleV , float RotCenterU , float RotCenterV , float Rotate ) ;


		/// <summary> eNX`WϊsZbg </summary>
		public static void SetTextureAddressTransformMatrix( MATRIX Matrix )
		{
			lock( locker )
			{
				int result = dx_SetTextureAddressTransformMatrix( Matrix ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetTextureAddressTransformMatrix( MATRIX Matrix ) ;


		/// <summary> eNX`Wϊp[^Zbg </summary>
		public static void ResetTextureAddressTransform()
		{
			lock( locker )
			{
				int result = dx_ResetTextureAddressTransform() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_ResetTextureAddressTransform() ;


		/// <summary> tHOLɂ邩ǂݒ肷( TRUE:L  FALSE: ) </summary>
		public static void SetFogEnable( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetFogEnable( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFogEnable( bool Flag ) ;


		/// <summary> tHO[hݒ肷 </summary>
		/// <param name="Mode"> DX_FOGMODE_NONE  </param>
		public static void SetFogMode( DX_FOGMODE Mode )
		{
			lock( locker )
			{
				int result = dx_SetFogMode( Mode ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFogMode( DX_FOGMODE Mode ) ;


		/// <summary> tHOJ[ύX </summary>
		public static void SetFogColor( int r , int g , int b )
		{
			lock( locker )
			{
				int result = dx_SetFogColor( r , g , b ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFogColor( int r , int g , int b ) ;


		/// <summary> tHOn܂鋗ƏI鋗ݒ肷( 0.0f ` 1.0f ) </summary>
		public static void SetFogStartEnd( float start , float end )
		{
			lock( locker )
			{
				int result = dx_SetFogStartEnd( start , end ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFogStartEnd( float start , float end ) ;


		/// <summary> tHO̖xݒ肷( 0.0f ` 1.0f ) </summary>
		public static void SetFogDensity( float density )
		{
			lock( locker )
			{
				int result = dx_SetFogDensity( density ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetFogDensity( float density ) ;


		/// <summary> VXeɃOtBbN쐬邩ǂ̃tOZbg( TRUE:VXeɍ쐬  FALSE:uq`lɍ쐬 ) </summary>
		public static void SetUseSystemMemGraphCreateFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseSystemMemGraphCreateFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseSystemMemGraphCreateFlag( bool Flag ) ;


		/// <summary> uq`lgp邩̃tOZbg </summary>
		public static void SetUseVramFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetUseVramFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseVramFlag( bool Flag ) ;


		/// <summary> cwCũOtBbN֘A̕As </summary>
		public static void RestoreGraphSystem()
		{
			lock( locker )
			{
				int result = dx_RestoreGraphSystem() ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_RestoreGraphSystem() ;


		/// <summary> Vistaȍ~ Windows Aero 𖳌ɂ邩ǂZbgATRUE:ɂ  FALSE:Lɂ( DxLib_Init ̑OɌĂԕKv܂ ) </summary>
		public static void SetAeroDisableFlag( bool Flag )
		{
			lock( locker )
			{
				int result = dx_SetAeroDisableFlag( Flag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetAeroDisableFlag( bool Flag ) ;


		/// <summary> ANeBuɂȂĂʂẅ̃OtBbN擾 </summary>
		public static void GetDrawScreenGraph( int x1 , int y1 , int x2 , int y2 , Graph GrHandle )
		{
			GetDrawScreenGraph( x1 , y1 , x2 , y2 , GrHandle , true ) ;
		}

		/// <summary> ANeBuɂȂĂʂẅ̃OtBbN擾 </summary>
		public static void GetDrawScreenGraph( int x1 , int y1 , int x2 , int y2 , Graph GrHandle , bool UseClientFlag )
		{
			lock( locker )
			{
				int result = dx_GetDrawScreenGraph( x1 , y1 , x2 , y2 , Graph.ToHandle( GrHandle ) , UseClientFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetDrawScreenGraph( int x1 , int y1 , int x2 , int y2 , int GrHandle , bool UseClientFlag ) ;


		/// <summary> w̉摜̂`qfaW̃tJ[C[W擾 </summary>
		/// <returns> int * </returns>
		public static IntPtr GetFullColorImage( Graph GrHandle )
		{
			lock( locker )
			{
				IntPtr result = dx_GetFullColorImage( Graph.ToHandle( GrHandle ) ) ;
				if( !( result != IntPtr.Zero ) ) { throw new DX.Exception(); }
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern IntPtr dx_GetFullColorImage( int GrHandle ) ;


		/// <summary> OtBbN̈̃bN </summary>
		public static void GraphLock( Graph GrHandle , out int PitchBuf , out IntPtr DataPointBuf )
		{
			IntPtr ColorDataPP ;
			GraphLock( GrHandle , out PitchBuf , out DataPointBuf , out ColorDataPP ) ;
		}

		/// <summary> OtBbN̈̃bN </summary>
		/// <param name="ColorDataPP"> COLORDATA ** </param>
		public static void GraphLock( Graph GrHandle , out int PitchBuf , out IntPtr DataPointBuf , out IntPtr ColorDataPP )
		{
			lock( locker )
			{
				int result = dx_GraphLock( Graph.ToHandle( GrHandle ) , out PitchBuf , out DataPointBuf , out ColorDataPP ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GraphLock( int GrHandle , out int PitchBuf , out IntPtr DataPointBuf , out IntPtr ColorDataPP ) ;


		/// <summary> OtBbN̈̃bN </summary>
		public static void GraphUnLock( Graph GrHandle )
		{
			lock( locker )
			{
				int result = dx_GraphUnLock( Graph.ToHandle( GrHandle ) ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GraphUnLock( int GrHandle ) ;


		/// <summary> OtBbNɂyobt@gp邩ǂݒ肷 </summary>
		public static void SetUseGraphZBuffer( Graph GrHandle , bool UseFlag )
		{
			lock( locker )
			{
				int result = dx_SetUseGraphZBuffer( Graph.ToHandle( GrHandle ) , UseFlag ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_SetUseGraphZBuffer( int GrHandle , bool UseFlag ) ;


		/// <summary> OtBbÑTCY𓾂 </summary>
		public static void GetGraphSize( Graph GrHandle , out int SizeXBuf , out int SizeYBuf )
		{
			lock( locker )
			{
				int result = dx_GetGraphSize( Graph.ToHandle( GrHandle ) , out SizeXBuf , out SizeYBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetGraphSize( int GrHandle , out int SizeXBuf , out int SizeYBuf ) ;


		/// <summary> ݂̉ʂ̑傫ƃJ[rbg𓾂  </summary>
		public static void GetScreenState( out int SizeX , out int SizeY , out int ColorBitDepth )
		{
			lock( locker )
			{
				int result = dx_GetScreenState( out SizeX , out SizeY , out ColorBitDepth ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetScreenState( out int SizeX , out int SizeY , out int ColorBitDepth ) ;


		/// <summary> `ɂRc@\gtO擾 </summary>
		public static bool GetUse3DFlag()
		{
			lock( locker )
			{
				int result = dx_GetUse3DFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUse3DFlag() ;


		/// <summary> OtBbN֐̗L擾 </summary>
		public static bool GetValidRestoreShredPoint()
		{
			lock( locker )
			{
				int result = dx_GetValidRestoreShredPoint() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetValidRestoreShredPoint() ;


		/// <summary> r[s擾 </summary>
		public static void GetTransformToViewMatrix( out MATRIX MatBuf )
		{
			lock( locker )
			{
				int result = dx_GetTransformToViewMatrix( out MatBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetTransformToViewMatrix( out MATRIX MatBuf ) ;


		/// <summary> [hs擾 </summary>
		public static void GetTransformToWorldMatrix( out MATRIX MatBuf )
		{
			lock( locker )
			{
				int result = dx_GetTransformToWorldMatrix( out MatBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetTransformToWorldMatrix( out MATRIX MatBuf ) ;


		/// <summary> ˉes擾 </summary>
		public static void GetTransformToProjectionMatrix( out MATRIX MatBuf )
		{
			lock( locker )
			{
				int result = dx_GetTransformToProjectionMatrix( out MatBuf ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetTransformToProjectionMatrix( out MATRIX MatBuf ) ;


		/// <summary> [JWʍW擾 </summary>
		public static void GetTransformPosition( out VECTOR LocalPos , out float x , out float y )
		{
			lock( locker )
			{
				int result = dx_GetTransformPosition( out LocalPos , out x , out y ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetTransformPosition( out VECTOR LocalPos , out float x , out float y ) ;


		/// <summary> [hWXN[Wɕϊ </summary>
		public static VECTOR ConvWorldPosToScreenPos( VECTOR WorldPos )
		{
			lock( locker )
			{
				VECTOR result = dx_ConvWorldPosToScreenPos( WorldPos ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_ConvWorldPosToScreenPos( VECTOR WorldPos ) ;


		/// <summary> XN[W[hWɕϊ </summary>
		public static VECTOR ConvScreenPosToWorldPos( VECTOR ScreenPos )
		{
			lock( locker )
			{
				VECTOR result = dx_ConvScreenPosToWorldPos( ScreenPos ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_ConvScreenPosToWorldPos( VECTOR ScreenPos ) ;


		/// <summary> XN[W[hWɕϊ( zW` ) </summary>
		public static VECTOR ConvScreenPosToWorldPos_ZLinear( VECTOR ScreenPos )
		{
			lock( locker )
			{
				VECTOR result = dx_ConvScreenPosToWorldPos_ZLinear( ScreenPos ) ;
				return result ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern VECTOR dx_ConvScreenPosToWorldPos_ZLinear( VECTOR ScreenPos ) ;


		/// <summary> QcOtBbNT[tFX쐬ɃVXe[gp邩̃tO擾 </summary>
		public static bool GetUseVramFlag()
		{
			lock( locker )
			{
				int result = dx_GetUseVramFlag() ;
				if( result == 0 ) { return false ; }
				else if( result == 1 ) { return true ; }
				else { throw new DX.Exception() ; }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetUseVramFlag() ;


		/// <summary> ꂩVɃOtBbN쐬ꍇɎgpJ[擾 </summary>
		public static void GetCreateGraphColorData( COLORDATA ColorData , out IMAGEFORMATDESC Format )
		{
			lock( locker )
			{
				int result = dx_GetCreateGraphColorData( ref ColorData , out Format ) ;
				if( !( result == 0 ) ) { throw new DX.Exception(); }
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_GetCreateGraphColorData( [ In ] ref COLORDATA ColorData , out IMAGEFORMATDESC Format ) ;


		/// <summary> GraphImage f[^TCYoAɍOtBbNnh쐬 </summary>
		public static Graph CreateDXGraph( BaseImage RgbImage , BaseImage AlphaImage , bool TextureFlag )
		{
			lock( locker )
			{
				int result = dx_CreateDXGraph( ref RgbImage.buffer , ref AlphaImage.buffer , TextureFlag ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_CreateDXGraph( [ In ] ref BASEIMAGE RgbImage , [ In ] ref BASEIMAGE AlphaImage , bool TextureFlag ) ;


		/// <summary> w̃OtBbN̎w蕔𔲂oĐVȃOtBbNnh쐬 </summary>
		public static Graph DerivationGraph( int SrcX , int SrcY , int Width , int Height , Graph SrcGraphHandle )
		{
			lock( locker )
			{
				int result = dx_DerivationGraph( SrcX , SrcY , Width , Height , Graph.ToHandle( SrcGraphHandle ) ) ;
				if( !( result != -1 ) ) { throw new DX.Exception(); }
				return Graph.FromHandle( result ) ;
			}
		}

	#if UNICODE
		[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
	#else
		[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
	#endif
		private static extern int dx_DerivationGraph( int SrcX , int SrcY , int Width , int Height , int SrcGraphHandle ) ;
	}
}
